/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.configuration.MemorySize;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Priority;
import org.eclipse.microprofile.config.spi.Converter;

@Priority(value=200)
public class MemorySizeConverter
implements Converter<MemorySize>,
Serializable {
    private static final Pattern MEMORY_SIZE_PATTERN = Pattern.compile("^(\\d+)([BbKkMmGgTtPpEeZzYy]?)$");
    static final BigInteger KILO_BYTES = BigInteger.valueOf(1024L);
    private static final Map<String, BigInteger> MEMORY_SIZE_MULTIPLIERS = new HashMap<String, BigInteger>();
    private static final long serialVersionUID = -1988485929047973068L;

    public MemorySize convert(String value) {
        if ((value = value.trim()).isEmpty()) {
            return null;
        }
        Matcher matcher = MEMORY_SIZE_PATTERN.matcher(value);
        if (matcher.find()) {
            BigInteger number = new BigInteger(matcher.group(1));
            String scale = matcher.group(2).toUpperCase();
            BigInteger multiplier = MEMORY_SIZE_MULTIPLIERS.get(scale);
            return multiplier == null ? new MemorySize(number) : new MemorySize(number.multiply(multiplier));
        }
        throw new IllegalArgumentException(String.format("value %s not in correct format (regular expression): [0-9]+[BbKkMmGgTtPpEeZzYy]?", value));
    }

    static {
        MEMORY_SIZE_MULTIPLIERS.put("K", KILO_BYTES);
        MEMORY_SIZE_MULTIPLIERS.put("M", KILO_BYTES.pow(2));
        MEMORY_SIZE_MULTIPLIERS.put("G", KILO_BYTES.pow(3));
        MEMORY_SIZE_MULTIPLIERS.put("T", KILO_BYTES.pow(4));
        MEMORY_SIZE_MULTIPLIERS.put("P", KILO_BYTES.pow(5));
        MEMORY_SIZE_MULTIPLIERS.put("E", KILO_BYTES.pow(6));
        MEMORY_SIZE_MULTIPLIERS.put("Z", KILO_BYTES.pow(7));
        MEMORY_SIZE_MULTIPLIERS.put("Y", KILO_BYTES.pow(8));
    }
}

