/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.deployment.configuration.NativeConfigUtils;
import io.quarkus.deployment.pkg.NativeConfig;
import java.util.List;
import java.util.Locale;
import java.util.function.BooleanSupplier;

public enum NativeImageFutureDefault {
    RUN_TIME_INITIALIZE_FILE_SYSTEM_PROVIDERS,
    RUN_TIME_INITIALIZE_SECURITY_PROVIDERS;

    private static final String FUTURE_DEFAULTS_MARKER = "--future-defaults=";

    public boolean isEnabled(NativeConfig nativeConfig) {
        return NativeImageFutureDefault.isFutureDefault(this, nativeConfig);
    }

    private static boolean isFutureDefault(NativeImageFutureDefault futureDefault, NativeConfig nativeConfig) {
        List<String> additionalBuildArgs = NativeConfigUtils.getNativeAdditionalBuildArgs(nativeConfig);
        for (String buildArg : additionalBuildArgs) {
            String[] futureDefaultStringArgs;
            String trimmedBuildArg = buildArg.trim();
            if (!trimmedBuildArg.contains(FUTURE_DEFAULTS_MARKER)) continue;
            int index = trimmedBuildArg.indexOf(61);
            for (String futureDefaultString : futureDefaultStringArgs = trimmedBuildArg.substring(index + 1).split(",")) {
                NativeImageFutureDefault futureDefaultArg;
                if ("all".equals(futureDefaultString)) {
                    return true;
                }
                if ("run-time-initialize-jdk".equals(futureDefaultString)) {
                    switch (futureDefault.ordinal()) {
                        case 0: 
                        case 1: {
                            return true;
                        }
                    }
                }
                if ((futureDefaultArg = NativeImageFutureDefault.valueOf(futureDefaultString.toUpperCase(Locale.ROOT).replace('-', '_'))) != futureDefault) continue;
                return true;
            }
        }
        return false;
    }

    public static final class RunTimeInitializeSecurityProvider
    extends AbstractNativeImageFutureDefaultBooleanSupplier {
        public RunTimeInitializeSecurityProvider(NativeConfig nativeConfig) {
            super(nativeConfig);
        }

        @Override
        public boolean getAsBoolean() {
            return NativeImageFutureDefault.isFutureDefault(RUN_TIME_INITIALIZE_SECURITY_PROVIDERS, this.nativeConfig);
        }
    }

    public static final class RunTimeInitializeFileSystemProvider
    extends AbstractNativeImageFutureDefaultBooleanSupplier {
        public RunTimeInitializeFileSystemProvider(NativeConfig nativeConfig) {
            super(nativeConfig);
        }

        @Override
        public boolean getAsBoolean() {
            return NativeImageFutureDefault.isFutureDefault(RUN_TIME_INITIALIZE_FILE_SYSTEM_PROVIDERS, this.nativeConfig);
        }
    }

    private static abstract class AbstractNativeImageFutureDefaultBooleanSupplier
    implements BooleanSupplier {
        protected final NativeConfig nativeConfig;

        public AbstractNativeImageFutureDefaultBooleanSupplier(NativeConfig nativeConfig) {
            this.nativeConfig = nativeConfig;
        }
    }
}

