/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.jvm;

import io.quarkus.deployment.builditem.ModuleOpenBuildItem;
import io.quarkus.deployment.jvm.JVMDeploymentLogger;
import io.quarkus.deployment.jvm.JvmModulesReconfigurer;
import io.quarkus.deployment.jvm.ModulesClassloaderContext;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.util.List;
import org.jboss.logging.Logger;

final class ReflectiveAccessModulesReconfigurer
implements JvmModulesReconfigurer {
    private static final Logger logger = JVMDeploymentLogger.logger;
    private final MethodHandle implAddOpensHandle = ReflectiveAccessModulesReconfigurer.methodHandleInit();

    ReflectiveAccessModulesReconfigurer() {
    }

    @Override
    public void openJavaModules(List<ModuleOpenBuildItem> addOpens, ModulesClassloaderContext modulesContext) {
        if (addOpens.isEmpty()) {
            return;
        }
        for (ModuleOpenBuildItem m : addOpens) {
            Module openedModule = modulesContext.findModule(m.openedModuleName());
            Module openingModule = modulesContext.findModule(m.openingModuleName());
            for (String packageName : m.packageNames()) {
                this.addOpens(openedModule, packageName, openingModule);
            }
        }
    }

    private static MethodHandle methodHandleInit() {
        try {
            Field lookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            lookupField.setAccessible(true);
            MethodHandles.Lookup privilegedLookup = (MethodHandles.Lookup)lookupField.get(null);
            MethodType methodType = MethodType.methodType(Void.TYPE, String.class, Module.class);
            MethodHandle handle = privilegedLookup.findVirtual(Module.class, "implAddOpens", methodType);
            logger.debug((Object)"Successfully acquired MethodHandle for implAddOpens.");
            return handle;
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InaccessibleObjectException e) {
            throw new RuntimeException("Failed to acquire handle to Module#implAddOpens. This must be run with JVM parameter '--add-opens=java.base/java.lang.invoke=ALL-UNNAMED'", e);
        }
    }

    private void addOpens(Module sourceModule, String packageName, Module targetModule) {
        try {
            this.implAddOpensHandle.invokeExact(sourceModule, packageName, targetModule);
            logger.debugf("Successfully opened module %s/%s to %s", (Object)sourceModule.getName(), (Object)packageName, (Object)(targetModule.isNamed() ? targetModule.getName() : "UNNAMED"));
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to invoke implAddOpens", e);
        }
    }
}

