/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.jvm;

import io.quarkus.deployment.builditem.ModuleOpenBuildItem;
import io.quarkus.deployment.jvm.JvmModulesReconfigurer;
import io.quarkus.deployment.jvm.ModulesClassloaderContext;
import java.util.List;
import jdk.internal.module.Modules;

final class DirectExportedModulesAPIModulesReconfigurer
implements JvmModulesReconfigurer {
    DirectExportedModulesAPIModulesReconfigurer() {
        DirectExportedModulesAPIModulesReconfigurer.testMethodAccessOrFail();
    }

    @Override
    public void openJavaModules(List<ModuleOpenBuildItem> addOpens, ModulesClassloaderContext modulesContext) {
        for (ModuleOpenBuildItem e : addOpens) {
            Module openedModule = modulesContext.findModule(e.openedModuleName());
            Module openingModule = modulesContext.findModule(e.openingModuleName());
            for (String packageName : e.packageNames()) {
                Modules.addOpens(openedModule, packageName, openingModule);
            }
        }
    }

    private static void testMethodAccessOrFail() {
        try {
            Modules.addOpens(null, null, null);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalAccessError e) {
            throw new RuntimeException("Failed to invoke jdk.internal.module.Modules.addOpens: --add-exports=java.base/jdk.internal.module=ALL-UNNAMED is required, but wasn't set.", e);
        }
    }
}

