/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.jvm;

import io.quarkus.deployment.builditem.ModuleOpenBuildItem;
import io.quarkus.deployment.jvm.JVMDeploymentLogger;
import io.quarkus.deployment.jvm.JvmModulesReconfigurer;
import io.quarkus.deployment.jvm.ModulesClassloaderContext;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.logging.Logger;

final class AgentBasedModulesReconfigurer
implements JvmModulesReconfigurer {
    private final Instrumentation instrumentation;
    private static final Logger logger = JVMDeploymentLogger.logger;

    AgentBasedModulesReconfigurer(Instrumentation instrumentation) {
        this.instrumentation = Objects.requireNonNull(instrumentation, "Instrumentation cannot be null");
        if (logger.isDebugEnabled()) {
            instrumentation.addTransformer(new UnnamedModulesTracker());
        }
    }

    private static void reportUnnamedModulesSet(Instrumentation inst) {
        Class[] allClasses;
        if (!logger.isDebugEnabled()) {
            return;
        }
        HashSet<Module> unnamedModules = new HashSet<Module>();
        unnamedModules.add(ClassLoader.getSystemClassLoader().getUnnamedModule());
        for (Class clazz : allClasses = inst.getAllLoadedClasses()) {
            ClassLoader loader = clazz.getClassLoader();
            if (loader == null) continue;
            Module m = loader.getUnnamedModule();
            unnamedModules.add(m);
        }
        long pid = ProcessHandle.current().pid();
        logger.debugf("Set of unnamed modules currently defined in process with pid=%d: %s", pid, unnamedModules);
    }

    @Override
    public void openJavaModules(List<ModuleOpenBuildItem> addOpens, ModulesClassloaderContext modulesContext) {
        if (addOpens.isEmpty()) {
            return;
        }
        AgentBasedModulesReconfigurer.reportUnnamedModulesSet(this.instrumentation);
        HashMap<Module, PerModuleOpenInstructions> aggregateByModule = new HashMap<Module, PerModuleOpenInstructions>();
        for (ModuleOpenBuildItem moduleOpenBuildItem : addOpens) {
            Module openedModule = modulesContext.findModule(moduleOpenBuildItem.openedModuleName());
            PerModuleOpenInstructions perModuleOpenInstructions = aggregateByModule.computeIfAbsent(openedModule, k -> new PerModuleOpenInstructions());
            Module openingModule = modulesContext.findModule(moduleOpenBuildItem.openingModuleName());
            for (String packageName : moduleOpenBuildItem.packageNames()) {
                perModuleOpenInstructions.addOpens(packageName, openingModule);
            }
        }
        for (Map.Entry entry : aggregateByModule.entrySet()) {
            this.addOpens((Module)entry.getKey(), ((PerModuleOpenInstructions)entry.getValue()).modulesToOpenToByPackage);
        }
    }

    private void addOpens(Module sourceModule, Map<String, Set<Module>> openInstructions) {
        if (logger.isDebugEnabled()) {
            openInstructions.forEach((pkg, modules) -> logger.debugf("Opening package %s of %s to modules %s", pkg, (Object)sourceModule, modules));
        }
        try {
            this.instrumentation.redefineModule(sourceModule, Set.of(), Map.of(), openInstructions, Set.of(), Map.of());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to redefine module " + sourceModule.getName());
        }
    }

    private static class UnnamedModulesTracker
    implements ClassFileTransformer {
        private final Set<Module> knownUnnamedModules = new CopyOnWriteArraySet<Module>();

        private UnnamedModulesTracker() {
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
            Module m;
            if (loader != null && this.knownUnnamedModules.add(m = loader.getUnnamedModule())) {
                logger.debugf("New unnamed module detected: %s", (Object)m);
            }
            return null;
        }
    }

    private static class PerModuleOpenInstructions {
        private final Map<String, Set<Module>> modulesToOpenToByPackage = new HashMap<String, Set<Module>>();

        private PerModuleOpenInstructions() {
        }

        public void addOpens(String packageName, Module openingModule) {
            Set modulesToOpenTo = this.modulesToOpenToByPackage.computeIfAbsent(packageName, k -> new HashSet());
            modulesToOpenTo.add(openingModule);
        }
    }
}

