/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem.nativeimage;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public final class ReflectiveHierarchyBuildItem
extends MultiBuildItem {
    private static final String UNKNOWN_SOURCE = "<unknown>";
    private final Type type;
    private final IndexView index;
    private final Predicate<DotName> ignoreTypePredicate;
    private final Predicate<FieldInfo> ignoreFieldPredicate;
    private final Predicate<MethodInfo> ignoreMethodPredicate;
    private final String source;
    private final boolean constructors;
    private final boolean methods;
    private final boolean fields;
    private final boolean serialization;
    private final boolean unsafeAllocated;
    private final boolean ignoreNested;

    @Deprecated
    public ReflectiveHierarchyBuildItem(Type type) {
        this(type, DefaultIgnoreTypePredicate.INSTANCE);
    }

    @Deprecated
    public ReflectiveHierarchyBuildItem(Type type, IndexView index) {
        this(type, index, DefaultIgnoreTypePredicate.INSTANCE);
    }

    @Deprecated
    public ReflectiveHierarchyBuildItem(Type type, Predicate<DotName> ignoreTypePredicate) {
        this(type, ignoreTypePredicate, UNKNOWN_SOURCE);
    }

    @Deprecated
    public ReflectiveHierarchyBuildItem(Type type, IndexView index, Predicate<DotName> ignoreTypePredicate) {
        this(type, index, ignoreTypePredicate, UNKNOWN_SOURCE);
    }

    @Deprecated
    public ReflectiveHierarchyBuildItem(Type type, String source) {
        this(type, DefaultIgnoreTypePredicate.INSTANCE, source);
    }

    @Deprecated
    public ReflectiveHierarchyBuildItem(Type type, IndexView index, String source) {
        this(type, index, DefaultIgnoreTypePredicate.INSTANCE, source);
    }

    @Deprecated
    public ReflectiveHierarchyBuildItem(Type type, Predicate<DotName> ignoreTypePredicate, String source) {
        this(type, null, ignoreTypePredicate, source);
    }

    @Deprecated
    public ReflectiveHierarchyBuildItem(Type type, IndexView index, Predicate<DotName> ignoreTypePredicate, String source) {
        this(type, index, ignoreTypePredicate, DefaultIgnoreFieldPredicate.INSTANCE, DefaultIgnoreMethodPredicate.INSTANCE, source, true, true, true, false, false, true);
    }

    private ReflectiveHierarchyBuildItem(Type type, IndexView index, Predicate<DotName> ignoreTypePredicate, Predicate<FieldInfo> ignoreFieldPredicate, Predicate<MethodInfo> ignoreMethodPredicate, String source, boolean constructors, boolean methods, boolean fields, boolean serialization, boolean unsafeAllocated, boolean ignoreNested) {
        this.type = type;
        this.index = index;
        this.ignoreTypePredicate = ignoreTypePredicate;
        this.ignoreFieldPredicate = ignoreFieldPredicate;
        this.ignoreMethodPredicate = ignoreMethodPredicate;
        this.source = source;
        this.constructors = constructors;
        this.methods = methods;
        this.fields = fields;
        this.serialization = serialization;
        this.unsafeAllocated = unsafeAllocated;
        this.ignoreNested = ignoreNested;
    }

    public Type getType() {
        return this.type;
    }

    public IndexView getIndex() {
        return this.index;
    }

    public Predicate<DotName> getIgnoreTypePredicate() {
        return this.ignoreTypePredicate;
    }

    public Predicate<FieldInfo> getIgnoreFieldPredicate() {
        return this.ignoreFieldPredicate;
    }

    public Predicate<MethodInfo> getIgnoreMethodPredicate() {
        return this.ignoreMethodPredicate;
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public boolean isConstructors() {
        return this.constructors;
    }

    public boolean isMethods() {
        return this.methods;
    }

    public boolean isFields() {
        return this.fields;
    }

    public boolean isSerialization() {
        return this.serialization;
    }

    public boolean isUnsafeAllocated() {
        return this.unsafeAllocated;
    }

    public boolean isIgnoreNested() {
        return this.ignoreNested;
    }

    public String getSource() {
        return this.source;
    }

    public static Builder builder(Class<?> clazz) {
        return ReflectiveHierarchyBuildItem.builder(clazz.getName());
    }

    public static Builder builder(String className) {
        return ReflectiveHierarchyBuildItem.builder(DotName.createSimple((String)className));
    }

    public static Builder builder(DotName className) {
        return ReflectiveHierarchyBuildItem.builder(Type.create((DotName)className, (Type.Kind)Type.Kind.CLASS));
    }

    public static Builder builder(Type type) {
        return new Builder(type);
    }

    public static class DefaultIgnoreTypePredicate
    implements Predicate<DotName> {
        public static final DefaultIgnoreTypePredicate INSTANCE = new DefaultIgnoreTypePredicate();
        private static final List<String> DEFAULT_IGNORED_PACKAGES = Arrays.asList("java.", "io.reactivex.", "org.reactivestreams.", "org.slf4j.", "jakarta.", "jakarta.json.", "javax.net.ssl.", "javax.xml.", "javax.management.", "reactor.core.", "com.fasterxml.jackson.databind.", "io.vertx.core.json.", "kotlin.", "javax.sql.", "javax.naming.");
        static final Set<String> ALLOWED_FROM_IGNORED_PACKAGES = new HashSet<String>(Arrays.asList("java.math.BigDecimal", "java.math.BigInteger"));
        static final List<String> PRIMITIVE = Arrays.asList("boolean", "byte", "char", "short", "int", "long", "float", "double");

        @Override
        public boolean test(DotName dotName) {
            String name = dotName.toString();
            if (PRIMITIVE.contains(name)) {
                return true;
            }
            for (String containerPackageName : DEFAULT_IGNORED_PACKAGES) {
                if (!name.startsWith(containerPackageName)) continue;
                return !ALLOWED_FROM_IGNORED_PACKAGES.contains(name);
            }
            return false;
        }
    }

    public static class DefaultIgnoreFieldPredicate
    implements Predicate<FieldInfo> {
        public static DefaultIgnoreFieldPredicate INSTANCE = new DefaultIgnoreFieldPredicate();

        @Override
        public boolean test(FieldInfo fieldInfo) {
            return false;
        }
    }

    public static class DefaultIgnoreMethodPredicate
    implements Predicate<MethodInfo> {
        public static DefaultIgnoreMethodPredicate INSTANCE = new DefaultIgnoreMethodPredicate();

        @Override
        public boolean test(MethodInfo methodInfo) {
            return false;
        }
    }

    public static class Builder {
        private Type type;
        private IndexView index;
        private Predicate<DotName> ignoreTypePredicate = DefaultIgnoreTypePredicate.INSTANCE;
        private Predicate<FieldInfo> ignoreFieldPredicate = DefaultIgnoreFieldPredicate.INSTANCE;
        private Predicate<MethodInfo> ignoreMethodPredicate = DefaultIgnoreMethodPredicate.INSTANCE;
        private String source = "<unknown>";
        private boolean constructors = true;
        private boolean methods = true;
        private boolean fields = true;
        private boolean serialization;
        private boolean unsafeAllocated;
        private boolean ignoreNested = true;

        @Deprecated(since="3.12", forRemoval=true)
        public Builder() {
        }

        private Builder(Type type) {
            this.type = type;
        }

        @Deprecated(since="3.12", forRemoval=true)
        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        @Deprecated(since="3.12", forRemoval=true)
        public Builder className(DotName className) {
            return this.type(Type.create((DotName)className, (Type.Kind)Type.Kind.CLASS));
        }

        @Deprecated(since="3.12", forRemoval=true)
        public Builder className(String className) {
            return this.className(DotName.createSimple((String)className));
        }

        public Builder index(IndexView index) {
            this.index = index;
            return this;
        }

        public Builder ignoreTypePredicate(Predicate<DotName> ignoreTypePredicate) {
            this.ignoreTypePredicate = ignoreTypePredicate;
            return this;
        }

        public Builder ignoreFieldPredicate(Predicate<FieldInfo> ignoreFieldPredicate) {
            this.ignoreFieldPredicate = ignoreFieldPredicate;
            return this;
        }

        public Builder ignoreMethodPredicate(Predicate<MethodInfo> ignoreMethodPredicate) {
            this.ignoreMethodPredicate = ignoreMethodPredicate;
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder constructors(boolean constructors) {
            this.constructors = constructors;
            return this;
        }

        public Builder methods(boolean methods) {
            this.methods = methods;
            return this;
        }

        public Builder fields(boolean fields) {
            this.fields = fields;
            return this;
        }

        public Builder serialization(boolean serialization) {
            this.serialization = serialization;
            return this;
        }

        public Builder unsafeAllocated(boolean unsafeAllocated) {
            this.unsafeAllocated = unsafeAllocated;
            return this;
        }

        public Builder ignoreNested(boolean ignoreNested) {
            this.ignoreNested = ignoreNested;
            return this;
        }

        public ReflectiveHierarchyBuildItem build() {
            return new ReflectiveHierarchyBuildItem(this.type, this.index, this.ignoreTypePredicate, this.ignoreFieldPredicate, this.ignoreMethodPredicate, this.source, this.constructors, this.methods, this.fields, this.serialization, this.unsafeAllocated, this.ignoreNested);
        }
    }

    public static class IgnoreAllowListedPredicate
    implements Predicate<DotName> {
        public static IgnoreAllowListedPredicate INSTANCE = new IgnoreAllowListedPredicate();

        @Override
        public boolean test(DotName dotName) {
            return DefaultIgnoreTypePredicate.ALLOWED_FROM_IGNORED_PACKAGES.contains(dotName.toString());
        }
    }
}

