/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem;

import io.quarkus.builder.item.MultiBuildItem;
import io.smallrye.common.constraint.Assert;
import java.util.Set;

public final class ModuleOpenBuildItem
extends MultiBuildItem {
    static final String ALL_UNNAMED = "ALL-UNNAMED";
    private final String openedModuleName;
    private final String openingModuleName;
    private final Set<String> packageNames;

    public ModuleOpenBuildItem(String openedModuleName, String openingModuleName, String ... packageNames) {
        this.openedModuleName = Assert.checkNotEmptyParam((String)"openedModuleName", (String)openedModuleName);
        this.openingModuleName = Assert.checkNotEmptyParam((String)"openingModuleName", (String)openingModuleName);
        this.packageNames = (Set)Assert.checkNotEmptyParam((String)"packageNames", Set.of(packageNames));
        if (packageNames.length == 0) {
            throw new IllegalArgumentException("At least one package name must be specified");
        }
        if (ALL_UNNAMED.equals(openedModuleName)) {
            throw new IllegalArgumentException("The unnamed module cannot be opened to other modules");
        }
        if (ALL_UNNAMED.equals(openingModuleName)) {
            throw new IllegalArgumentException("The unnamed module cannot be used as an opening module identifier: please read the Javadocs for more details");
        }
    }

    public String openedModuleName() {
        return this.openedModuleName;
    }

    public String openingModuleName() {
        return this.openingModuleName;
    }

    public Set<String> packageNames() {
        return this.packageNames;
    }

    public String toString() {
        return "ModuleOpenBuildItem{openedModule='" + this.openedModuleName + "', openingModule='" + this.openingModuleName + "', packages=" + String.valueOf(this.packageNames) + "}";
    }
}

