/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem;

import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.builditem.DevServicesCustomizerBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.Startable;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.DevServicesConfig;
import io.quarkus.devservices.crossclassloader.runtime.ComparableDevServicesConfig;
import io.quarkus.devservices.crossclassloader.runtime.DevServiceOwner;
import io.quarkus.devservices.crossclassloader.runtime.RunningDevServicesRegistry;
import io.quarkus.devservices.crossclassloader.runtime.RunningService;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public final class DevServicesRegistryBuildItem
extends SimpleBuildItem {
    private static final Logger log = Logger.getLogger(DevServicesRegistryBuildItem.class);
    private final UUID uuid;
    private final DevServicesConfig globalConfig;
    private final LaunchMode launchMode;

    public DevServicesRegistryBuildItem(UUID uuid, DevServicesConfig devServicesConfig, LaunchMode launchMode) {
        this.launchMode = launchMode;
        this.uuid = uuid;
        this.globalConfig = devServicesConfig;
    }

    public RunningService getRunningServices(String featureName, String configName, Object identifyingConfig) {
        DevServiceOwner owner = new DevServiceOwner(featureName, this.launchMode.name(), configName);
        ComparableDevServicesConfig key = new ComparableDevServicesConfig(this.uuid, owner, (Object)this.globalConfig, identifyingConfig);
        return RunningDevServicesRegistry.INSTANCE.getRunningServices(key);
    }

    public void addRunningService(String featureName, String configName, Object identifyingConfig, RunningService service) {
        DevServiceOwner owner = new DevServiceOwner(featureName, this.launchMode.name(), configName);
        ComparableDevServicesConfig key = new ComparableDevServicesConfig(this.uuid, owner, (Object)this.globalConfig, identifyingConfig);
        RunningDevServicesRegistry.INSTANCE.addRunningService(key, service);
    }

    public void closeAllRunningServices(String featureName, String configName) {
        DevServiceOwner owner = new DevServiceOwner(featureName, this.launchMode.name(), configName);
        RunningDevServicesRegistry.INSTANCE.closeAllRunningServices(owner);
    }

    public void closeAllRunningServices() {
        RunningDevServicesRegistry.INSTANCE.closeAllRunningServices(this.launchMode.name());
    }

    public void closeRemainingRunningServices(Collection<DevServicesResultBuildItem> services) {
        Set ownersToKeep = services.stream().map(s -> new DevServiceOwner(s.getName(), this.launchMode.name(), s.getServiceName())).collect(Collectors.toSet());
        RunningDevServicesRegistry.INSTANCE.closeRemainingRunningServices(this.uuid, this.launchMode.name(), ownersToKeep);
    }

    public Map<String, String> getConfigForAllRunningServices() {
        HashMap<String, String> config = new HashMap<String, String>();
        for (RunningService service : RunningDevServicesRegistry.INSTANCE.getAllRunningServices(this.launchMode.name())) {
            config.putAll(service.configs());
        }
        return config;
    }

    public void startAll(Collection<DevServicesResultBuildItem> services, List<DevServicesCustomizerBuildItem> customizers, ClassLoader augmentClassLoader) {
        this.closeRemainingRunningServices(services);
        ConcurrentHashMap<String, String> config = new ConcurrentHashMap<String, String>();
        this.startSelectedServices(services, customizers, augmentClassLoader, dr -> !dr.hasDependencies(), config);
        this.startSelectedServices(services, customizers, augmentClassLoader, DevServicesResultBuildItem::hasDependencies, config);
    }

    private void startSelectedServices(Collection<DevServicesResultBuildItem> services, List<DevServicesCustomizerBuildItem> customizers, ClassLoader augmentClassLoader, Predicate<? super DevServicesResultBuildItem> filter, Map<String, String> config) {
        CompletableFuture.allOf((CompletableFuture[])services.stream().filter(DevServicesResultBuildItem::isStartable).filter(filter).map(serv -> CompletableFuture.runAsync(() -> {
            if (augmentClassLoader != null) {
                Thread.currentThread().setContextClassLoader(augmentClassLoader);
            } else {
                Thread.currentThread().setContextClassLoader(((Object)serv).getClass().getClassLoader());
            }
            this.start((DevServicesResultBuildItem)((Object)serv), customizers, config);
        })).toArray(CompletableFuture[]::new)).join();
    }

    public void start(DevServicesResultBuildItem request, List<DevServicesCustomizerBuildItem> customizers, Map<String, String> config) {
        RunningService matchedDevService = this.getRunningServices(request.getName(), request.getServiceName(), request.getServiceConfig());
        if (matchedDevService == null) {
            this.closeAllRunningServices(request.getName(), request.getServiceName());
            this.reallyStart(request, customizers, config);
        }
    }

    private void reallyStart(DevServicesResultBuildItem request, List<DevServicesCustomizerBuildItem> customizers, Map<String, String> configs) {
        StartupLogCompressor compressor = new StartupLogCompressor("Dev Services Startup", null, null);
        try {
            Set<DevServicesResultBuildItem.DevServiceConfigDependency<? extends Startable>> optionalDependencies;
            Supplier<Startable> startableSupplier = request.getStartableSupplier();
            if (startableSupplier == null) {
                throw new IllegalStateException("Dev services for " + request.getName() + " requires a startable supplier, but none was provided.");
            }
            Startable startable = startableSupplier.get();
            for (DevServicesCustomizerBuildItem customizer : customizers) {
                startable = customizer.apply(request, startable);
            }
            String missingDependency = null;
            Set<DevServicesResultBuildItem.DevServiceConfigDependency<? extends Startable>> dependencies = request.getDependencies();
            if (dependencies != null && !dependencies.isEmpty()) {
                for (DevServicesResultBuildItem.DevServiceConfigDependency<? extends Startable> dependency : dependencies) {
                    String string = configs.get(dependency.requiredConfigKey());
                    if (string != null) {
                        dependency.valueInjector().accept(startable, string);
                        continue;
                    }
                    missingDependency = dependency.requiredConfigKey();
                }
            }
            if ((optionalDependencies = request.getOptionalDependencies()) != null && !optionalDependencies.isEmpty()) {
                for (DevServicesResultBuildItem.DevServiceConfigDependency devServiceConfigDependency : optionalDependencies) {
                    String value = configs.get(devServiceConfigDependency.requiredConfigKey());
                    if (value == null) continue;
                    devServiceConfigDependency.valueInjector().accept(startable, value);
                }
            }
            if (missingDependency == null) {
                startable.start();
                Map<String, String> config = request.getConfig(startable);
                Map<String, String> map = request.getOverrideConfig(startable);
                configs.putAll(config);
                configs.putAll(map);
                RunningService service = new RunningService(request.getName(), request.getDescription(), config, map, startable.getContainerId(), (Closeable)startable);
                this.addRunningService(request.getName(), request.getServiceName(), request.getServiceConfig(), service);
                compressor.close();
                Consumer<Startable> postStartAction = request.getPostStartAction();
                if (postStartAction != null) {
                    try {
                        postStartAction.accept(startable);
                    }
                    catch (Throwable t) {
                        log.errorf(t, "An error occurred while executing the post-start action for %s dev service: %s", (Object)request.getName(), (Object)t.getMessage());
                    }
                } else {
                    log.infof("The %s dev service is ready to accept connections on %s", (Object)request.getName(), (Object)startable.getConnectionInfo());
                }
            } else {
                log.infof("The %s dev service did not start because the configuration with key %s did not become available", (Object)request.getName(), missingDependency);
            }
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw t;
        }
    }
}

