/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.builditem;

import io.quarkus.builder.item.SimpleBuildItem;

public final class CompiledJavaVersionBuildItem
extends SimpleBuildItem {
    private final JavaVersion javaVersion;

    private CompiledJavaVersionBuildItem(JavaVersion javaVersion) {
        this.javaVersion = javaVersion;
    }

    public static CompiledJavaVersionBuildItem unknown() {
        return new CompiledJavaVersionBuildItem(new JavaVersion.Unknown());
    }

    public static CompiledJavaVersionBuildItem fromMajorJavaVersion(int majorJavaVersion) {
        return new CompiledJavaVersionBuildItem(new JavaVersion.Known(majorJavaVersion));
    }

    public JavaVersion getJavaVersion() {
        return this.javaVersion;
    }

    public static interface JavaVersion {
        public Status isJava11OrHigher();

        public Status isJava17OrHigher();

        public static final class Known
        implements JavaVersion {
            private static final int JAVA_11_MAJOR = 55;
            private static final int JAVA_17_MAJOR = 61;
            private final int determinedMajor;

            Known(int determinedMajor) {
                this.determinedMajor = determinedMajor;
            }

            @Override
            public Status isJava11OrHigher() {
                return this.getStatus(55);
            }

            @Override
            public Status isJava17OrHigher() {
                return this.getStatus(61);
            }

            private Status getStatus(int javaMajor) {
                return this.determinedMajor >= javaMajor ? Status.TRUE : Status.FALSE;
            }
        }

        public static final class Unknown
        implements JavaVersion {
            Unknown() {
            }

            @Override
            public Status isJava11OrHigher() {
                return Status.UNKNOWN;
            }

            @Override
            public Status isJava17OrHigher() {
                return Status.UNKNOWN;
            }
        }

        public static enum Status {
            TRUE,
            FALSE,
            UNKNOWN;

        }
    }
}

