/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.testing;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.deployment.dev.ClassScanResult;
import io.quarkus.deployment.dev.CompilationProvider;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.QuarkusCompiler;
import io.quarkus.deployment.dev.RuntimeUpdatesProcessor;
import io.quarkus.deployment.dev.testing.ModuleTestRunner;
import io.quarkus.deployment.dev.testing.TestClassResult;
import io.quarkus.deployment.dev.testing.TestConfig;
import io.quarkus.deployment.dev.testing.TestController;
import io.quarkus.deployment.dev.testing.TestListener;
import io.quarkus.deployment.dev.testing.TestResult;
import io.quarkus.deployment.dev.testing.TestRunListener;
import io.quarkus.deployment.dev.testing.TestRunResults;
import io.quarkus.deployment.dev.testing.TestState;
import io.quarkus.deployment.dev.testing.TestType;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.dev.testing.TestWatchedFiles;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import io.quarkus.runtime.configuration.HyphenateEnumConverter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.junit.platform.launcher.TestIdentifier;

public class TestSupport
implements TestController {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.test");
    private static final AtomicLong COUNTER = new AtomicLong();
    final CuratedApplication curatedApplication;
    final List<CompilationProvider> compilationProviders;
    final DevModeContext context;
    final List<ModuleTestRunner> moduleRunners = new ArrayList<ModuleTestRunner>();
    final List<TestListener> testListeners = new CopyOnWriteArrayList<TestListener>();
    final DevModeType devModeType;
    volatile QuarkusCompiler compiler;
    volatile boolean started;
    volatile TestRunResults testRunResults;
    volatile List<String> includeTags = Collections.emptyList();
    volatile List<String> excludeTags = Collections.emptyList();
    volatile Pattern include = null;
    volatile Pattern exclude = null;
    volatile boolean displayTestOutput;
    volatile Boolean explicitDisplayTestOutput;
    volatile boolean brokenOnlyMode;
    volatile TestType testType = TestType.ALL;
    private boolean testsRunning = false;
    private boolean testsQueued = false;
    private ClassScanResult queuedChanges = null;
    private Throwable compileProblem;
    private volatile boolean firstRun = true;
    String appPropertiesIncludeTags;
    String appPropertiesExcludeTags;
    String appPropertiesIncludePattern;
    String appPropertiesExcludePattern;
    String appPropertiesTestType;
    private TestConfig config;
    private volatile boolean closed;

    public TestSupport(CuratedApplication curatedApplication, List<CompilationProvider> compilationProviders, DevModeContext context, DevModeType devModeType) {
        this.curatedApplication = curatedApplication;
        this.compilationProviders = compilationProviders;
        this.context = context;
        this.devModeType = devModeType;
    }

    public static Optional<TestSupport> instance() {
        if (RuntimeUpdatesProcessor.INSTANCE == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(RuntimeUpdatesProcessor.INSTANCE.getTestSupport());
    }

    public synchronized boolean isRunning() {
        return this.testsRunning;
    }

    public List<TestListener> getTestListeners() {
        return this.testListeners;
    }

    public RunStatus getStatus() {
        long last = -1L;
        long runningTestRunId = this.getRunningTestRunId();
        TestRunResults tr = this.testRunResults;
        if (tr != null) {
            last = tr.getId();
        }
        return new RunStatus(last, runningTestRunId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!this.started) {
            TestSupport testSupport = this;
            synchronized (testSupport) {
                if (!this.started) {
                    try {
                        this.started = true;
                        this.init();
                        for (TestListener i : this.testListeners) {
                            i.testsEnabled();
                        }
                        if (this.firstRun) {
                            this.runTests();
                        }
                        this.firstRun = false;
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to create compiler, runtime compilation will be unavailable", (Throwable)e);
                    }
                }
            }
        }
    }

    public void init() {
        if (this.moduleRunners.isEmpty()) {
            TestWatchedFiles.setWatchedFilesListener(s -> RuntimeUpdatesProcessor.INSTANCE.setWatchedFilePaths((Map<String, Boolean>)s, true));
            for (DevModeContext.ModuleInfo module : this.context.getAllModules()) {
                Pattern p;
                boolean mainModule;
                boolean bl = mainModule = module == this.context.getApplicationRoot();
                if (this.config.onlyTestApplicationModule && !mainModule || (this.config.includeModulePattern.isPresent() ? !(p = Pattern.compile(this.config.includeModulePattern.get())).matcher(module.getArtifactKey().getGroupId() + ":" + module.getArtifactKey().getArtifactId()).matches() : this.config.excludeModulePattern.isPresent() && (p = Pattern.compile(this.config.excludeModulePattern.get())).matcher(module.getArtifactKey().getGroupId() + ":" + module.getArtifactKey().getArtifactId()).matches())) continue;
                try {
                    LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
                    module.getTest().ifPresent(test -> {
                        paths.add(Paths.get(test.getClassesPath(), new String[0]));
                        if (test.getResourcesOutputPath() != null) {
                            paths.add(Paths.get(test.getResourcesOutputPath(), new String[0]));
                        }
                    });
                    if (mainModule) {
                        this.curatedApplication.getQuarkusBootstrap().getApplicationRoot().forEach(paths::add);
                    } else {
                        paths.add(Paths.get(module.getMain().getClassesPath(), new String[0]));
                    }
                    for (Path path : paths) {
                        if (Files.exists(path, new LinkOption[0])) continue;
                        Files.createDirectories(path, new FileAttribute[0]);
                    }
                    QuarkusBootstrap.Builder builder = this.curatedApplication.getQuarkusBootstrap().clonedBuilder().setMode(QuarkusBootstrap.Mode.TEST).setAssertionsEnabled(true).setDisableClasspathCache(false).setIsolateDeployment(true).setExistingModel(null).setBaseClassLoader(this.getClass().getClassLoader().getParent()).setTest(true).setAuxiliaryApplication(true).setHostApplicationIsTestOnly(this.devModeType == DevModeType.TEST_ONLY).setProjectRoot(Paths.get(module.getProjectDirectory(), new String[0])).setApplicationRoot((PathCollection)PathList.from(paths)).clearLocalArtifacts();
                    for (ArtifactKey i3 : this.curatedApplication.getApplicationModel().getParentFirst()) {
                        builder.addParentFirstArtifact(i3);
                    }
                    final CuratedApplication curatedApplication = builder.build().bootstrap();
                    if (mainModule) {
                        this.compiler = new QuarkusCompiler(curatedApplication, this.compilationProviders, this.context);
                    }
                    ModuleTestRunner testRunner = new ModuleTestRunner(this, this.context, curatedApplication, module);
                    QuarkusClassLoader cl = (QuarkusClassLoader)this.getClass().getClassLoader();
                    cl.addCloseTask(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                TestSupport.this.close();
                            }
                            finally {
                                curatedApplication.close();
                            }
                        }
                    });
                    this.moduleRunners.add(testRunner);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public synchronized void close() {
        this.closed = true;
        this.stop();
    }

    public synchronized void stop() {
        if (this.started) {
            this.started = false;
            for (TestListener i : this.testListeners) {
                i.testsDisabled();
            }
        }
        for (ModuleTestRunner runner : this.moduleRunners) {
            runner.abort();
        }
    }

    public void runTests() {
        this.runTests(null);
    }

    @Override
    public void runFailedTests() {
        this.runTests(null, true, false);
    }

    public void runTests(ClassScanResult classScanResult) {
        this.runTests(classScanResult, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTests(final ClassScanResult classScanResult, final boolean reRunFailures, boolean runningQueued) {
        if (this.compileProblem != null) {
            return;
        }
        if (!this.started) {
            return;
        }
        if (reRunFailures && this.testRunResults == null) {
            return;
        }
        if (reRunFailures && this.testRunResults.getCurrentFailing().isEmpty()) {
            log.error((Object)"Not re-running failed tests, as all tests passed");
            return;
        }
        TestSupport testSupport = this;
        synchronized (testSupport) {
            if (this.testsRunning && !runningQueued) {
                if (reRunFailures) {
                    log.error((Object)"Not re-running failed tests, as tests are already in progress.");
                    return;
                }
                if (this.testsQueued) {
                    if (this.queuedChanges != null) {
                        this.queuedChanges = ClassScanResult.merge(this.queuedChanges, classScanResult);
                    }
                } else {
                    this.testsQueued = true;
                    this.queuedChanges = classScanResult;
                }
                return;
            }
            this.testsRunning = true;
        }
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    try {
                        TestSupport.this.runInternal(classScanResult, reRunFailures);
                    }
                    finally {
                        boolean run = false;
                        ClassScanResult current = null;
                        TestSupport testSupport = TestSupport.this;
                        synchronized (testSupport) {
                            if (TestSupport.this.started) {
                                if (TestSupport.this.testsQueued) {
                                    TestSupport.this.testsQueued = false;
                                    run = true;
                                } else {
                                    TestSupport.this.testsRunning = false;
                                }
                                current = TestSupport.this.queuedChanges;
                                TestSupport.this.queuedChanges = null;
                            }
                        }
                        if (run) {
                            TestSupport.this.runTests(current, false, true);
                        }
                    }
                }
                catch (Throwable t) {
                    log.error((Object)"Internal error running tests", t);
                }
            }
        }, "Test runner thread");
        t.setDaemon(true);
        t.start();
    }

    void runInternal(ClassScanResult classScanResult, boolean reRunFailures) {
        TestRunResults testRunResults;
        long runId = COUNTER.incrementAndGet();
        this.handleApplicationPropertiesChange();
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        final ArrayList testRunListeners = new ArrayList();
        for (TestListener i : this.testListeners) {
            i.testRunStarted(testRunListeners::add);
        }
        long start = System.currentTimeMillis();
        final AtomicLong testCount = new AtomicLong();
        final ArrayList allResults = new ArrayList();
        for (ModuleTestRunner moduleTestRunner : this.moduleRunners) {
            runnables.add(moduleTestRunner.prepare(classScanResult, reRunFailures, runId, new TestRunListener(){

                @Override
                public void runStarted(long toRun) {
                    testCount.addAndGet(toRun);
                }

                @Override
                public void testComplete(TestResult result) {
                    for (TestRunListener i : testRunListeners) {
                        i.testComplete(result);
                    }
                }

                @Override
                public void runComplete(TestRunResults results) {
                    allResults.add(results);
                }

                @Override
                public void runAborted() {
                    for (TestRunListener i : testRunListeners) {
                        i.runAborted();
                    }
                }

                @Override
                public void testStarted(TestIdentifier testIdentifier, String className) {
                    for (TestRunListener i : testRunListeners) {
                        i.testStarted(testIdentifier, className);
                    }
                }

                @Override
                public void noTests(TestRunResults results) {
                    allResults.add(results);
                    this.runStarted(0L);
                }
            }));
        }
        if (testCount.get() == 0L) {
            TestRunResults results2 = new TestRunResults(runId, classScanResult, classScanResult == null, start, System.currentTimeMillis(), Collections.emptyMap());
            for (Object i : testRunListeners) {
                i.noTests(results2);
            }
        }
        for (TestRunListener testRunListener : testRunListeners) {
            testRunListener.runStarted(testCount.get());
        }
        for (Runnable runnable : runnables) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                log.error((Object)"Failed to run test module", (Throwable)e);
            }
        }
        HashMap<String, TestClassResult> aggregate = new HashMap<String, TestClassResult>();
        for (Object i : allResults) {
            aggregate.putAll(((TestRunResults)i).getResults());
        }
        this.testRunResults = testRunResults = new TestRunResults(runId, classScanResult, classScanResult == null, start, System.currentTimeMillis(), aggregate);
        if (!this.closed) {
            for (TestRunListener i : testRunListeners) {
                i.runComplete(testRunResults);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(TestListener listener) {
        boolean run = false;
        TestSupport testSupport = this;
        synchronized (testSupport) {
            this.testListeners.add(listener);
            if (this.started) {
                run = true;
            }
        }
        listener.listenerRegistered(this);
        if (run) {
            listener.testsEnabled();
        }
    }

    private void handleApplicationPropertiesChange() {
        for (Path rootPath : this.curatedApplication.getQuarkusBootstrap().getApplicationRoot()) {
            Path appProps = rootPath.resolve("application.properties");
            if (!Files.exists(appProps, new LinkOption[0])) continue;
            Properties p = new Properties();
            try (InputStream in = Files.newInputStream(appProps, new OpenOption[0]);){
                p.load(in);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String includeTags = p.getProperty("quarkus.test.include-tags");
            String excludeTags = p.getProperty("quarkus.test.exclude-tags");
            String includePattern = p.getProperty("quarkus.test.include-pattern");
            String excludePattern = p.getProperty("quarkus.test.exclude-pattern");
            String testType = p.getProperty("quarkus.test.type");
            if (!this.firstRun) {
                if (!Objects.equals(includeTags, this.appPropertiesIncludeTags)) {
                    this.includeTags = includeTags == null ? Collections.emptyList() : Arrays.stream(includeTags.split(",")).map(String::trim).collect(Collectors.toList());
                }
                if (!Objects.equals(excludeTags, this.appPropertiesExcludeTags)) {
                    this.excludeTags = excludeTags == null ? Collections.emptyList() : Arrays.stream(excludeTags.split(",")).map(String::trim).collect(Collectors.toList());
                }
                if (!Objects.equals(includePattern, this.appPropertiesIncludePattern)) {
                    this.include = includePattern == null ? null : Pattern.compile(includePattern);
                }
                if (!Objects.equals(excludePattern, this.appPropertiesExcludePattern)) {
                    this.exclude = excludePattern == null ? null : Pattern.compile(excludePattern);
                }
                if (!Objects.equals(testType, this.appPropertiesTestType)) {
                    this.testType = testType == null ? TestType.ALL : (TestType)new HyphenateEnumConverter(TestType.class).convert(testType);
                }
            }
            this.appPropertiesIncludeTags = includeTags;
            this.appPropertiesExcludeTags = excludeTags;
            this.appPropertiesIncludePattern = includePattern;
            this.appPropertiesExcludePattern = excludePattern;
            this.appPropertiesTestType = testType;
            break;
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public CuratedApplication getCuratedApplication() {
        return this.curatedApplication;
    }

    public QuarkusCompiler getCompiler() {
        return this.compiler;
    }

    public TestRunResults getTestRunResults() {
        return this.testRunResults;
    }

    public TestRunResults getResults() {
        return this.testRunResults;
    }

    public synchronized long getRunningTestRunId() {
        if (this.testsRunning) {
            return COUNTER.get();
        }
        return -1L;
    }

    public void setTags(List<String> includeTags, List<String> excludeTags) {
        this.includeTags = includeTags;
        this.excludeTags = excludeTags;
    }

    public void setPatterns(String include, String exclude) {
        this.include = include == null ? null : Pattern.compile(include);
        this.exclude = exclude == null ? null : Pattern.compile(exclude);
    }

    public TestSupport setConfiguredDisplayTestOutput(boolean displayTestOutput) {
        if (this.explicitDisplayTestOutput != null) {
            this.displayTestOutput = displayTestOutput;
        }
        this.displayTestOutput = displayTestOutput;
        return this;
    }

    public TestSupport setTestType(TestType testType) {
        this.testType = testType;
        return this;
    }

    @Override
    public TestState currentState() {
        return TestState.merge(this.moduleRunners.stream().map(ModuleTestRunner::getTestState).collect(Collectors.toList()));
    }

    @Override
    public void runAllTests() {
        this.runTests();
    }

    @Override
    public void setDisplayTestOutput(boolean displayTestOutput) {
        this.explicitDisplayTestOutput = displayTestOutput;
        this.displayTestOutput = displayTestOutput;
    }

    @Override
    public boolean toggleBrokenOnlyMode() {
        boolean bl = this.brokenOnlyMode = !this.brokenOnlyMode;
        if (this.brokenOnlyMode) {
            log.info((Object)"Broken only mode enabled");
        } else {
            log.info((Object)"Broken only mode disabled");
        }
        for (TestListener i : this.testListeners) {
            i.setBrokenOnly(this.brokenOnlyMode);
        }
        return this.brokenOnlyMode;
    }

    @Override
    public boolean toggleTestOutput() {
        this.setDisplayTestOutput(!this.displayTestOutput);
        if (this.displayTestOutput) {
            log.info((Object)"Test output enabled");
        } else {
            log.info((Object)"Test output disabled");
        }
        for (TestListener i : this.testListeners) {
            i.setTestOutput(this.displayTestOutput);
        }
        return this.displayTestOutput;
    }

    @Override
    public boolean toggleInstrumentation() {
        boolean ibr = RuntimeUpdatesProcessor.INSTANCE.toggleInstrumentation();
        for (TestListener i : this.testListeners) {
            i.setInstrumentationBasedReload(ibr);
        }
        return ibr;
    }

    @Override
    public boolean toggleLiveReloadEnabled() {
        boolean lr = RuntimeUpdatesProcessor.INSTANCE.toggleLiveReloadEnabled();
        for (TestListener i : this.testListeners) {
            i.setLiveReloadEnabled(lr);
        }
        return lr;
    }

    @Override
    public void printFullResults() {
        if (this.currentState().getFailingClasses().isEmpty()) {
            log.info((Object)"All tests passed, no output to display");
        }
        for (TestClassResult i : this.currentState().getFailingClasses()) {
            for (TestResult failed : i.getFailing()) {
                log.error((Object)("Test " + failed.getDisplayName() + " failed " + failed.getTestExecutionResult().getStatus() + "\n"), (Throwable)failed.getTestExecutionResult().getThrowable().get());
            }
        }
    }

    @Override
    public boolean isBrokenOnlyMode() {
        return this.brokenOnlyMode;
    }

    @Override
    public boolean isDisplayTestOutput() {
        return this.displayTestOutput;
    }

    @Override
    public boolean isInstrumentationEnabled() {
        return RuntimeUpdatesProcessor.INSTANCE.instrumentationEnabled();
    }

    @Override
    public boolean isLiveReloadEnabled() {
        return RuntimeUpdatesProcessor.INSTANCE.isLiveReloadEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCompileFailed(Throwable e) {
        TestSupport testSupport = this;
        synchronized (testSupport) {
            this.compileProblem = e;
        }
        for (TestListener i : this.testListeners) {
            i.testCompileFailed(e.getMessage());
        }
    }

    public synchronized void testCompileSucceeded() {
        this.compileProblem = null;
        for (TestListener i : this.testListeners) {
            i.testCompileSucceeded();
        }
    }

    public void setConfig(TestConfig config) {
        this.config = config;
    }

    public TestConfig getConfig() {
        return this.config;
    }

    public static class RunStatus {
        final long lastRun;
        final long running;

        public RunStatus(long lastRun, long running) {
            this.lastRun = lastRun;
            this.running = running;
        }

        public long getLastRun() {
            return this.lastRun;
        }

        public long getRunning() {
            return this.running;
        }
    }
}

