/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.quarkus.deployment.AccessorFinder;
import io.quarkus.deployment.configuration.CompoundConfigType;
import io.quarkus.deployment.configuration.ObjectConfigType;
import io.quarkus.deployment.steps.ConfigurationSetup;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.runtime.configuration.ExpandingConfigSource;
import io.quarkus.runtime.configuration.NameIterator;
import io.smallrye.config.SmallRyeConfig;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.config.spi.Converter;
import org.wildfly.common.Assert;

public class OptionalObjectConfigType<T>
extends ObjectConfigType<T> {
    public OptionalObjectConfigType(String containingName, CompoundConfigType container, boolean consumeSegment, String defaultValue, Class<T> expectedType, String javadocKey, String configKey, Class<? extends Converter<T>> converterClass) {
        super(containingName, container, consumeSegment, defaultValue, expectedType, javadocKey, configKey, converterClass);
    }

    @Override
    public void acceptConfigurationValue(NameIterator name, ExpandingConfigSource.Cache cache, SmallRyeConfig config) {
        CompoundConfigType container = this.getContainer();
        if (this.isConsumeSegment()) {
            name.previous();
        }
        container.acceptConfigurationValueIntoLeaf(this, name, cache, config);
    }

    @Override
    public void generateAcceptConfigurationValue(BytecodeCreator body, ResultHandle name, ResultHandle cache, ResultHandle config) {
        CompoundConfigType container = this.getContainer();
        if (this.isConsumeSegment()) {
            body.invokeVirtualMethod(NI_PREV_METHOD, name, new ResultHandle[0]);
        }
        container.generateAcceptConfigurationValueIntoLeaf(body, this, name, cache, config);
    }

    @Override
    void getDefaultValueIntoEnclosingGroup(Object enclosing, ExpandingConfigSource.Cache cache, SmallRyeConfig config, Field field) {
        try {
            if (this.defaultValue.isEmpty()) {
                field.set(enclosing, Optional.empty());
            } else {
                String value = ExpandingConfigSource.expandValue((String)this.defaultValue, (ExpandingConfigSource.Cache)cache);
                field.set(enclosing, Optional.ofNullable(ConfigUtils.convert((SmallRyeConfig)config, (String)value, (Class)this.expectedType, (Class)this.converterClass)));
            }
        }
        catch (IllegalAccessException e) {
            throw OptionalObjectConfigType.toError(e);
        }
    }

    @Override
    void generateGetDefaultValueIntoEnclosingGroup(BytecodeCreator body, ResultHandle enclosing, MethodDescriptor setter, ResultHandle cache, ResultHandle config) {
        ResultHandle optValue = this.defaultValue.isEmpty() ? body.invokeStaticMethod(OPT_EMPTY_METHOD, new ResultHandle[0]) : body.invokeStaticMethod(OPT_OF_NULLABLE_METHOD, new ResultHandle[]{body.invokeStaticMethod(CU_CONVERT, new ResultHandle[]{config, body.load(this.defaultValue), body.loadClass(this.expectedType), this.loadConverterClass(body)})});
        body.invokeStaticMethod(setter, new ResultHandle[]{enclosing, optValue});
    }

    @Override
    public void acceptConfigurationValueIntoGroup(Object enclosing, Field field, NameIterator name, SmallRyeConfig config) {
        try {
            field.set(enclosing, ConfigUtils.getOptionalValue((SmallRyeConfig)config, (String)name.toString(), (Class)this.expectedType, (Class)this.converterClass));
        }
        catch (IllegalAccessException e) {
            throw OptionalObjectConfigType.toError(e);
        }
    }

    @Override
    public void generateAcceptConfigurationValueIntoGroup(BytecodeCreator body, ResultHandle enclosing, MethodDescriptor setter, ResultHandle name, ResultHandle config) {
        ResultHandle propertyName = body.invokeVirtualMethod(OBJ_TO_STRING_METHOD, name, new ResultHandle[0]);
        ResultHandle optionalValue = body.invokeStaticMethod(CU_GET_OPT_VALUE, new ResultHandle[]{config, propertyName, body.loadClass(this.expectedType), this.loadConverterClass(body)});
        body.invokeStaticMethod(setter, new ResultHandle[]{enclosing, optionalValue});
    }

    @Override
    void acceptConfigurationValueIntoMap(Map<String, Object> enclosing, NameIterator name, SmallRyeConfig config) {
        throw Assert.unsupported();
    }

    @Override
    void generateAcceptConfigurationValueIntoMap(BytecodeCreator body, ResultHandle enclosing, ResultHandle name, ResultHandle config) {
        throw Assert.unsupported();
    }

    @Override
    public ResultHandle writeInitialization(BytecodeCreator body, AccessorFinder accessorFinder, ResultHandle cache, ResultHandle config) {
        if (this.defaultValue.isEmpty()) {
            return body.invokeStaticMethod(OPT_EMPTY_METHOD, new ResultHandle[0]);
        }
        ResultHandle classResultHandle = body.loadClass(this.expectedType);
        ResultHandle cacheResultHandle = cache == null ? body.load(this.defaultValue) : body.invokeStaticMethod(ConfigurationSetup.ECS_EXPAND_VALUE, new ResultHandle[]{body.load(this.defaultValue), cache});
        ResultHandle resultHandle = body.invokeStaticMethod(CU_CONVERT, new ResultHandle[]{config, cacheResultHandle, classResultHandle, this.loadConverterClass(body)});
        return body.invokeStaticMethod(OPT_OF_NULLABLE_METHOD, new ResultHandle[]{resultHandle});
    }
}

