/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.util;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.zip.ZipError;

public class ZipUtils {
    private static final String JAR_URI_PREFIX = "jar:";
    private static final Map<String, String> CREATE_ENV = Collections.singletonMap("create", "true");

    public static void unzip(Path zipFile, Path targetDir) throws IOException {
        try {
            if (!Files.exists(targetDir, new LinkOption[0])) {
                Files.createDirectories(targetDir, new FileAttribute[0]);
            }
        }
        catch (FileAlreadyExistsException fae) {
            throw new IOException("Could not create directory '" + targetDir + "' as a file already exists with the same name");
        }
        try (FileSystem zipfs = ZipUtils.newFileSystem(zipFile);){
            for (Path zipRoot : zipfs.getRootDirectories()) {
                ZipUtils.copyFromZip(zipRoot, targetDir);
            }
        }
        catch (IOException | ZipError ioe) {
            throw new IOException("Could not unzip " + zipFile + " to target dir " + targetDir, ioe);
        }
    }

    public static URI toZipUri(Path zipFile) throws IOException {
        URI zipUri = zipFile.toUri();
        try {
            zipUri = new URI(JAR_URI_PREFIX + zipUri.getScheme(), zipUri.getPath(), null);
        }
        catch (URISyntaxException e) {
            throw new IOException("Failed to create a JAR URI for " + zipFile, e);
        }
        return zipUri;
    }

    public static void copyFromZip(final Path source, final Path target) throws IOException {
        Files.walkFileTree(source, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                block2: {
                    Path targetDir = target.resolve(source.relativize(dir).toString());
                    try {
                        Files.copy(dir, targetDir, new CopyOption[0]);
                    }
                    catch (FileAlreadyExistsException e) {
                        if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                        throw e;
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, target.resolve(source.relativize(file).toString()), StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void zip(Path src, Path zipFile) throws IOException {
        block26: {
            try (FileSystem zipfs = ZipUtils.newZip(zipFile);){
                if (Files.isDirectory(src, new LinkOption[0])) {
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(src);){
                        for (Path srcPath : stream) {
                            ZipUtils.copyToZip(src, srcPath, zipfs);
                        }
                        break block26;
                    }
                }
                Files.copy(src, zipfs.getPath(src.getFileName().toString(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    public static FileSystem newZip(Path zipFile) throws IOException {
        return ZipUtils.newFileSystem(ZipUtils.toZipUri(zipFile), Files.exists(zipFile, new LinkOption[0]) ? Collections.emptyMap() : CREATE_ENV);
    }

    private static void copyToZip(final Path srcRoot, Path srcPath, final FileSystem zipfs) throws IOException {
        Files.walkFileTree(srcPath, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                block2: {
                    Path targetDir = zipfs.getPath(srcRoot.relativize(dir).toString(), new String[0]);
                    try {
                        Files.copy(dir, targetDir, new CopyOption[0]);
                    }
                    catch (FileAlreadyExistsException e) {
                        if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                        throw e;
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, zipfs.getPath(srcRoot.relativize(file).toString(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        try {
            return FileSystems.newFileSystem(uri, env);
        }
        catch (IOException | ZipError ioe) {
            throw new IOException("Failed to create a new filesystem for " + uri, ioe);
        }
    }

    public static FileSystem newFileSystem(Path path) throws IOException {
        try {
            return FileSystems.newFileSystem(path, (ClassLoader)null);
        }
        catch (IOException | ZipError ioe) {
            throw new IOException("Failed to create a new filesystem for " + path, ioe);
        }
    }
}

