/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.semconv.network.internal;

import io.opentelemetry.instrumentation.api.semconv.network.ClientAttributesGetter;
import io.opentelemetry.instrumentation.api.semconv.network.internal.AddressAndPortExtractor;

public final class ClientAddressAndPortExtractor<REQUEST>
implements AddressAndPortExtractor<REQUEST> {
    private final ClientAttributesGetter<REQUEST> getter;
    private final AddressAndPortExtractor<REQUEST> fallbackAddressAndPortExtractor;

    public ClientAddressAndPortExtractor(ClientAttributesGetter<REQUEST> getter, AddressAndPortExtractor<REQUEST> fallbackAddressAndPortExtractor) {
        this.getter = getter;
        this.fallbackAddressAndPortExtractor = fallbackAddressAndPortExtractor;
    }

    @Override
    public void extract(AddressAndPortExtractor.AddressPortSink sink, REQUEST request) {
        String address = this.getter.getClientAddress(request);
        Integer port = this.getter.getClientPort(request);
        if (address == null && port == null) {
            this.fallbackAddressAndPortExtractor.extract(sink, request);
        } else {
            sink.setAddress(address);
            sink.setPort(port);
        }
    }
}

