/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.jsonrpc.handler;

import io.moderne.jsonrpc.JsonRpcError;
import io.moderne.jsonrpc.JsonRpcMessage;
import io.moderne.jsonrpc.formatter.JsonMessageFormatter;
import io.moderne.jsonrpc.formatter.MessageFormatter;
import io.moderne.jsonrpc.handler.MessageHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public class HeaderDelimitedMessageHandler
implements MessageHandler {
    private static final Pattern CONTENT_LENGTH = Pattern.compile("Content-Length: (\\d+)");
    private final MessageFormatter formatter;
    private final InputStream inputStream;
    private final OutputStream outputStream;

    public HeaderDelimitedMessageHandler(InputStream inputStream, OutputStream outputStream) {
        this.formatter = new JsonMessageFormatter();
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    @Override
    public JsonRpcMessage receive() {
        try {
            int bytesRead;
            String contentLength = this.readLineFromInputStream();
            Matcher contentLengthMatcher = CONTENT_LENGTH.matcher(contentLength);
            if (!contentLengthMatcher.matches()) {
                return JsonRpcError.invalidRequest(null, "Expected Content-Length header but received '" + contentLength + "'");
            }
            String contentType = this.readLineFromInputStream();
            if (!contentType.isEmpty()) {
                if (!contentType.startsWith("Content-Type")) {
                    return JsonRpcError.invalidRequest(null, "Expected Content-Type header but received '" + contentType + "'");
                }
                if (!this.readLineFromInputStream().isEmpty()) {
                    return JsonRpcError.invalidRequest(null, "Expected empty line after headers");
                }
            }
            byte[] content = new byte[Integer.parseInt(contentLengthMatcher.group(1))];
            for (int totalRead = 0; totalRead < content.length; totalRead += bytesRead) {
                bytesRead = this.inputStream.read(content, totalRead, content.length - totalRead);
                if (bytesRead != -1) continue;
                return JsonRpcError.invalidRequest(null, "Content length mismatch. Expected " + content.length + " but received " + totalRead);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(content);
            return this.formatter.deserialize(bis);
        }
        catch (IOException e) {
            return JsonRpcError.invalidRequest(null, e.getMessage());
        }
    }

    private String readLineFromInputStream() throws IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        while ((c = this.inputStream.read()) != -1 && c != 10) {
            if (c == 13) continue;
            sb.append((char)c);
        }
        return sb.toString();
    }

    @Override
    public void send(JsonRpcMessage msg) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.formatter.serialize(msg, bos);
            byte[] content = bos.toByteArray();
            this.outputStream.write(("Content-Length: " + content.length + "\r\n").getBytes());
            if (this.formatter.getEncoding() != StandardCharsets.UTF_8) {
                this.outputStream.write(("Content-Type: application/vscode-jsonrpc;charset=" + this.formatter.getEncoding().name() + "\r\n").getBytes());
            }
            this.outputStream.write(13);
            this.outputStream.write(10);
            this.outputStream.write(content);
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Generated
    public HeaderDelimitedMessageHandler(MessageFormatter formatter, InputStream inputStream, OutputStream outputStream) {
        this.formatter = formatter;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }
}

