/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.web.servlet;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerMapping;

@NonNullApi
public final class WebMvcTags {
    private static final Tag URI_NOT_FOUND = Tag.of((String)"uri", (String)"NOT_FOUND");
    private static final Tag URI_REDIRECTION = Tag.of((String)"uri", (String)"REDIRECTION");
    private static final Tag URI_UNKNOWN = Tag.of((String)"uri", (String)"UNKNOWN");
    private static final Tag EXCEPTION_NONE = Tag.of((String)"exception", (String)"None");
    private static final Tag STATUS_UNKNOWN = Tag.of((String)"status", (String)"UNKNOWN");
    private static final Tag METHOD_UNKNOWN = Tag.of((String)"method", (String)"UNKNOWN");

    private WebMvcTags() {
    }

    public static Tag method(@Nullable HttpServletRequest request) {
        return request == null ? METHOD_UNKNOWN : Tag.of((String)"method", (String)request.getMethod());
    }

    public static Tag status(@Nullable HttpServletResponse response) {
        return response == null ? STATUS_UNKNOWN : Tag.of((String)"status", (String)Integer.toString(response.getStatus()));
    }

    public static Tag uri(@Nullable HttpServletRequest request, @Nullable HttpServletResponse response) {
        if (request != null) {
            String pathInfo;
            String pattern = WebMvcTags.getMatchingPattern(request);
            if (pattern != null) {
                return Tag.of((String)"uri", (String)pattern);
            }
            if (response != null) {
                HttpStatus status = WebMvcTags.extractStatus(response);
                if (status != null && status.is3xxRedirection()) {
                    return URI_REDIRECTION;
                }
                if (status != null && status.equals((Object)HttpStatus.NOT_FOUND)) {
                    return URI_NOT_FOUND;
                }
            }
            return Tag.of((String)"uri", (String)((pathInfo = WebMvcTags.getPathInfo(request)).isEmpty() ? "root" : pathInfo));
        }
        return URI_UNKNOWN;
    }

    @Nullable
    private static HttpStatus extractStatus(HttpServletResponse response) {
        try {
            return HttpStatus.valueOf((int)response.getStatus());
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    @Nullable
    private static String getMatchingPattern(HttpServletRequest request) {
        return (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
    }

    private static String getPathInfo(HttpServletRequest request) {
        String uri = StringUtils.hasText((String)request.getPathInfo()) ? request.getPathInfo() : "/";
        return uri.replaceAll("//+", "/").replaceAll("/$", "");
    }

    public static Tag exception(@Nullable Throwable exception) {
        return exception == null ? EXCEPTION_NONE : Tag.of((String)"exception", (String)exception.getClass().getSimpleName());
    }
}

