/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.KeyValue;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.CommandOutput;
import java.nio.ByteBuffer;

public class KeyValueOutput<K, V>
extends CommandOutput<K, V, KeyValue<K, V>> {
    private K key;

    public KeyValueOutput(RedisCodec<K, V> codec) {
        super(codec, null);
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (bytes != null) {
            if (this.key == null) {
                this.key = this.codec.decodeKey(bytes);
            } else {
                Object value = this.codec.decodeValue(bytes);
                this.output = KeyValue.fromNullable(this.key, value);
            }
        }
    }
}

