/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.masterslave;

import io.lettuce.core.RedisURI;
import io.lettuce.core.models.role.RedisNodeDescription;
import java.util.Comparator;
import java.util.Map;

class TopologyComparators {
    TopologyComparators() {
    }

    static enum RedisURIComparator implements Comparator<RedisURI>
    {
        INSTANCE;


        @Override
        public int compare(RedisURI o1, RedisURI o2) {
            String h1 = "";
            String h2 = "";
            if (o1 != null) {
                h1 = o1.getHost() + ":" + o1.getPort();
            }
            if (o2 != null) {
                h2 = o2.getHost() + ":" + o2.getPort();
            }
            return h1.compareToIgnoreCase(h2);
        }
    }

    static class LatencyComparator
    implements Comparator<RedisNodeDescription> {
        private final Map<RedisNodeDescription, Long> latencies;

        public LatencyComparator(Map<RedisNodeDescription, Long> latencies) {
            this.latencies = latencies;
        }

        @Override
        public int compare(RedisNodeDescription o1, RedisNodeDescription o2) {
            Long latency1 = this.latencies.get(o1);
            Long latency2 = this.latencies.get(o2);
            if (latency1 != null && latency2 != null) {
                return latency1.compareTo(latency2);
            }
            if (latency1 != null) {
                return -1;
            }
            if (latency2 != null) {
                return 1;
            }
            return 0;
        }
    }
}

