/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.ConnectionBuilder;
import io.lettuce.core.ConnectionFuture;
import io.lettuce.core.LettuceStrings;
import io.lettuce.core.RedisChannelWriter;
import io.lettuce.core.RedisCommandInterruptedException;
import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.RedisException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.SslConnectionBuilder;
import io.lettuce.core.StatefulRedisConnectionImpl;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandHandler;
import io.lettuce.core.protocol.DefaultEndpoint;
import io.lettuce.core.pubsub.PubSubCommandHandler;
import io.lettuce.core.pubsub.PubSubEndpoint;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnectionImpl;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.SocketAddressResolver;
import io.lettuce.core.sentinel.StatefulRedisSentinelConnectionImpl;
import io.lettuce.core.sentinel.api.StatefulRedisSentinelConnection;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public class RedisClient
extends AbstractRedisClient {
    private static final RedisURI EMPTY_URI = new RedisURI();
    private final RedisURI redisURI;

    protected RedisClient(ClientResources clientResources, RedisURI redisURI) {
        super(clientResources);
        RedisClient.assertNotNull(redisURI);
        this.redisURI = redisURI;
        this.setDefaultTimeout(redisURI.getTimeout());
    }

    protected RedisClient() {
        this(null, EMPTY_URI);
    }

    public static RedisClient create() {
        return new RedisClient(null, EMPTY_URI);
    }

    public static RedisClient create(RedisURI redisURI) {
        RedisClient.assertNotNull(redisURI);
        return new RedisClient(null, redisURI);
    }

    public static RedisClient create(String uri) {
        LettuceAssert.notEmpty(uri, "URI must not be empty");
        return new RedisClient(null, RedisURI.create(uri));
    }

    public static RedisClient create(ClientResources clientResources) {
        RedisClient.assertNotNull(clientResources);
        return new RedisClient(clientResources, EMPTY_URI);
    }

    public static RedisClient create(ClientResources clientResources, String uri) {
        RedisClient.assertNotNull(clientResources);
        LettuceAssert.notEmpty(uri, "URI must not be empty");
        return RedisClient.create(clientResources, RedisURI.create(uri));
    }

    public static RedisClient create(ClientResources clientResources, RedisURI redisURI) {
        RedisClient.assertNotNull(clientResources);
        RedisClient.assertNotNull(redisURI);
        return new RedisClient(clientResources, redisURI);
    }

    public StatefulRedisConnection<String, String> connect() {
        return this.connect(this.newStringStringCodec());
    }

    public <K, V> StatefulRedisConnection<K, V> connect(RedisCodec<K, V> codec) {
        this.checkForRedisURI();
        return this.connectStandalone(codec, this.redisURI, this.timeout);
    }

    public StatefulRedisConnection<String, String> connect(RedisURI redisURI) {
        RedisClient.assertNotNull(redisURI);
        return this.connectStandalone(this.newStringStringCodec(), redisURI, redisURI.getTimeout());
    }

    public <K, V> StatefulRedisConnection<K, V> connect(RedisCodec<K, V> codec, RedisURI redisURI) {
        RedisClient.assertNotNull(redisURI);
        return this.connectStandalone(codec, redisURI, redisURI.getTimeout());
    }

    public <K, V> ConnectionFuture<StatefulRedisConnection<K, V>> connectAsync(RedisCodec<K, V> codec, RedisURI redisURI) {
        RedisClient.assertNotNull(redisURI);
        return this.connectStandaloneAsync(codec, redisURI, redisURI.getTimeout());
    }

    private <K, V> StatefulRedisConnection<K, V> connectStandalone(RedisCodec<K, V> codec, RedisURI redisURI, Duration timeout) {
        ConnectionFuture<StatefulRedisConnection<K, V>> future = this.connectStandaloneAsync(codec, redisURI, timeout);
        return this.getConnection(future);
    }

    private <K, V> ConnectionFuture<StatefulRedisConnection<K, V>> connectStandaloneAsync(RedisCodec<K, V> codec, RedisURI redisURI) {
        RedisClient.assertNotNull(redisURI);
        return this.connectStandaloneAsync(codec, redisURI, redisURI.getTimeout());
    }

    private <K, V> ConnectionFuture<StatefulRedisConnection<K, V>> connectStandaloneAsync(RedisCodec<K, V> codec, RedisURI redisURI, Duration timeout) {
        RedisClient.assertNotNull(codec);
        this.checkValidRedisURI(redisURI);
        logger.debug("Trying to get a Redis connection for: " + redisURI);
        DefaultEndpoint endpoint = new DefaultEndpoint(this.clientOptions);
        StatefulRedisConnectionImpl connection = this.newStatefulRedisConnection(endpoint, codec, timeout);
        ConnectionFuture<StatefulRedisConnection<K, V>> future = this.connectStatefulAsync(connection, endpoint, redisURI, () -> new CommandHandler(this.clientOptions, this.clientResources, endpoint));
        future.whenComplete((channelHandler, throwable) -> {
            if (throwable != null) {
                connection.close();
            }
        });
        return future;
    }

    private <K, V, S> ConnectionFuture<S> connectStatefulAsync(StatefulRedisConnectionImpl<K, V> connection, DefaultEndpoint endpoint, RedisURI redisURI, Supplier<CommandHandler> commandHandlerSupplier) {
        ConnectionBuilder connectionBuilder;
        if (redisURI.isSsl()) {
            SslConnectionBuilder sslConnectionBuilder = SslConnectionBuilder.sslConnectionBuilder();
            sslConnectionBuilder.ssl(redisURI);
            connectionBuilder = sslConnectionBuilder;
        } else {
            connectionBuilder = ConnectionBuilder.connectionBuilder();
        }
        connectionBuilder.connection(connection);
        connectionBuilder.clientOptions(this.clientOptions);
        connectionBuilder.clientResources(this.clientResources);
        connectionBuilder.commandHandler(commandHandlerSupplier).endpoint(endpoint);
        this.connectionBuilder(this.getSocketAddressSupplier(redisURI), connectionBuilder, redisURI);
        this.channelType(connectionBuilder, redisURI);
        if (this.clientOptions.isPingBeforeActivateConnection()) {
            if (this.hasPassword(redisURI)) {
                connectionBuilder.enableAuthPingBeforeConnect();
            } else {
                connectionBuilder.enablePingBeforeConnect();
            }
        }
        CompletionStage future = this.initializeChannelAsync(connectionBuilder);
        if (!this.clientOptions.isPingBeforeActivateConnection() && this.hasPassword(redisURI)) {
            future = future.thenApplyAsync(channelHandler -> {
                connection.async().auth(new String(redisURI.getPassword()));
                return channelHandler;
            }, (Executor)this.clientResources.eventExecutorGroup());
        }
        if (LettuceStrings.isNotEmpty(redisURI.getClientName())) {
            future.thenApply(channelHandler -> {
                connection.setClientName(redisURI.getClientName());
                return channelHandler;
            });
        }
        if (redisURI.getDatabase() != 0) {
            future = future.thenApplyAsync(channelHandler -> {
                connection.async().select(redisURI.getDatabase());
                return channelHandler;
            }, (Executor)this.clientResources.eventExecutorGroup());
        }
        return future.thenApply(channelHandler -> connection);
    }

    private boolean hasPassword(RedisURI redisURI) {
        return redisURI.getPassword() != null && redisURI.getPassword().length != 0;
    }

    public StatefulRedisPubSubConnection<String, String> connectPubSub() {
        return this.getConnection(this.connectPubSubAsync(this.newStringStringCodec(), this.redisURI, this.timeout));
    }

    public StatefulRedisPubSubConnection<String, String> connectPubSub(RedisURI redisURI) {
        RedisClient.assertNotNull(redisURI);
        return this.getConnection(this.connectPubSubAsync(this.newStringStringCodec(), redisURI, redisURI.getTimeout()));
    }

    public <K, V> StatefulRedisPubSubConnection<K, V> connectPubSub(RedisCodec<K, V> codec) {
        this.checkForRedisURI();
        return this.getConnection(this.connectPubSubAsync(codec, this.redisURI, this.timeout));
    }

    public <K, V> StatefulRedisPubSubConnection<K, V> connectPubSub(RedisCodec<K, V> codec, RedisURI redisURI) {
        RedisClient.assertNotNull(redisURI);
        return this.getConnection(this.connectPubSubAsync(codec, redisURI, redisURI.getTimeout()));
    }

    public <K, V> ConnectionFuture<StatefulRedisPubSubConnection<K, V>> connectPubSubAsync(RedisCodec<K, V> codec, RedisURI redisURI) {
        RedisClient.assertNotNull(redisURI);
        return this.connectPubSubAsync(codec, redisURI, redisURI.getTimeout());
    }

    private <K, V> ConnectionFuture<StatefulRedisPubSubConnection<K, V>> connectPubSubAsync(RedisCodec<K, V> codec, RedisURI redisURI, Duration timeout) {
        RedisClient.assertNotNull(codec);
        this.checkValidRedisURI(redisURI);
        PubSubEndpoint endpoint = new PubSubEndpoint(this.clientOptions);
        StatefulRedisPubSubConnectionImpl connection = this.newStatefulRedisPubSubConnection(endpoint, endpoint, codec, timeout);
        ConnectionFuture future = this.connectStatefulAsync(connection, endpoint, redisURI, () -> new PubSubCommandHandler(this.clientOptions, this.clientResources, codec, endpoint));
        return future.whenComplete((conn, throwable) -> {
            if (throwable != null) {
                conn.close();
            }
        });
    }

    public StatefulRedisSentinelConnection<String, String> connectSentinel() {
        return this.connectSentinel(this.newStringStringCodec());
    }

    public <K, V> StatefulRedisSentinelConnection<K, V> connectSentinel(RedisCodec<K, V> codec) {
        this.checkForRedisURI();
        return this.connectSentinel(codec, this.redisURI, this.timeout);
    }

    public StatefulRedisSentinelConnection<String, String> connectSentinel(RedisURI redisURI) {
        RedisClient.assertNotNull(redisURI);
        return this.connectSentinel(this.newStringStringCodec(), redisURI, redisURI.getTimeout());
    }

    public <K, V> StatefulRedisSentinelConnection<K, V> connectSentinel(RedisCodec<K, V> codec, RedisURI redisURI) {
        RedisClient.assertNotNull(redisURI);
        return this.connectSentinel(codec, redisURI, redisURI.getTimeout());
    }

    private <K, V> StatefulRedisSentinelConnection<K, V> connectSentinel(RedisCodec<K, V> codec, RedisURI redisURI, Duration timeout) {
        RedisClient.assertNotNull(codec);
        this.checkValidRedisURI(redisURI);
        ConnectionBuilder connectionBuilder = ConnectionBuilder.connectionBuilder();
        connectionBuilder.clientOptions(ClientOptions.copyOf(this.getOptions()));
        connectionBuilder.clientResources(this.clientResources);
        DefaultEndpoint endpoint = new DefaultEndpoint(this.clientOptions);
        StatefulRedisSentinelConnectionImpl<K, V> connection = this.newStatefulRedisSentinelConnection(endpoint, codec, timeout);
        logger.debug("Trying to get a Redis Sentinel connection for one of: " + redisURI.getSentinels());
        connectionBuilder.endpoint(endpoint).commandHandler(() -> new CommandHandler(this.clientOptions, this.clientResources, endpoint)).connection(connection);
        this.connectionBuilder(this.getSocketAddressSupplier(redisURI), connectionBuilder, redisURI);
        if (this.clientOptions.isPingBeforeActivateConnection()) {
            connectionBuilder.enablePingBeforeConnect();
        }
        if (redisURI.getSentinels().isEmpty() && (LettuceStrings.isNotEmpty(redisURI.getHost()) || !LettuceStrings.isEmpty(redisURI.getSocket()))) {
            this.channelType(connectionBuilder, redisURI);
            try {
                this.getConnection(this.initializeChannelAsync(connectionBuilder));
            }
            catch (RuntimeException e) {
                connection.close();
                throw e;
            }
        } else {
            boolean connected = false;
            boolean first = true;
            Exception causingException = null;
            this.validateUrisAreOfSameConnectionType(redisURI.getSentinels());
            for (RedisURI uri : redisURI.getSentinels()) {
                if (first) {
                    this.channelType(connectionBuilder, uri);
                    first = false;
                }
                connectionBuilder.socketAddressSupplier(this.getSocketAddressSupplier(uri));
                if (logger.isDebugEnabled()) {
                    SocketAddress socketAddress = SocketAddressResolver.resolve(uri, this.clientResources.dnsResolver());
                    logger.debug("Connecting to Redis Sentinel, address: " + socketAddress);
                }
                try {
                    this.getConnection(this.initializeChannelAsync(connectionBuilder));
                    connected = true;
                    break;
                }
                catch (Exception e) {
                    logger.warn("Cannot connect Redis Sentinel at " + uri + ": " + e.toString());
                    causingException = e;
                }
            }
            if (!connected) {
                connection.close();
                throw new RedisConnectionException("Cannot connect to a Redis Sentinel: " + redisURI.getSentinels(), causingException);
            }
        }
        if (LettuceStrings.isNotEmpty(redisURI.getClientName())) {
            connection.setClientName(redisURI.getClientName());
        }
        return connection;
    }

    @Override
    public void setOptions(ClientOptions clientOptions) {
        super.setOptions(clientOptions);
    }

    public ClientResources getResources() {
        return this.clientResources;
    }

    protected <K, V> StatefulRedisPubSubConnectionImpl<K, V> newStatefulRedisPubSubConnection(PubSubEndpoint<K, V> endpoint, RedisChannelWriter channelWriter, RedisCodec<K, V> codec, Duration timeout) {
        return new StatefulRedisPubSubConnectionImpl<K, V>(endpoint, channelWriter, codec, timeout);
    }

    protected <K, V> StatefulRedisSentinelConnectionImpl<K, V> newStatefulRedisSentinelConnection(RedisChannelWriter channelWriter, RedisCodec<K, V> codec, Duration timeout) {
        return new StatefulRedisSentinelConnectionImpl<K, V>(channelWriter, codec, timeout);
    }

    protected <K, V> StatefulRedisConnectionImpl<K, V> newStatefulRedisConnection(RedisChannelWriter channelWriter, RedisCodec<K, V> codec, Duration timeout) {
        return new StatefulRedisConnectionImpl<K, V>(channelWriter, codec, timeout);
    }

    protected SocketAddress getSocketAddress(RedisURI redisURI) throws InterruptedException, TimeoutException, ExecutionException {
        SocketAddress redisAddress;
        if (redisURI.getSentinelMasterId() != null && !redisURI.getSentinels().isEmpty()) {
            logger.debug("Connecting to Redis using Sentinels {}, MasterId {}", redisURI.getSentinels(), (Object)redisURI.getSentinelMasterId());
            redisAddress = this.lookupRedis(redisURI);
            if (redisAddress == null) {
                throw new RedisConnectionException("Cannot provide redisAddress using sentinel for masterId " + redisURI.getSentinelMasterId());
            }
        } else {
            redisAddress = SocketAddressResolver.resolve(redisURI, this.clientResources.dnsResolver());
        }
        return redisAddress;
    }

    protected RedisCodec<String, String> newStringStringCodec() {
        return StringCodec.UTF8;
    }

    private void validateUrisAreOfSameConnectionType(List<RedisURI> redisUris) {
        boolean unixDomainSocket = false;
        boolean inetSocket = false;
        for (RedisURI sentinel : redisUris) {
            if (sentinel.getSocket() != null) {
                unixDomainSocket = true;
            }
            if (sentinel.getHost() == null) continue;
            inetSocket = true;
        }
        if (unixDomainSocket && inetSocket) {
            throw new RedisConnectionException("You cannot mix unix domain socket and IP socket URI's");
        }
    }

    private Supplier<SocketAddress> getSocketAddressSupplier(RedisURI redisURI) {
        return () -> {
            try {
                SocketAddress socketAddress = this.getSocketAddress(redisURI);
                logger.debug("Resolved SocketAddress {} using {}", (Object)socketAddress, (Object)redisURI);
                return socketAddress;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RedisCommandInterruptedException(e);
            }
            catch (ExecutionException | TimeoutException e) {
                throw new RedisException(e);
            }
        };
    }

    private SocketAddress lookupRedis(RedisURI sentinelUri) throws InterruptedException, TimeoutException, ExecutionException {
        try (StatefulRedisSentinelConnection<String, String> connection = this.connectSentinel(sentinelUri);){
            SocketAddress socketAddress = (SocketAddress)connection.async().getMasterAddrByName(sentinelUri.getSentinelMasterId()).get(this.timeout.toNanos(), TimeUnit.NANOSECONDS);
            return socketAddress;
        }
    }

    private void checkValidRedisURI(RedisURI redisURI) {
        LettuceAssert.notNull(redisURI, "A valid RedisURI is required");
        if (redisURI.getSentinels().isEmpty()) {
            if (LettuceStrings.isEmpty(redisURI.getHost()) && LettuceStrings.isEmpty(redisURI.getSocket())) {
                throw new IllegalArgumentException("RedisURI for Redis Standalone does not contain a host or a socket");
            }
        } else {
            if (LettuceStrings.isEmpty(redisURI.getSentinelMasterId())) {
                throw new IllegalArgumentException("TRedisURI for Redis Sentinel requires a masterId");
            }
            for (RedisURI sentinel : redisURI.getSentinels()) {
                if (!LettuceStrings.isEmpty(sentinel.getHost()) || !LettuceStrings.isEmpty(sentinel.getSocket())) continue;
                throw new IllegalArgumentException("RedisURI for Redis Sentinel does not contain a host or a socket");
            }
        }
    }

    private static <K, V> void assertNotNull(RedisCodec<K, V> codec) {
        LettuceAssert.notNull(codec, "RedisCodec must not be null");
    }

    private static void assertNotNull(RedisURI redisURI) {
        LettuceAssert.notNull(redisURI, "RedisURI must not be null");
    }

    private static void assertNotNull(ClientResources clientResources) {
        LettuceAssert.notNull(clientResources, "ClientResources must not be null");
    }

    private void checkForRedisURI() {
        LettuceAssert.assertState(this.redisURI != EMPTY_URI, "RedisURI is not available. Use RedisClient(Host), RedisClient(Host, Port) or RedisClient(RedisURI) to construct your client.");
        this.checkValidRedisURI(this.redisURI);
    }
}

