/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.util.classpath;

import io.leangen.graphql.util.classpath.ClassFilter;
import io.leangen.graphql.util.classpath.ClassInfo;
import io.leangen.graphql.util.classpath.ClassInfoClassVisitor;
import io.leangen.graphql.util.classpath.ClassReadingException;
import io.leangen.graphql.util.classpath.PathFilter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassFinder {
    private LinkedHashMap<String, File> placesToSearch = new LinkedHashMap();
    private Map<String, ClassInfo> foundClasses = new LinkedHashMap<String, ClassInfo>();
    private static final Logger log = LoggerFactory.getLogger(ClassFinder.class);

    public ClassFinder addExplicitClassPath() {
        String path = System.getProperty("java.class.path");
        String[] libPaths = System.getProperty("java.library.path").split(File.pathSeparator);
        String javaHome = System.getProperty("java.home");
        return this.add(Arrays.stream(path.split(File.pathSeparator)).filter(part -> Arrays.stream(libPaths).noneMatch(part::startsWith) && !part.startsWith(javaHome)));
    }

    public ClassFinder addClassPath() {
        return this.add(Arrays.stream(System.getProperty("java.class.path").split(File.pathSeparator)));
    }

    public ClassFinder add(File ... files) {
        for (File file : files) {
            if (!this.isPossibleRoot(file) || this.placesToSearch.containsKey(file.getAbsolutePath())) continue;
            String absPath = file.getAbsolutePath();
            this.placesToSearch.put(absPath, file);
            if (!this.isJar(absPath)) continue;
            try {
                this.loadJarClassPathEntries(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public ClassFinder add(Collection<File> files) {
        File[] array = new File[files.size()];
        return this.add(files.toArray(array));
    }

    public ClassFinder add(ClassLoader classLoader, String ... packages) {
        ClassLoader[] classLoaders = (ClassLoader[])Stream.of(Thread.currentThread().getContextClassLoader(), classLoader, this.getClass().getClassLoader(), ClassLoader.getSystemClassLoader()).distinct().filter(Objects::nonNull).toArray(ClassLoader[]::new);
        if (classLoaders.length == 0) {
            throw new IllegalStateException("No class loaders available");
        }
        Set files = Arrays.stream(packages).map(pckg -> pckg.replace(".", "/").replace("\\", "/")).map(path -> path.startsWith("/") ? path.substring(1) : path).flatMap(path -> Arrays.stream(classLoaders).flatMap(loader -> this.getDirectories((ClassLoader)loader, (String)path).stream())).collect(Collectors.toCollection(LinkedHashSet::new));
        return this.add(files);
    }

    private List<File> getDirectories(ClassLoader classLoader, String path) {
        try {
            Enumeration<URL> urls = classLoader.getResources(path);
            ArrayList<File> files = new ArrayList<File>();
            while (urls.hasMoreElements()) {
                String filePath = urls.nextElement().getFile();
                Pattern jarFilePattern = Pattern.compile("file:((.*?)\\.jar)!/.*");
                Matcher m = jarFilePattern.matcher(filePath);
                if (m.matches()) {
                    filePath = m.group(1);
                }
                files.add(new File(filePath));
            }
            return files;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can not read path " + path, e);
        }
    }

    private ClassFinder add(Stream<String> paths) {
        return this.add(paths.map(File::new).collect(Collectors.toList()));
    }

    public Collection<ClassInfo> findClasses(ClassFilter filter) throws ClassReadingException {
        this.foundClasses.clear();
        for (File file : this.placesToSearch.values()) {
            String name = file.getPath();
            log.debug("Finding classes in {}", (Object)name);
            if (this.isJar(name)) {
                this.processJar(name, this.foundClasses);
                continue;
            }
            if (this.isZip(name)) {
                this.processZip(name, this.foundClasses);
                continue;
            }
            this.processDirectory(file, this.foundClasses);
        }
        log.debug("Read {} classes.", (Object)this.foundClasses.size());
        HashSet<ClassInfo> result = new HashSet<ClassInfo>();
        for (ClassInfo classInfo : this.foundClasses.values()) {
            String className = classInfo.getClassName();
            String locationName = classInfo.getClassLocation().getPath();
            log.trace("Looking at {} ({})", (Object)locationName, (Object)className);
            if (filter != null && !filter.accept(classInfo, this)) continue;
            log.debug("Filter accepted {}", (Object)className);
            result.add(classInfo);
        }
        this.foundClasses.clear();
        return result;
    }

    public int findAllSuperClasses(ClassInfo classInfo, Map<String, ClassInfo> superClasses) {
        ClassInfo superClassInfo;
        int total = 0;
        String superClassName = classInfo.getSuperClassName();
        if (superClassName != null && (superClassInfo = this.foundClasses.get(superClassName)) != null) {
            superClasses.put(superClassName, superClassInfo);
            ++total;
            total += this.findAllSuperClasses(superClassInfo, superClasses);
        }
        return total;
    }

    public int findAllInterfaces(ClassInfo classInfo, Map<String, ClassInfo> interfaces) {
        ClassInfo superClassInfo;
        int total = 0;
        String superClassName = classInfo.getSuperClassName();
        if (superClassName != null && (superClassInfo = this.foundClasses.get(superClassName)) != null) {
            total += this.findAllInterfaces(superClassInfo, interfaces);
        }
        String[] interfaceNames = classInfo.getInterfaces();
        if (interfaces != null) {
            for (String interfaceName : interfaceNames) {
                ClassInfo intfClassInfo = this.foundClasses.get(interfaceName);
                if (intfClassInfo == null) continue;
                interfaces.put(interfaceName, intfClassInfo);
                ++total;
                total += this.findAllInterfaces(intfClassInfo, interfaces);
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJar(String jarName, Map<String, ClassInfo> foundClasses) {
        JarFile jar = null;
        try {
            jar = new JarFile(jarName);
            File jarFile = new File(jarName);
            this.processOpenZip(jar, jarFile, new ClassInfoClassVisitor(foundClasses, jarFile));
        }
        catch (IOException ex) {
            log.warn("Can't open jar file '{}' : {}", (Object)jarName, (Object)ex.getMessage());
        }
        finally {
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (IOException ex) {
                log.warn("Can't close '{}' : {}", (Object)jarName, (Object)ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processZip(String zipName, Map<String, ClassInfo> foundClasses) {
        ZipFile zip = null;
        try {
            zip = new ZipFile(zipName);
            File zipFile = new File(zipName);
            this.processOpenZip(zip, zipFile, new ClassInfoClassVisitor(foundClasses, zipFile));
        }
        catch (IOException ex) {
            log.warn("Can't open jar file '{}' : {}", (Object)zipName, (Object)ex.getMessage());
        }
        finally {
            try {
                if (zip != null) {
                    zip.close();
                }
            }
            catch (IOException ex) {
                log.warn("Can't close '{}' : {}", (Object)zipName, (Object)ex.getMessage());
            }
        }
    }

    private void processOpenZip(ZipFile zip, File zipFile, ClassVisitor classVisitor) {
        String zipName = zipFile.getPath();
        Enumeration<? extends ZipEntry> e = zip.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (entry.isDirectory() || !entry.getName().toLowerCase().endsWith(".class")) continue;
            try {
                log.debug("Reading {} ({})", (Object)zipName, (Object)entry.getName());
                this.readClass(zip.getInputStream(entry), classVisitor);
            }
            catch (IOException ex) {
                log.warn("Can't open '{}' in zip file '{}' : {}", new Object[]{entry.getName(), zipName, ex.getMessage()});
            }
        }
    }

    private void processDirectory(File dir, Map<String, ClassInfo> foundClasses) throws ClassReadingException {
        Collection<Path> files = this.findFiles(dir, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]), path -> path.toString().endsWith(".class"));
        ClassInfoClassVisitor classVisitor = new ClassInfoClassVisitor(foundClasses, dir);
        for (Path path2 : files) {
            InputStream classInput = null;
            try {
                classInput = Files.newInputStream(path2, new OpenOption[0]);
                this.readClass(classInput, classVisitor);
            }
            catch (IOException e) {
                throw new ClassReadingException("File " + path2.toString() + " does not exist", e);
            }
            finally {
                if (classInput == null) continue;
                try {
                    classInput.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void loadJarClassPathEntries(File jarFile) throws IOException {
        JarFile jar = new JarFile(jarFile);
        Manifest manifest = jar.getManifest();
        if (manifest == null) {
            return;
        }
        Attributes attrs = manifest.getMainAttributes();
        Set<Object> keys = attrs.keySet();
        for (Object key : keys) {
            String element;
            String value = (String)attrs.get(key);
            if (!key.toString().equals("Class-Path")) continue;
            String jarName = jar.getName();
            log.debug("Adding Class-Path from jar {}", (Object)jarName);
            StringBuilder buf = new StringBuilder();
            StringTokenizer tok = new StringTokenizer(value);
            while (tok.hasMoreTokens()) {
                buf.setLength(0);
                element = tok.nextToken();
                String parent = jarFile.getParent();
                if (parent != null) {
                    buf.append(parent);
                    buf.append(File.separator);
                }
                buf.append(element);
            }
            element = buf.toString();
            log.debug("From {} : {}", (Object)jarName, (Object)element);
            this.add(new File(element));
        }
    }

    private void readClass(InputStream classStream, ClassVisitor classVisitor) throws ClassReadingException {
        try {
            ClassReader cr = new ClassReader(classStream);
            cr.accept(classVisitor, ClassInfo.ASM_CR_ACCEPT_CRITERIA);
        }
        catch (Exception ex) {
            throw new ClassReadingException("Unable to read class from open input stream", ex);
        }
    }

    private boolean isJar(String fileName) {
        return fileName.toLowerCase().endsWith(".jar");
    }

    private boolean isZip(String fileName) {
        return fileName.toLowerCase().endsWith(".zip");
    }

    private boolean isPossibleRoot(File file) {
        String path = file.getPath();
        return file.exists() && this.isJar(path) || this.isZip(path) || file.isDirectory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<Path> findFiles(File rootDir, PathFilter ... filters) {
        try (Stream<Path> paths = Files.walk(rootDir.toPath(), FileVisitOption.FOLLOW_LINKS);){
            Collection collection = paths.filter(path -> Arrays.stream(filters).allMatch(filter -> filter.accept((Path)path))).collect(Collectors.toList());
            return collection;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

