/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping.common;

import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeFactory;
import io.leangen.graphql.execution.ResolutionEnvironment;
import io.leangen.graphql.generator.mapping.AbstractTypeAdapter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StreamToCollectionTypeAdapter
extends AbstractTypeAdapter<Stream<?>, List<?>> {
    @Override
    public List<?> convertOutput(Stream<?> original, AnnotatedType type, ResolutionEnvironment resolutionEnvironment) {
        try (Stream<?> stream = original;){
            List list = stream.map(item -> resolutionEnvironment.convertOutput(item, this.getElementType(type))).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public Stream<?> convertInput(List<?> substitute, AnnotatedType type, ResolutionEnvironment resolutionEnvironment) {
        return substitute.stream().map(item -> resolutionEnvironment.convertInput(item, this.getElementType(type)));
    }

    @Override
    public AnnotatedType getSubstituteType(AnnotatedType original) {
        return TypeFactory.parameterizedAnnotatedClass(List.class, (Annotation[])original.getAnnotations(), (AnnotatedType[])new AnnotatedType[]{this.getElementType(original)});
    }

    private AnnotatedType getElementType(AnnotatedType type) {
        return GenericTypeReflector.getTypeParameter((AnnotatedType)type, Stream.class.getTypeParameters()[0]);
    }
}

