/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping.common;

import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.annotations.types.GraphQLInterface;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.OperationMapper;
import io.leangen.graphql.generator.mapping.common.CachingMapper;
import io.leangen.graphql.generator.mapping.common.ObjectTypeMapper;
import io.leangen.graphql.generator.mapping.strategy.InterfaceMappingStrategy;
import io.leangen.graphql.generator.types.MappedGraphQLInterfaceType;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.Utils;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class InterfaceMapper
extends CachingMapper<GraphQLInterfaceType, GraphQLInputObjectType> {
    private final InterfaceMappingStrategy interfaceStrategy;
    private final ObjectTypeMapper objectTypeMapper;

    public InterfaceMapper(InterfaceMappingStrategy interfaceStrategy, ObjectTypeMapper objectTypeMapper) {
        this.interfaceStrategy = interfaceStrategy;
        this.objectTypeMapper = objectTypeMapper;
    }

    @Override
    public GraphQLInterfaceType toGraphQLType(String typeName, AnnotatedType javaType, Set<Type> abstractTypes, OperationMapper operationMapper, BuildContext buildContext) {
        GraphQLInterface meta;
        GraphQLInterfaceType.Builder typeBuilder = GraphQLInterfaceType.newInterface().name(typeName).description(buildContext.typeInfoGenerator.generateTypeDescription(javaType));
        List<GraphQLFieldDefinition> fields = this.objectTypeMapper.getFields(javaType, buildContext, operationMapper);
        fields.forEach(arg_0 -> ((GraphQLInterfaceType.Builder)typeBuilder).field(arg_0));
        typeBuilder.typeResolver(buildContext.typeResolver);
        MappedGraphQLInterfaceType type = new MappedGraphQLInterfaceType(typeBuilder.build(), javaType);
        if (javaType.isAnnotationPresent(GraphQLInterface.class) && (meta = javaType.getAnnotation(GraphQLInterface.class)).implementationAutoDiscovery()) {
            String[] scanPackages = meta.scanPackages();
            if (scanPackages.length == 0 && Utils.notEmpty(buildContext.basePackage)) {
                scanPackages = new String[]{buildContext.basePackage};
            }
            ClassUtils.findImplementations(javaType, scanPackages).forEach(impl -> this.getImplementingType((AnnotatedType)impl, abstractTypes, operationMapper, buildContext).ifPresent(implType -> buildContext.typeRepository.registerDiscoveredCovariantType(type.getName(), (AnnotatedType)impl, (GraphQLObjectType)implType)));
        }
        return type;
    }

    @Override
    public GraphQLInputObjectType toGraphQLInputType(String typeName, AnnotatedType javaType, Set<Type> abstractTypes, OperationMapper operationMapper, BuildContext buildContext) {
        return this.objectTypeMapper.toGraphQLInputType(typeName, javaType, abstractTypes, operationMapper, buildContext);
    }

    @Override
    public boolean supports(AnnotatedType type) {
        return this.interfaceStrategy.supports(type);
    }

    private Optional<GraphQLObjectType> getImplementingType(AnnotatedType implType, Set<Type> abstractTypes, OperationMapper operationMapper, BuildContext buildContext) {
        return Optional.of(implType).filter(impl -> !GenericTypeReflector.isMissingTypeParameters((Type)impl.getType())).filter(impl -> !this.interfaceStrategy.supports((AnnotatedType)impl)).map(impl -> operationMapper.toGraphQLType((AnnotatedType)impl, abstractTypes, buildContext)).filter(impl -> impl instanceof GraphQLObjectType).map(impl -> (GraphQLObjectType)impl);
    }
}

