/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.execution;

import graphql.GraphQLException;
import graphql.schema.DataFetchingEnvironment;
import io.leangen.graphql.execution.ContextWrapper;
import io.leangen.graphql.execution.GlobalEnvironment;
import io.leangen.graphql.execution.ResolutionEnvironment;
import io.leangen.graphql.metadata.Operation;
import io.leangen.graphql.metadata.OperationArgument;
import io.leangen.graphql.metadata.Resolver;
import io.leangen.graphql.metadata.strategy.value.ValueMapper;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;

public class OperationExecutor {
    private final Operation operation;
    private final ValueMapper valueMapper;
    private final GlobalEnvironment globalEnvironment;

    public OperationExecutor(Operation operation, ValueMapper valueMapper, GlobalEnvironment globalEnvironment) {
        this.operation = operation;
        this.valueMapper = valueMapper;
        this.globalEnvironment = globalEnvironment;
    }

    public Object execute(DataFetchingEnvironment env) {
        Resolver resolver;
        if (env.getContext() instanceof ContextWrapper) {
            ContextWrapper context = (ContextWrapper)env.getContext();
            if (env.getArguments().get("clientMutationId") != null) {
                context.putExtension("clientMutationId", env.getArguments().get("clientMutationId"));
            }
        }
        if (this.operation.getResolvers().size() == 1) {
            resolver = this.operation.getResolvers().iterator().next();
        } else {
            Object[] nonNullArgumentNames = (String[])env.getArguments().entrySet().stream().filter(arg -> arg.getValue() != null).map(Map.Entry::getKey).toArray(String[]::new);
            resolver = this.operation.getResolver((String[])nonNullArgumentNames);
            if (resolver == null) {
                throw new GraphQLException("Resolver for operation " + this.operation.getName() + " accepting arguments: " + Arrays.toString(nonNullArgumentNames) + " not implemented");
            }
        }
        ResolutionEnvironment resolutionEnvironment = new ResolutionEnvironment(env, this.valueMapper, this.globalEnvironment);
        try {
            Object result = this.execute(resolver, resolutionEnvironment, env.getArguments());
            return resolutionEnvironment.convertOutput(result, resolver.getReturnType());
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private Object execute(Resolver resolver, ResolutionEnvironment resolutionEnvironment, Map<String, Object> rawArguments) throws InvocationTargetException, IllegalAccessException {
        int queryArgumentsCount = resolver.getArguments().size();
        Object[] args = new Object[queryArgumentsCount];
        for (int i = 0; i < queryArgumentsCount; ++i) {
            OperationArgument argDescriptor = resolver.getArguments().get(i);
            Object rawArgValue = rawArguments.get(argDescriptor.getName());
            args[i] = resolutionEnvironment.getInputValue(rawArgValue, argDescriptor.getJavaType());
        }
        return resolver.resolve(resolutionEnvironment.context, args);
    }
}

