/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.featuredetection.adap3d.datamodel;

import java.util.ArrayList;

public class Ridgeline {
    public int totalNumberOfScales;
    public int curBestInd = 0;
    public double curBestScale = 0.0;
    public double maxCorVal = 0.0;
    public ArrayList<Double> scales_ = new ArrayList();
    public ArrayList<Integer> indecies_ = new ArrayList();
    private ArrayList<Double> corValues_ = new ArrayList();
    private int curRunningGap_;

    public Ridgeline(double firstScale, int firstIndex, double corValue, int NScales) {
        this.scales_.add(firstScale);
        this.indecies_.add(firstIndex);
        this.corValues_.add(corValue);
        this.curRunningGap_ = 0;
        this.totalNumberOfScales = NScales;
    }

    public int getRunningGapNum() {
        return this.curRunningGap_;
    }

    public int getRidgeLength() {
        return this.scales_.size();
    }

    public double getRidgeStartScale() {
        return this.scales_.get(0);
    }

    public double getRidgeEndScale() {
        int l = this.scales_.size();
        return this.scales_.get(l - 1);
    }

    public void findBestValues() {
        int index = 0;
        int count = 0;
        double[] arrayMaxCorVal = new double[this.corValues_.size()];
        int[] arrayCurBestInd = new int[this.indecies_.size()];
        double[] arrayCurBestScale = new double[this.scales_.size()];
        for (int i = 0; i < this.indecies_.size(); ++i) {
            double curCor = this.corValues_.get(i);
            double previousCurCor = 0.0;
            double nextCurCor = 0.0;
            if (i - 1 >= 0) {
                previousCurCor = this.corValues_.get(i - 1);
            }
            if (i + 1 < this.indecies_.size()) {
                nextCurCor = this.corValues_.get(i + 1);
            }
            if (!(curCor > previousCurCor) || !(curCor > nextCurCor) || i - 1 < 0 || i + 1 > this.indecies_.size()) continue;
            arrayMaxCorVal[count] = curCor;
            arrayCurBestInd[count] = this.indecies_.get(i);
            arrayCurBestScale[count] = this.scales_.get(i);
            ++count;
        }
        double minValue = arrayCurBestScale[0];
        for (int i = 1; i < arrayCurBestScale.length; ++i) {
            if (!(arrayCurBestScale[i] < minValue) || arrayCurBestScale[i] == 0.0) continue;
            minValue = arrayCurBestScale[i];
            ++index;
        }
        this.maxCorVal = arrayMaxCorVal[index];
        this.curBestInd = arrayCurBestInd[index];
        this.curBestScale = minValue;
    }

    public boolean tryAddPoint(double scale, int index, double corValue) {
        double prevCor;
        int lastAddedInd = this.indecies_.get(this.indecies_.size() - 1);
        int indexDiff = Math.abs(lastAddedInd - index);
        int indexTol = (int)Math.round(this.findIndexTolFromScale(scale));
        boolean haveThisScaleAlready = false;
        double epsilon = 1.0E-9;
        if (this.scales_.get(this.scales_.size() - 1) <= scale + epsilon && this.scales_.get(this.scales_.size() - 1) >= scale - epsilon) {
            haveThisScaleAlready = true;
        }
        if (!haveThisScaleAlready) {
            if (indexDiff < 2 * indexTol) {
                this.scales_.add(scale);
                this.indecies_.add(index);
                this.corValues_.add(corValue);
                this.curRunningGap_ = 0;
                return true;
            }
            ++this.curRunningGap_;
            return false;
        }
        if (this.scales_.size() > 1) {
            int curIndexDiff;
            int prevIndexDiff = Math.abs(this.indecies_.get(this.indecies_.size() - 2) - this.indecies_.get(this.indecies_.size() - 1));
            if (prevIndexDiff > (curIndexDiff = Math.abs(this.indecies_.get(this.indecies_.size() - 2) - index))) {
                this.indecies_.set(this.indecies_.size() - 1, index);
                this.corValues_.set(this.indecies_.size() - 1, corValue);
                return true;
            }
        } else if (indexDiff < 2 * indexTol && corValue > (prevCor = this.corValues_.get(0).doubleValue())) {
            this.indecies_.set(this.indecies_.size() - 1, index);
            this.corValues_.set(this.indecies_.size() - 1, corValue);
            return true;
        }
        return false;
    }

    public double findIndexTolFromScale(double scale) {
        return scale;
    }
}

