/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.featuredetection.adap3d.datamodel;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Comparator;

public class PeakInfo
implements Comparator<PeakInfo>,
Comparable<PeakInfo>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final DecimalFormat DECIMAL = new DecimalFormat("#.00");
    public double retTime;
    public double mzValue;
    public double intensity;
    public double retTimeStart;
    public double retTimeEnd;
    public int peakID;
    public int peakIndex;
    public int leftApexIndex;
    public int rightApexIndex;
    public int leftPeakIndex;
    public int rightPeakIndex;
    public double signalToNoiseRatio;
    public double coeffOverArea;

    public PeakInfo() {
    }

    public PeakInfo(int peakIndex) {
        this.peakIndex = peakIndex;
    }

    public PeakInfo(PeakInfo info) {
        this.retTime = info.retTime;
        this.mzValue = info.mzValue;
        this.intensity = info.intensity;
        this.retTimeStart = info.retTimeStart;
        this.retTimeEnd = info.retTimeEnd;
        this.peakID = info.peakID;
        this.peakIndex = info.peakIndex;
        this.leftApexIndex = info.leftApexIndex;
        this.rightApexIndex = info.rightApexIndex;
        this.leftPeakIndex = info.leftPeakIndex;
        this.rightPeakIndex = info.rightPeakIndex;
        this.signalToNoiseRatio = info.signalToNoiseRatio;
    }

    public PeakInfo mzValue(double mz) {
        this.mzValue = mz;
        return this;
    }

    public PeakInfo peakID(int id) {
        this.peakID = id;
        return this;
    }

    @Override
    public int compare(PeakInfo info1, PeakInfo info2) {
        if (info1.peakIndex < info2.peakIndex) {
            return -1;
        }
        if (info1.peakIndex == info2.peakIndex) {
            return 0;
        }
        return 1;
    }

    @Override
    public int compareTo(PeakInfo info) {
        if (this.peakIndex < info.peakIndex) {
            return -1;
        }
        if (this.peakIndex == info.peakIndex) {
            return 0;
        }
        return 1;
    }

    public static PeakInfo merge(PeakInfo info1, PeakInfo info2) {
        if (info1.mzValue != info2.mzValue) {
            throw new IllegalArgumentException("Cannot merge PeakInfo with different m/z-values");
        }
        PeakInfo result = new PeakInfo();
        result.mzValue = info1.mzValue;
        if (info1.intensity > info2.intensity) {
            result.intensity = info1.intensity;
            result.peakIndex = info1.peakIndex;
        } else {
            result.intensity = info2.intensity;
            result.peakIndex = info2.peakIndex;
        }
        result.leftApexIndex = Integer.min(info1.leftApexIndex, info2.leftApexIndex);
        result.leftPeakIndex = Integer.min(info1.leftPeakIndex, info2.leftPeakIndex);
        result.rightApexIndex = Integer.max(info1.rightApexIndex, info2.rightApexIndex);
        result.rightPeakIndex = Integer.max(info1.rightPeakIndex, info2.rightPeakIndex);
        return result;
    }

    public String toString() {
        return "m/z " + DECIMAL.format(this.mzValue) + " @ " + DECIMAL.format(this.retTime) + " min.";
    }
}

