/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.featuredetection.adap3d.algorithms;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class Math {
    public static double[] interpolate(SortedSet<Double> x_values, NavigableMap<Double, Double> y_values) {
        double[] result = new double[x_values.size()];
        int index = 0;
        Map.Entry<Double, Double> firstEntry = y_values.firstEntry();
        Iterator it = y_values.entrySet().iterator();
        Map.Entry entry = it.next();
        Iterator iterator = x_values.iterator();
        while (iterator.hasNext()) {
            double x = (Double)iterator.next();
            while ((Double)entry.getKey() < x && it.hasNext()) {
                entry = it.next();
            }
            double key = (Double)entry.getKey();
            if (key == x) {
                result[index++] = (Double)entry.getValue();
                continue;
            }
            if (entry.equals(firstEntry)) {
                ++index;
                continue;
            }
            if (x < key) {
                Map.Entry<Double, Double> prevEntry = y_values.lowerEntry(key);
                result[index++] = ((Double)entry.getValue() - prevEntry.getValue()) / ((Double)entry.getKey() - prevEntry.getKey()) * (x - prevEntry.getKey()) + prevEntry.getValue();
                continue;
            }
            ++index;
        }
        return result;
    }

    public static double interpolate(double x_value, NavigableMap<Double, Double> y_values) {
        TreeSet<Double> x_values = new TreeSet<Double>();
        x_values.add(x_value);
        double[] interpolatedValues = Math.interpolate(x_values, y_values);
        if (interpolatedValues.length != 1) {
            throw new IllegalArgumentException("Cannot interpolate " + y_values + " at value " + x_value);
        }
        return interpolatedValues[0];
    }

    public static double continuous_dot_product(NavigableMap<Double, Double> f1, NavigableMap<Double, Double> f2) {
        TreeSet<Double> x_union = new TreeSet<Double>((SortedSet<Double>)f1.navigableKeySet());
        TreeSet<Double> x_union2 = new TreeSet<Double>((SortedSet<Double>)f2.navigableKeySet());
        x_union.addAll(x_union2);
        double[] f1interpolated = Math.interpolate(x_union, f1);
        double[] f2interpolated = Math.interpolate(x_union, f2);
        TreeMap<Double, Double> product = new TreeMap<Double, Double>();
        int index = 0;
        Iterator iterator = x_union.iterator();
        while (iterator.hasNext()) {
            double x = (Double)iterator.next();
            product.put(x, f1interpolated[index] * f2interpolated[index]);
            ++index;
        }
        return Math.integrate(product);
    }

    public static double continuous_dot_product(Map<Double, Double> f1, Map<Double, Double> f2) {
        return Math.continuous_dot_product(new TreeMap<Double, Double>(f1), new TreeMap<Double, Double>(f2));
    }

    public static double pearson_correlation(NavigableMap<Double, Double> f1, NavigableMap<Double, Double> f2) {
        TreeSet<Double> x_union = new TreeSet<Double>((SortedSet<Double>)f1.navigableKeySet());
        TreeSet<Double> x_union2 = new TreeSet<Double>((SortedSet<Double>)f2.navigableKeySet());
        x_union.addAll(x_union2);
        double[] f1interpolated = Math.interpolate(x_union, f1);
        double[] f2interpolated = Math.interpolate(x_union, f2);
        int size = x_union.size();
        double sum_x = 0.0;
        double sum_y = 0.0;
        double sum_xy = 0.0;
        double sum_x2 = 0.0;
        double sum_y2 = 0.0;
        for (int i = 0; i < size; ++i) {
            double x = f1interpolated[i];
            double y = f2interpolated[i];
            sum_x += x;
            sum_y += y;
            sum_xy += x * y;
            sum_x2 += x * x;
            sum_y2 += y * y;
        }
        double ave_x = sum_x / (double)size;
        double ave_y = sum_y / (double)size;
        double ave_xy = sum_xy / (double)size;
        double ave_x2 = sum_x2 / (double)size;
        double ave_y2 = sum_y2 / (double)size;
        return (ave_xy - ave_x * ave_y) / java.lang.Math.sqrt(ave_x2 - ave_x * ave_x) / java.lang.Math.sqrt(ave_y2 - ave_y * ave_y);
    }

    public static double integrate(NavigableMap<Double, Double> func) {
        Iterator it = func.entrySet().iterator();
        Map.Entry prevEntry = it.next();
        double result = 0.0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            result += 0.5 * ((Double)prevEntry.getValue() + (Double)entry.getValue()) * ((Double)entry.getKey() - (Double)prevEntry.getKey());
            prevEntry = entry;
        }
        return result;
    }

    public static double discrete_dot_product(NavigableMap<Double, Double> f1, NavigableMap<Double, Double> f2, double tolerance) {
        double result = 0.0;
        if (f1.isEmpty() || f2.isEmpty()) {
            return result;
        }
        Iterator it1 = f1.entrySet().iterator();
        Iterator it2 = f2.entrySet().iterator();
        Map.Entry entry1 = it1.next();
        Map.Entry entry2 = it2.next();
        try {
            while (true) {
                if ((Double)entry1.getKey() < (Double)entry2.getKey() - tolerance) {
                    entry1 = it1.next();
                    continue;
                }
                if ((Double)entry2.getKey() < (Double)entry1.getKey() - tolerance) {
                    entry2 = it2.next();
                    continue;
                }
                result += (Double)entry1.getValue() * (Double)entry2.getValue();
                entry1 = it1.next();
                entry2 = it2.next();
            }
        }
        catch (NoSuchElementException e) {
            return result;
        }
    }

    public static double discrete_dot_product(Map<Double, Double> f1, Map<Double, Double> f2, double tolerance) {
        return Math.discrete_dot_product(new TreeMap<Double, Double>(f1), new TreeMap<Double, Double>(f2), tolerance);
    }

    public static NavigableMap<Double, Double> differentiate(NavigableMap<Double, Double> func) {
        TreeMap<Double, Double> result = new TreeMap<Double, Double>();
        if (func.size() < 3) {
            return result;
        }
        Iterator it = func.entrySet().iterator();
        Map.Entry center = it.next();
        Map.Entry right = it.next();
        double centerX = (Double)center.getKey();
        double centerY = (Double)center.getValue();
        double rightX = (Double)right.getKey();
        double rightY = (Double)right.getValue();
        result.put(centerX, (rightY - centerY) / (rightX - centerX));
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            double leftX = centerX;
            double leftY = centerY;
            centerX = rightX;
            centerY = rightY;
            rightX = (Double)entry.getKey();
            rightY = (Double)entry.getValue();
            result.put(centerX, (rightY - leftY) / (rightX - leftX));
        }
        result.put(rightX, (rightY - centerY) / (rightX - centerX));
        return result;
    }

    public static double convolution(NavigableMap<Double, Double> f1, NavigableMap<Double, Double> f2, double shift) {
        TreeMap<Double, Double> shifted2 = new TreeMap<Double, Double>();
        for (Map.Entry entry : f2.entrySet()) {
            shifted2.put((Double)entry.getKey() + shift, (Double)entry.getValue());
        }
        return Math.continuous_dot_product(f1, shifted2);
    }

    public static NavigableMap<Double, Double> scale(NavigableMap<Double, Double> func, double scale) {
        TreeMap<Double, Double> result = new TreeMap<Double, Double>();
        for (Map.Entry entry : func.entrySet()) {
            result.put((Double)entry.getKey(), scale * (Double)entry.getValue());
        }
        return result;
    }

    public static NavigableMap<Double, Double> linearCombination(List<NavigableMap<Double, Double>> functions, double[] coefficients) {
        TreeMap<Double, Double> result = new TreeMap<Double, Double>();
        int size = Integer.min(functions.size(), coefficients.length);
        for (int i = 0; i < size; ++i) {
            for (Map.Entry e : functions.get(i).entrySet()) {
                double key = (Double)e.getKey();
                double value = coefficients[i] * (Double)e.getValue();
                result.put(key, result.getOrDefault(key, 0.0) + value);
            }
        }
        return result;
    }
}

