/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.featuredetection.adap3d.algorithms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NavigableMap;
import org.apache.commons.lang3.ArrayUtils;

public class FeatureTools {
    public static int fixRightBoundry(double[] intensities, int peakRight) {
        boolean foundLocalMin = false;
        int curRight = peakRight;
        int bestRight = peakRight;
        while (!foundLocalMin) {
            int checkRightPoint = curRight + 1;
            int checkLeftPoint = curRight - 1;
            if (checkLeftPoint <= 0) {
                return peakRight;
            }
            if (checkRightPoint >= intensities.length) {
                bestRight = curRight;
                foundLocalMin = true;
                continue;
            }
            if (intensities[curRight] < 1.0) {
                bestRight = curRight;
                foundLocalMin = true;
                continue;
            }
            if (intensities[checkRightPoint] >= intensities[curRight] && intensities[checkLeftPoint] >= intensities[curRight]) {
                bestRight = curRight;
                foundLocalMin = true;
                continue;
            }
            if (intensities[checkRightPoint] <= intensities[curRight]) {
                ++curRight;
                continue;
            }
            if (intensities[checkLeftPoint] < intensities[curRight]) {
                --curRight;
                continue;
            }
            return -1;
        }
        return bestRight;
    }

    public static int fixLeftBoundry(double[] intensities, int peakLeft) {
        boolean foundLocalMin = false;
        int curLeft = peakLeft;
        int bestLeft = peakLeft;
        while (!foundLocalMin) {
            int checkLeftPoint = curLeft - 1;
            int checkRightPoint = curLeft + 1;
            if (checkRightPoint >= intensities.length) {
                return peakLeft;
            }
            if (checkLeftPoint < 0) {
                bestLeft = curLeft;
                foundLocalMin = true;
                continue;
            }
            if (intensities[curLeft] < 1.0) {
                bestLeft = curLeft;
                foundLocalMin = true;
                continue;
            }
            if (intensities[checkRightPoint] >= intensities[curLeft] && intensities[checkLeftPoint] >= intensities[curLeft]) {
                bestLeft = curLeft;
                foundLocalMin = true;
                continue;
            }
            if (intensities[checkLeftPoint] <= intensities[curLeft]) {
                --curLeft;
                continue;
            }
            if (intensities[checkRightPoint] < intensities[curLeft]) {
                ++curLeft;
                continue;
            }
            return -1;
        }
        return bestLeft;
    }

    public static boolean isShared(double[] rt, double[] intensities, int peakLeft, int peakRight, double edgeToHeightRatio, double deltaToHeightRatio) {
        double peakHeight = 0.0;
        for (int i = peakLeft; i < peakRight + 1; ++i) {
            double curInt = intensities[i];
            if (!(curInt > peakHeight)) continue;
            peakHeight = curInt;
        }
        assert (peakHeight > 0.0);
        double leftInt = intensities[peakLeft];
        double rightInt = intensities[peakRight];
        double leftToApexRatio = leftInt / peakHeight;
        double rightToApexRatio = rightInt / peakHeight;
        double boundToApexRatio = Math.abs(leftInt - rightInt) / peakHeight;
        boolean goodPeak = false;
        if (leftToApexRatio < edgeToHeightRatio && rightToApexRatio < edgeToHeightRatio && boundToApexRatio < deltaToHeightRatio) {
            goodPeak = true;
        }
        boolean meargeLeft = false;
        if (!goodPeak && leftToApexRatio >= rightToApexRatio) {
            meargeLeft = true;
        }
        boolean meargeRight = false;
        if (!goodPeak && leftToApexRatio < rightToApexRatio) {
            meargeLeft = true;
        }
        return meargeRight || meargeLeft;
    }

    public static boolean isShared(List<Double> intensities, double edgeToHeightThreshold, double deltaToHeightThreshold) {
        int size = intensities.size();
        double leftIntensity = intensities.get(0);
        double rightIntensity = intensities.get(size - 1);
        double absoluteMaximum = Double.max(leftIntensity, rightIntensity);
        int localMaximaCount = 0;
        int index = 1;
        while (index < size - 1) {
            double currentValue = intensities.get(index);
            if (currentValue > absoluteMaximum) {
                absoluteMaximum = currentValue;
            }
            int prevIndex = index - 1;
            int nextIndex = index + 1;
            while (nextIndex + 1 < size && currentValue == intensities.get(nextIndex)) {
                ++nextIndex;
            }
            if (intensities.get(prevIndex) < currentValue && currentValue > intensities.get(nextIndex)) {
                ++localMaximaCount;
            }
            index = nextIndex;
        }
        if (localMaximaCount > 1) {
            return true;
        }
        double leftToApexRatio = leftIntensity / absoluteMaximum;
        double rightToApexRatio = rightIntensity / absoluteMaximum;
        double deltaToApexRatio = Math.abs(leftIntensity - rightIntensity) / absoluteMaximum;
        return leftToApexRatio >= edgeToHeightThreshold || rightToApexRatio >= edgeToHeightThreshold || deltaToApexRatio >= deltaToHeightThreshold;
    }

    public static double sharpnessAngleAvgSlopes(double[] rt, double[] intensities, int peakLeft, int peakRight) {
        int peakWidth = peakRight - peakLeft;
        int halfPeakWidthRoundUp = (int)Math.round((double)peakWidth / 2.0);
        int peakIndex = 0;
        double peakHeight = 0.0;
        for (int i = peakLeft; i < peakRight + 1; ++i) {
            double curInt = intensities[i];
            if (!(curInt > peakHeight)) continue;
            peakHeight = curInt;
            peakIndex = i;
        }
        assert (peakHeight > 0.0);
        double peakX = peakIndex;
        int finalLeft = peakLeft - halfPeakWidthRoundUp;
        if (finalLeft < 0) {
            finalLeft = 0;
        }
        double sumOfLeftSlope = 0.0;
        int numLeft = 0;
        for (int i = peakIndex - 1; i >= finalLeft; --i) {
            double curX = i;
            double curY = intensities[i];
            double curSlope = (peakHeight - curY) / (peakX - curX);
            sumOfLeftSlope += curSlope;
            ++numLeft;
        }
        double meanLeftSlope = sumOfLeftSlope / (double)numLeft;
        double rad_left_theta = Math.atan(1.0 / Math.abs(meanLeftSlope));
        int finalRight = peakRight + halfPeakWidthRoundUp;
        if (finalRight >= intensities.length) {
            finalRight = intensities.length - 1;
        }
        double sumOfRightSlope = 0.0;
        int numRight = 0;
        for (int i = peakIndex + 1; i <= finalRight; ++i) {
            double curX = i;
            double curY = intensities[i];
            double curSlope = (curY - peakHeight) / (curX - peakX);
            sumOfRightSlope += curSlope;
            ++numRight;
        }
        double meanRightSlope = sumOfRightSlope / (double)numRight;
        double rad_right_theta = Math.atan(1.0 / Math.abs(meanRightSlope));
        if (meanRightSlope > 0.0) {
            rad_right_theta = Math.PI - rad_right_theta;
        }
        if (meanLeftSlope < 0.0) {
            rad_left_theta = Math.PI - rad_left_theta;
        }
        double angle_between = rad_left_theta + rad_right_theta;
        return angle_between;
    }

    public static double sharpnessYang(NavigableMap<Double, Double> chromatogram) {
        int size = chromatogram.size();
        double[] retTimes = ArrayUtils.toPrimitive((Double[])chromatogram.keySet().toArray(new Double[size]));
        double[] intensities = ArrayUtils.toPrimitive((Double[])chromatogram.values().toArray(new Double[size]));
        return FeatureTools.sharpnessYang(retTimes, intensities, 0, size - 1);
    }

    public static double sharpnessYang(double[] rt, double[] intensities, int peakLeft, int peakRight) {
        double s2;
        double s1;
        int peakIndex = 0;
        double peakHeight = 0.0;
        for (int i = peakLeft; i < peakRight + 1; ++i) {
            double curInt = intensities[i];
            if (!(curInt > peakHeight)) continue;
            peakHeight = curInt;
            peakIndex = i;
        }
        assert (peakHeight > 0.0);
        double rightHeight = intensities[peakRight];
        double leftHeight = intensities[peakLeft];
        double rightRT = rt[peakRight];
        double leftRT = rt[peakLeft];
        double slope = (rightHeight - leftHeight) / (rightRT - leftRT);
        double peakRT = rt[peakIndex];
        double intercept = leftHeight - slope * leftRT;
        double heightOnLineAtPeakLoc = slope * peakRT + intercept;
        double p25Height = 0.25 * (peakHeight - heightOnLineAtPeakLoc);
        if (p25Height < 0.0) {
            return -1.0;
        }
        p25Height += heightOnLineAtPeakLoc;
        ArrayList<Double> leftSlopes = new ArrayList<Double>();
        for (int i = peakLeft; i < peakIndex; ++i) {
            if (intensities[i] < p25Height) continue;
            double curSlope = (peakHeight - intensities[i]) / (double)(peakIndex - i);
            leftSlopes.add(curSlope);
        }
        Collections.sort(leftSlopes);
        ArrayList<Double> rightSlopes = new ArrayList<Double>();
        for (int i = peakIndex + 1; i <= peakRight; ++i) {
            if (intensities[i] < p25Height) continue;
            double curSlope = (intensities[i] - peakHeight) / (double)(i - peakIndex);
            rightSlopes.add(curSlope);
        }
        Collections.sort(rightSlopes);
        double medianLeft = 0.0;
        double medianRight = 0.0;
        if (!leftSlopes.isEmpty()) {
            if (leftSlopes.size() % 2 == 0) {
                s1 = (Double)leftSlopes.get(leftSlopes.size() / 2);
                s2 = (Double)leftSlopes.get(leftSlopes.size() / 2 - 1);
                medianLeft = (s1 + s2) / 2.0;
            } else {
                medianLeft = (Double)leftSlopes.get(leftSlopes.size() / 2);
            }
        }
        if (!rightSlopes.isEmpty()) {
            if (rightSlopes.size() % 2 == 0) {
                s1 = (Double)rightSlopes.get(rightSlopes.size() / 2);
                s2 = (Double)rightSlopes.get(rightSlopes.size() / 2 - 1);
                medianRight = (s1 + s2) / 2.0;
            } else {
                medianRight = (Double)rightSlopes.get(rightSlopes.size() / 2);
            }
        }
        if (leftSlopes.isEmpty() && rightSlopes.isEmpty()) {
            return -1.0;
        }
        if (rightSlopes.isEmpty()) {
            return medianLeft;
        }
        if (leftSlopes.isEmpty()) {
            return medianRight;
        }
        return (medianLeft - medianRight) / 2.0;
    }

    public static double sharpnessAngleAvgAngles(double[] rt, double[] intensities, int peakLeft, int peakRight) {
        int peakWidth = peakRight - peakLeft;
        int halfPeakWidthRoundUp = (int)Math.round((double)peakWidth / 2.0);
        int peakIndex = 0;
        double peakHeight = 0.0;
        for (int i = peakLeft; i < peakRight + 1; ++i) {
            double curInt = intensities[i];
            if (!(curInt > peakHeight)) continue;
            peakHeight = curInt;
            peakIndex = i;
        }
        assert (peakHeight > 0.0);
        double weightStep = 1.0;
        double sumOfWeights = 0.0;
        double peakX = peakIndex;
        int finalLeft = peakIndex - halfPeakWidthRoundUp;
        if (finalLeft < 0) {
            finalLeft = 0;
        }
        double sumOfLeftAngle = 0.0;
        int numLeft = 0;
        for (int i = peakIndex - 1; i >= finalLeft; --i) {
            double curX = i;
            double curY = intensities[i];
            double curSlope = (peakHeight - curY) / (peakX - curX);
            double cur_left_theta = Math.atan(1.0 / Math.abs(curSlope));
            if (curSlope < 0.0) {
                cur_left_theta = Math.PI - cur_left_theta;
            }
            sumOfLeftAngle += weightStep * (double)(numLeft + 1) * cur_left_theta;
            sumOfWeights += weightStep * (double)(numLeft + 1);
            ++numLeft;
        }
        double meanLeftAngle = sumOfLeftAngle / sumOfWeights;
        sumOfWeights = 0.0;
        int finalRight = peakIndex + halfPeakWidthRoundUp;
        if (finalRight >= intensities.length) {
            finalRight = intensities.length - 1;
        }
        double sumOfRightAngle = 0.0;
        int numRight = 0;
        for (int i = peakIndex + 1; i <= finalRight; ++i) {
            double curX = i;
            double curY = intensities[i];
            double curSlope = (curY - peakHeight) / (curX - peakX);
            double cur_right_theta = Math.atan(1.0 / Math.abs(curSlope));
            if (curSlope > 0.0) {
                cur_right_theta = Math.PI - cur_right_theta;
            }
            sumOfRightAngle += weightStep * (double)(numRight + 1) * cur_right_theta;
            sumOfWeights += weightStep * (double)(numRight + 1);
            ++numRight;
        }
        double meanRightAngle = sumOfRightAngle / sumOfWeights;
        double angle_between = meanLeftAngle + meanRightAngle;
        return angle_between;
    }

    public static double findMeanOfSignal(double[] intensities, int peakLeft, int peakRight) {
        double meanSignal = 0.0;
        int count = 0;
        for (int i = peakLeft; i <= peakRight; ++i) {
            ++count;
            meanSignal += intensities[i];
        }
        return meanSignal / (double)count;
    }

    public static double findMinIntensityOfSignal(double[] intensities, int peakLeft, int peakRight) {
        double peakHeight = 0.0;
        for (int i = peakLeft; i < peakRight + 1; ++i) {
            double curInt = intensities[i];
            if (!(curInt > peakHeight)) continue;
            peakHeight = curInt;
        }
        double minSig = peakHeight;
        for (int i = peakLeft; i <= peakRight; ++i) {
            double curInt = intensities[i];
            if (!(curInt < minSig)) continue;
            minSig = curInt;
        }
        return minSig;
    }

    public static double trapazoidAreaUnderCurve(double[] intensities, double[] retentionTimes, int peakLeft, int peakRight) {
        double area = 0.0;
        for (int i = peakLeft; i < peakRight; ++i) {
            double w = retentionTimes[i + 1] - retentionTimes[i];
            double triangle = 0.5 * w * Math.abs(intensities[i] - intensities[i + 1]);
            double h = Math.min(intensities[i], intensities[i + 1]);
            area += triangle + w * h;
        }
        return area;
    }
}

