/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.featuredetection.adap3d.algorithms;

import io.github.msdk.featuredetection.adap3d.algorithms.SliceSparseMatrix;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.fitting.GaussianCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoints;

public class CurveTool {
    public static final double FWHM_CONSTANT = 2.35482;
    private static final double EXPONENT_FACTOR = 0.2;
    private static final double EXPONENT_SHIFT = Math.exp(-5.0);
    private static final double EXPONENT_HEIGHT = 1.0 / (1.0 - EXPONENT_SHIFT);
    private SliceSparseMatrix objSliceSparseMatrix;

    public CurveTool(SliceSparseMatrix sliceSparseMatrix) {
        this.objSliceSparseMatrix = sliceSparseMatrix;
    }

    public double estimateFwhmMs() {
        double sigma = 0.0;
        int countProperIteration = 0;
        int countTotalIteration = 0;
        int size = this.objSliceSparseMatrix.getSizeOfRawDataFile();
        while (countProperIteration < size && (double)countTotalIteration < this.objSliceSparseMatrix.numOfScans()) {
            ++countTotalIteration;
            List<SliceSparseMatrix.VerticalSliceDataPoint> verticalSlice = this.objSliceSparseMatrix.getVerticalSlice(countProperIteration);
            if (verticalSlice == null) continue;
            WeightedObservedPoints obs = new WeightedObservedPoints();
            for (SliceSparseMatrix.VerticalSliceDataPoint datapoint : verticalSlice) {
                obs.add((double)datapoint.mz, (double)datapoint.intensity);
            }
            try {
                double[] parameters = GaussianCurveFitter.create().fit((Collection)obs.toList());
                sigma += 2.35482 * parameters[2];
            }
            catch (MathIllegalArgumentException e) {
                continue;
            }
            ++countProperIteration;
        }
        double fwhm = sigma / (double)size;
        return fwhm;
    }

    public static double similarityValue(double[] referenceEIC, double[] gaussianValues, int leftBound, int rightBound) {
        double diffArea = 0.0;
        for (int j = 0; j < rightBound - leftBound; ++j) {
            diffArea += Math.abs(0.5 * (referenceEIC[j] - gaussianValues[j] + (referenceEIC[j + 1] - gaussianValues[j + 1])));
        }
        double curSimilarity = (Math.exp(-diffArea / 0.2) - EXPONENT_SHIFT) * EXPONENT_HEIGHT;
        return curSimilarity;
    }

    public static double normalize(List<SliceSparseMatrix.Triplet> slice, int leftBound, int rightBound, int roundedMz, double[] referenceEIC) {
        Comparator<SliceSparseMatrix.Triplet> compare = new Comparator<SliceSparseMatrix.Triplet>(){

            @Override
            public int compare(SliceSparseMatrix.Triplet o1, SliceSparseMatrix.Triplet o2) {
                int scan1 = o1.scanListIndex;
                int scan2 = o2.scanListIndex;
                int scanCompare = Integer.compare(scan1, scan2);
                if (scanCompare != 0) {
                    return scanCompare;
                }
                int mz1 = o1.mz;
                int mz2 = o2.mz;
                return Integer.compare(mz1, mz2);
            }
        };
        Collections.sort(slice, compare);
        double[] intensityValues = new double[rightBound - leftBound + 1];
        for (int i = 0; i < rightBound - leftBound + 1; ++i) {
            SliceSparseMatrix.Triplet searchTriplet = new SliceSparseMatrix.Triplet();
            searchTriplet.mz = roundedMz;
            searchTriplet.scanListIndex = i + leftBound;
            SliceSparseMatrix.Triplet obj = slice.get(Collections.binarySearch(slice, searchTriplet, compare));
            intensityValues[i] = obj.intensity;
        }
        return CurveTool.normalize(intensityValues, referenceEIC);
    }

    public static double normalize(double[] values, double[] normValues) {
        int i;
        double area = 0.0;
        for (i = 0; i < values.length - 1; ++i) {
            area += 0.5 * (values[i] + values[i + 1]);
        }
        for (i = 0; i < values.length; ++i) {
            normValues[i] = values[i] / area;
        }
        return area;
    }

    public static float normalize(float[] values) {
        float area = 0.0f;
        for (int i = 0; i < values.length - 1; ++i) {
            area = (float)((double)area + 0.5 * (double)(values[i] + values[i + 1]));
        }
        return area;
    }
}

