/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.featuredetection.adap3d.algorithms;

import com.google.common.collect.Range;
import io.github.msdk.featuredetection.adap3d.algorithms.FeatureTools;
import io.github.msdk.featuredetection.adap3d.algorithms.SortAndKeepOriginalIndecies;
import io.github.msdk.featuredetection.adap3d.datamodel.Result;
import io.github.msdk.featuredetection.adap3d.datamodel.Ridgeline;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ContinuousWaveletTransform {
    private double smallScale;
    private double largeScale;
    private double incrementScale;
    private ArrayList<Double> arrScales = new ArrayList();
    private HashMap<Double, Integer> mapScaleToIndex = new HashMap();
    private double[] signal;
    private double[] x;
    private double avgXSpace;
    private double[][] allCoefficients;
    private ArrayList<Ridgeline> ridgeLineArr = new ArrayList();
    private Range<Double> peakWidth;
    private double coefAreaRatioTolerance;
    int scaleCoefHowFarOut = 5;

    public double[][] returnAllCoefficients() {
        return this.allCoefficients;
    }

    public ContinuousWaveletTransform(double smallScaleIn, double largeScaleIn, double incrementScaleIn) {
        this.smallScale = smallScaleIn;
        this.largeScale = largeScaleIn;
        this.incrementScale = incrementScaleIn;
        int index = 0;
        for (double curScale = this.smallScale; curScale <= this.largeScale; curScale += this.incrementScale) {
            this.arrScales.add(curScale);
            this.mapScaleToIndex.put(curScale, index);
            ++index;
        }
    }

    public void setPeakWidth(double lowerbound, double upperbound) {
        this.peakWidth = Range.closed((Comparable)Double.valueOf(lowerbound), (Comparable)Double.valueOf(upperbound));
    }

    public void setPeakWidth(Range<Double> peakWidthObject) {
        this.peakWidth = peakWidthObject;
    }

    public void setcoefAreaRatioTolerance(double userInputCoefAreaRatioTolerance) {
        this.coefAreaRatioTolerance = userInputCoefAreaRatioTolerance;
    }

    public int[] croppedPeakWidth(int peakLeft, int peakRight) {
        double curInt;
        int alpha;
        int croppedPeakLeft = -1;
        int croppedPeakRight = -1;
        int[] toReturn = new int[]{croppedPeakLeft, croppedPeakRight};
        boolean allZero = true;
        for (alpha = peakLeft; alpha < peakRight; ++alpha) {
            curInt = this.signal[alpha];
            if (curInt == 0.0) continue;
            allZero = false;
            break;
        }
        if (allZero) {
            return toReturn;
        }
        for (alpha = peakLeft; alpha < peakRight; ++alpha) {
            curInt = this.signal[alpha];
            if (curInt == 0.0) continue;
            croppedPeakLeft = alpha;
            break;
        }
        for (alpha = peakRight; alpha > peakLeft; --alpha) {
            curInt = this.signal[alpha];
            if (curInt == 0.0) continue;
            croppedPeakRight = alpha;
            break;
        }
        if (croppedPeakLeft != peakLeft) {
            --croppedPeakLeft;
        }
        if (croppedPeakRight != peakRight) {
            ++croppedPeakRight;
        }
        if (croppedPeakLeft == -2) {
            System.out.println("bug");
        }
        toReturn[0] = croppedPeakLeft;
        toReturn[1] = croppedPeakRight;
        return toReturn;
    }

    public boolean numberOfZeros(int peakLeft, int peakRight) {
        int numZeros = 0;
        int numNotZero = 0;
        double epsilon = 1.0E-4;
        for (int alpha = peakLeft; alpha <= peakRight; ++alpha) {
            if (this.signal[alpha] < epsilon) {
                ++numZeros;
                continue;
            }
            ++numNotZero;
        }
        return numZeros >= numNotZero;
    }

    public double findArea(int peakLeft, int peakRight) {
        double curArea = FeatureTools.trapazoidAreaUnderCurve(this.signal, this.x, peakLeft, peakRight);
        return curArea;
    }

    public List<Result> findPeaks() {
        this.buildRidgelines();
        this.filterRidgelines();
        ArrayList<Result> resultList = new ArrayList<Result>();
        double[][] boundsAndBestCoef = new double[3][];
        for (int i = 0; i < 3; ++i) {
            boundsAndBestCoef[i] = new double[this.x.length];
            Arrays.fill(boundsAndBestCoef[i], 0.0);
        }
        for (Ridgeline curRL : this.ridgeLineArr) {
            double retentionTimeLeft;
            double retentionTimeRight;
            double curArea;
            double normedCoef;
            boolean checkNumberOfZeros;
            int curLeftBound;
            Result result = new Result();
            curRL.findBestValues();
            int bestIndex = curRL.curBestInd;
            double bestScale = curRL.curBestScale;
            double bestCoefficient = curRL.maxCorVal;
            int curRightBound = bestIndex + (int)Math.round(bestScale);
            if (curRightBound >= this.x.length) {
                curRightBound = this.x.length - 1;
            }
            if ((curLeftBound = bestIndex - (int)Math.round(bestScale)) < 0) {
                curLeftBound = 0;
            }
            curLeftBound = FeatureTools.fixLeftBoundry(this.signal, curLeftBound);
            curRightBound = FeatureTools.fixRightBoundry(this.signal, curRightBound);
            int[] croppedBounds = new int[2];
            croppedBounds = this.croppedPeakWidth(curLeftBound, curRightBound);
            curLeftBound = croppedBounds[0];
            curRightBound = croppedBounds[1];
            if (curLeftBound == -1 || curRightBound == -1 || (checkNumberOfZeros = this.numberOfZeros(curLeftBound, curRightBound)) || (normedCoef = bestCoefficient / (curArea = this.findArea(curLeftBound, curRightBound))) < this.coefAreaRatioTolerance || !this.peakWidth.contains((Comparable)Double.valueOf((retentionTimeRight = this.x[curRightBound]) - (retentionTimeLeft = this.x[curLeftBound])))) continue;
            result.curLeftBound = curLeftBound;
            result.curRightBound = curRightBound;
            result.bestCoefficient = bestCoefficient;
            result.curArea = curArea;
            result.coefOverArea = normedCoef;
            resultList.add(result);
        }
        return resultList;
    }

    public void filterRidgelines() {
        ArrayList<Ridgeline> filteredRidgelines = new ArrayList<Ridgeline>();
        for (int i = 0; i < this.ridgeLineArr.size(); ++i) {
            int NScales;
            Ridgeline curRL = this.ridgeLineArr.get(i);
            int ridgeLength = curRL.getRidgeLength();
            if (ridgeLength < (NScales = curRL.totalNumberOfScales) - 3) continue;
            filteredRidgelines.add(curRL);
        }
        this.ridgeLineArr = filteredRidgelines;
    }

    public void buildRidgelines() {
        this.getCoefficientsForAllScales();
        for (int i = this.arrScales.size() - 1; i >= 0; --i) {
            double curScale = this.arrScales.get(i);
            int indexOfThisWaveletScale = this.mapScaleToIndex.get(curScale);
            double[] curCoefficients = this.allCoefficients[indexOfThisWaveletScale];
            Integer[] thisScaleBestMaxima = this.findMaximaForThisScale(curScale);
            for (int j = 0; j < thisScaleBestMaxima.length; ++j) {
                boolean wasMatched = false;
                int curBestMaxLoc = thisScaleBestMaxima[j];
                for (int alpha = 0; alpha < this.ridgeLineArr.size(); ++alpha) {
                    boolean wasAdded = this.ridgeLineArr.get(alpha).tryAddPoint(curScale, curBestMaxLoc, curCoefficients[thisScaleBestMaxima[j]]);
                    if (!wasAdded) continue;
                    wasMatched = true;
                }
                if (wasMatched) continue;
                Ridgeline curStartRidge = new Ridgeline(curScale, thisScaleBestMaxima[j], curCoefficients[thisScaleBestMaxima[j]], this.arrScales.size());
                this.ridgeLineArr.add(curStartRidge);
            }
        }
    }

    public Integer[] findMaximaForThisScale(double waveletScale) {
        int i;
        int removeCutOff = (int)Math.round(waveletScale * 2.5);
        ArrayList<Integer> maximaLocations = new ArrayList<Integer>();
        int indexOfThisWaveletScale = this.mapScaleToIndex.get(waveletScale);
        double[] curCoefficients = this.allCoefficients[indexOfThisWaveletScale];
        SortAndKeepOriginalIndecies comparator = new SortAndKeepOriginalIndecies(curCoefficients);
        Integer[] indecies = comparator.makeArrOfIndecies();
        Arrays.sort(indecies, comparator);
        HashMap<Integer, Boolean> mapIndexToBoolRemain = new HashMap<Integer, Boolean>();
        for (i = 0; i < indecies.length; ++i) {
            mapIndexToBoolRemain.put(indecies[i], true);
        }
        for (i = indecies.length - 1; i >= 0; --i) {
            if (!((Boolean)mapIndexToBoolRemain.get(indecies[i])).booleanValue()) continue;
            int curLargestIndex = indecies[i];
            maximaLocations.add(curLargestIndex);
            mapIndexToBoolRemain.put(curLargestIndex, false);
            for (int j = 1; j < removeCutOff; ++j) {
                int curRemoveIndexRight = curLargestIndex + j;
                int curRemoveIndexLeft = curLargestIndex - j;
                if (curRemoveIndexLeft >= 0) {
                    mapIndexToBoolRemain.put(curRemoveIndexLeft, false);
                }
                if (curRemoveIndexRight >= this.x.length) continue;
                mapIndexToBoolRemain.put(curRemoveIndexRight, false);
            }
        }
        Integer[] toReturn = maximaLocations.toArray(new Integer[maximaLocations.size()]);
        return toReturn;
    }

    public void getCoefficientsForAllScales() {
        int NScales = this.arrScales.size();
        this.allCoefficients = new double[NScales][];
        int count = 0;
        for (Double curScale : this.arrScales) {
            this.allCoefficients[count] = this.getCoefficientsForThisScale(curScale);
            ++count;
        }
    }

    public double[] getCoefficientsForThisScale(double waveletScale) {
        double[] coefficientsForThisScale = new double[this.x.length];
        for (int i = 0; i < this.x.length; ++i) {
            double currentCoefficient;
            coefficientsForThisScale[i] = currentCoefficient = this.signalWaveletInnerProductOnePoint(i, waveletScale);
        }
        return coefficientsForThisScale;
    }

    public double signalWaveletInnerProductOnePoint(int xIndexOfWaveletMax, double waveletScale) {
        int leftBoundIntegrate = (int)Math.round((double)xIndexOfWaveletMax - (double)this.scaleCoefHowFarOut * waveletScale - 1.0);
        int rightBoundIntegrate = (int)Math.round((double)xIndexOfWaveletMax + (double)this.scaleCoefHowFarOut * waveletScale + 1.0);
        if (leftBoundIntegrate < 0) {
            leftBoundIntegrate = 0;
        }
        if (rightBoundIntegrate >= this.x.length) {
            rightBoundIntegrate = this.x.length - 1;
        }
        double innerProduct = 0.0;
        for (int i = leftBoundIntegrate; i <= rightBoundIntegrate; ++i) {
            double curY = this.signal[i];
            double waveletY = this.rickerWavelet(this.x[i] - this.x[xIndexOfWaveletMax], waveletScale);
            innerProduct += curY * waveletY;
        }
        return innerProduct;
    }

    public double rickerWavelet(double x, double scalParam) {
        double A = 2.0 / Math.sqrt(3.0 * (scalParam *= this.avgXSpace) * Math.sqrt(Math.PI)) * (1.0 - Math.pow(x, 2.0) / Math.pow(scalParam, 2.0));
        return Math.exp(-Math.pow(x, 2.0) / (2.0 * Math.pow(scalParam, 2.0))) * A;
    }

    public void setSignal(List<DataPoint> listOfDataPoint) {
        this.signal = new double[listOfDataPoint.size()];
        for (int i = 0; i < listOfDataPoint.size(); ++i) {
            this.signal[i] = listOfDataPoint.get((int)i).intensity;
        }
    }

    public void setX(List<DataPoint> listOfDataPoint) {
        this.x = new double[listOfDataPoint.size()];
        for (int i = 0; i < listOfDataPoint.size(); ++i) {
            this.x[i] = listOfDataPoint.get((int)i).rt;
        }
        double curSumSpacing = 0.0;
        for (int i = 0; i < listOfDataPoint.size() - 1; ++i) {
            curSumSpacing += listOfDataPoint.get((int)(i + 1)).rt - listOfDataPoint.get((int)i).rt;
        }
        this.avgXSpace = curSumSpacing / (double)(listOfDataPoint.size() - 1);
    }

    public double[] doubleTheNumberOfPtsX(double[] xIn) {
        double[] xOut = new double[xIn.length * 2 - 1];
        for (int i = 1; i < xIn.length - 1; ++i) {
            double addInX = (xIn[i] + xIn[i + 1]) / 2.0;
            xOut[2 * i] = xIn[i];
            xOut[2 * i + 1] = addInX;
        }
        return xOut;
    }

    public double[] doubleTheNumberOfPtsDataY(double[] yIn) {
        double[] yOut = new double[yIn.length * 2 - 1];
        for (int i = 1; i < yIn.length - 1; ++i) {
            double addInX = (yIn[i] + yIn[i + 1]) / 2.0;
            yOut[2 * i] = yIn[i];
            yOut[2 * i + 1] = addInX;
        }
        return yOut;
    }

    public static class DataPoint {
        public double rt;
        public double intensity;
    }
}

