/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.featuredetection.adap3d.algorithms;

import io.github.msdk.featuredetection.adap3d.algorithms.SliceSparseMatrix;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class BiGaussian {
    public final double maxHeight;
    public final int mu;
    public final double sigmaLeft;
    public final double sigmaRight;

    BiGaussian(List<SliceSparseMatrix.Triplet> horizontalSlice, int roundedmz, int leftBound, int rightBound) {
        this.maxHeight = horizontalSlice.stream().map(x -> x != null ? (double)x.intensity : 0.0).max(Double::compareTo).orElse(0.0);
        this.mu = this.getScanNumber(horizontalSlice, this.maxHeight);
        double halfHeight = this.maxHeight / 2.0;
        double interpolationLeftSideX = this.InterpolationX(horizontalSlice, this.mu, halfHeight, leftBound, rightBound, roundedmz, Direction.LEFT);
        this.sigmaLeft = ((double)this.mu - interpolationLeftSideX) / Math.sqrt(2.0 * Math.log(2.0));
        double interpolationRightSideX = this.InterpolationX(horizontalSlice, this.mu, halfHeight, leftBound, rightBound, roundedmz, Direction.RIGHT);
        this.sigmaRight = (interpolationRightSideX - (double)this.mu) / Math.sqrt(2.0 * Math.log(2.0));
    }

    private double InterpolationX(List<SliceSparseMatrix.Triplet> horizontalSlice, int mu, double halfHeight, int leftBound, int rightBound, int roundedmz, Direction direction) {
        int i = mu;
        double Y1 = Double.NaN;
        double Y2 = Double.NaN;
        int step = direction == Direction.RIGHT ? 1 : -1;
        Comparator<SliceSparseMatrix.Triplet> compareScanMz = new Comparator<SliceSparseMatrix.Triplet>(){

            @Override
            public int compare(SliceSparseMatrix.Triplet o1, SliceSparseMatrix.Triplet o2) {
                int scan1 = o1.scanListIndex;
                int scan2 = o2.scanListIndex;
                int scanCompare = Integer.compare(scan1, scan2);
                if (scanCompare != 0) {
                    return scanCompare;
                }
                int mz1 = o1.mz;
                int mz2 = o2.mz;
                return Integer.compare(mz1, mz2);
            }
        };
        Collections.sort(horizontalSlice, compareScanMz);
        while (leftBound <= i && i <= rightBound) {
            SliceSparseMatrix.Triplet searchTriplet1 = new SliceSparseMatrix.Triplet();
            searchTriplet1.mz = roundedmz;
            searchTriplet1.scanListIndex = i += step;
            int index1 = Collections.binarySearch(horizontalSlice, searchTriplet1, compareScanMz);
            if (index1 < 0) continue;
            SliceSparseMatrix.Triplet triplet1 = horizontalSlice.get(index1);
            if (triplet1.intensity == 0.0f || !((double)triplet1.intensity < halfHeight)) continue;
            SliceSparseMatrix.Triplet searchTriplet2 = new SliceSparseMatrix.Triplet();
            searchTriplet2.mz = roundedmz;
            searchTriplet2.scanListIndex = i - step;
            Y1 = triplet1.intensity;
            int index2 = Collections.binarySearch(horizontalSlice, searchTriplet2, compareScanMz);
            if (index2 < 0) continue;
            SliceSparseMatrix.Triplet triplet2 = horizontalSlice.get(index2);
            if (triplet2.intensity == 0.0f) continue;
            Y2 = triplet2.intensity;
            break;
        }
        if (Y1 == Double.NaN || Y2 == Double.NaN) {
            throw new IllegalArgumentException("Cannot find BiGaussian.");
        }
        double X = (halfHeight - Y1) * (double)(i - step - i) / (Y2 - Y1) + (double)i;
        return X;
    }

    private int getScanNumber(List<SliceSparseMatrix.Triplet> horizontalSlice, double height) {
        int mu = 0;
        for (SliceSparseMatrix.Triplet triplet : horizontalSlice) {
            if ((double)triplet.intensity != height) continue;
            mu = triplet.scanListIndex;
            break;
        }
        return mu;
    }

    public double getValue(int x) {
        double sigma = x >= this.mu ? this.sigmaRight : this.sigmaLeft;
        double exponentialTerm = Math.exp(-1.0 * Math.pow(x - this.mu, 2.0) / (2.0 * Math.pow(sigma, 2.0)));
        return this.maxHeight * exponentialTerm;
    }

    static enum Direction {
        RIGHT,
        LEFT;

    }
}

