/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1beta1.HTTPConfig;
import io.fabric8.openshift.api.model.monitoring.v1beta1.HTTPConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1beta1.HTTPConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1beta1.KeyValue;
import io.fabric8.openshift.api.model.monitoring.v1beta1.KeyValueBuilder;
import io.fabric8.openshift.api.model.monitoring.v1beta1.KeyValueFluent;
import io.fabric8.openshift.api.model.monitoring.v1beta1.PagerDutyConfig;
import io.fabric8.openshift.api.model.monitoring.v1beta1.PagerDutyImageConfig;
import io.fabric8.openshift.api.model.monitoring.v1beta1.PagerDutyImageConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1beta1.PagerDutyImageConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1beta1.PagerDutyLinkConfig;
import io.fabric8.openshift.api.model.monitoring.v1beta1.PagerDutyLinkConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1beta1.PagerDutyLinkConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1beta1.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1beta1.SecretKeySelectorBuilder;
import io.fabric8.openshift.api.model.monitoring.v1beta1.SecretKeySelectorFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PagerDutyConfigFluent<A extends PagerDutyConfigFluent<A>>
extends BaseFluent<A> {
    private String className;
    private String client;
    private String clientURL;
    private String component;
    private String description;
    private ArrayList<KeyValueBuilder> details = new ArrayList();
    private String group;
    private HTTPConfigBuilder httpConfig;
    private ArrayList<PagerDutyImageConfigBuilder> pagerDutyImageConfigs = new ArrayList();
    private ArrayList<PagerDutyLinkConfigBuilder> pagerDutyLinkConfigs = new ArrayList();
    private SecretKeySelectorBuilder routingKey;
    private Boolean sendResolved;
    private SecretKeySelectorBuilder serviceKey;
    private String severity;
    private String source;
    private String url;
    private Map<String, Object> additionalProperties;

    public PagerDutyConfigFluent() {
    }

    public PagerDutyConfigFluent(PagerDutyConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PagerDutyConfig instance) {
        PagerDutyConfig pagerDutyConfig = instance = instance != null ? instance : new PagerDutyConfig();
        if (instance != null) {
            this.withClassName(instance.getClassName());
            this.withClient(instance.getClient());
            this.withClientURL(instance.getClientURL());
            this.withComponent(instance.getComponent());
            this.withDescription(instance.getDescription());
            this.withDetails(instance.getDetails());
            this.withGroup(instance.getGroup());
            this.withHttpConfig(instance.getHttpConfig());
            this.withPagerDutyImageConfigs(instance.getPagerDutyImageConfigs());
            this.withPagerDutyLinkConfigs(instance.getPagerDutyLinkConfigs());
            this.withRoutingKey(instance.getRoutingKey());
            this.withSendResolved(instance.getSendResolved());
            this.withServiceKey(instance.getServiceKey());
            this.withSeverity(instance.getSeverity());
            this.withSource(instance.getSource());
            this.withUrl(instance.getUrl());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getClassName() {
        return this.className;
    }

    public A withClassName(String className) {
        this.className = className;
        return (A)((Object)this);
    }

    public boolean hasClassName() {
        return this.className != null;
    }

    public String getClient() {
        return this.client;
    }

    public A withClient(String client) {
        this.client = client;
        return (A)((Object)this);
    }

    public boolean hasClient() {
        return this.client != null;
    }

    public String getClientURL() {
        return this.clientURL;
    }

    public A withClientURL(String clientURL) {
        this.clientURL = clientURL;
        return (A)((Object)this);
    }

    public boolean hasClientURL() {
        return this.clientURL != null;
    }

    public String getComponent() {
        return this.component;
    }

    public A withComponent(String component) {
        this.component = component;
        return (A)((Object)this);
    }

    public boolean hasComponent() {
        return this.component != null;
    }

    public String getDescription() {
        return this.description;
    }

    public A withDescription(String description) {
        this.description = description;
        return (A)((Object)this);
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public A addToDetails(int index, KeyValue item) {
        if (this.details == null) {
            this.details = new ArrayList();
        }
        KeyValueBuilder builder = new KeyValueBuilder(item);
        if (index < 0 || index >= this.details.size()) {
            this._visitables.get((Object)"details").add(builder);
            this.details.add(builder);
        } else {
            this._visitables.get((Object)"details").add(builder);
            this.details.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToDetails(int index, KeyValue item) {
        if (this.details == null) {
            this.details = new ArrayList();
        }
        KeyValueBuilder builder = new KeyValueBuilder(item);
        if (index < 0 || index >= this.details.size()) {
            this._visitables.get((Object)"details").add(builder);
            this.details.add(builder);
        } else {
            this._visitables.get((Object)"details").add(builder);
            this.details.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToDetails(KeyValue ... items) {
        if (this.details == null) {
            this.details = new ArrayList();
        }
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get((Object)"details").add(builder);
            this.details.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToDetails(Collection<KeyValue> items) {
        if (this.details == null) {
            this.details = new ArrayList();
        }
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get((Object)"details").add(builder);
            this.details.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromDetails(KeyValue ... items) {
        if (this.details == null) {
            return (A)((Object)this);
        }
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get((Object)"details").remove((Object)builder);
            this.details.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDetails(Collection<KeyValue> items) {
        if (this.details == null) {
            return (A)((Object)this);
        }
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get((Object)"details").remove((Object)builder);
            this.details.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromDetails(Predicate<KeyValueBuilder> predicate) {
        if (this.details == null) {
            return (A)((Object)this);
        }
        Iterator<KeyValueBuilder> each = this.details.iterator();
        List visitables = this._visitables.get((Object)"details");
        while (each.hasNext()) {
            KeyValueBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<KeyValue> buildDetails() {
        return this.details != null ? PagerDutyConfigFluent.build(this.details) : null;
    }

    public KeyValue buildDetail(int index) {
        return this.details.get(index).build();
    }

    public KeyValue buildFirstDetail() {
        return this.details.get(0).build();
    }

    public KeyValue buildLastDetail() {
        return this.details.get(this.details.size() - 1).build();
    }

    public KeyValue buildMatchingDetail(Predicate<KeyValueBuilder> predicate) {
        for (KeyValueBuilder item : this.details) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDetail(Predicate<KeyValueBuilder> predicate) {
        for (KeyValueBuilder item : this.details) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDetails(List<KeyValue> details) {
        if (this.details != null) {
            this._visitables.get((Object)"details").clear();
        }
        if (details != null) {
            this.details = new ArrayList();
            for (KeyValue item : details) {
                this.addToDetails(item);
            }
        } else {
            this.details = null;
        }
        return (A)((Object)this);
    }

    public A withDetails(KeyValue ... details) {
        if (this.details != null) {
            this.details.clear();
            this._visitables.remove((Object)"details");
        }
        if (details != null) {
            for (KeyValue item : details) {
                this.addToDetails(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDetails() {
        return this.details != null && !this.details.isEmpty();
    }

    public A addNewDetail(String key, String value) {
        return this.addToDetails(new KeyValue(key, value));
    }

    public DetailsNested<A> addNewDetail() {
        return new DetailsNested(-1, null);
    }

    public DetailsNested<A> addNewDetailLike(KeyValue item) {
        return new DetailsNested(-1, item);
    }

    public DetailsNested<A> setNewDetailLike(int index, KeyValue item) {
        return new DetailsNested(index, item);
    }

    public DetailsNested<A> editDetail(int index) {
        if (this.details.size() <= index) {
            throw new RuntimeException("Can't edit details. Index exceeds size.");
        }
        return this.setNewDetailLike(index, this.buildDetail(index));
    }

    public DetailsNested<A> editFirstDetail() {
        if (this.details.size() == 0) {
            throw new RuntimeException("Can't edit first details. The list is empty.");
        }
        return this.setNewDetailLike(0, this.buildDetail(0));
    }

    public DetailsNested<A> editLastDetail() {
        int index = this.details.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last details. The list is empty.");
        }
        return this.setNewDetailLike(index, this.buildDetail(index));
    }

    public DetailsNested<A> editMatchingDetail(Predicate<KeyValueBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.details.size(); ++i) {
            if (!predicate.test(this.details.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching details. No match found.");
        }
        return this.setNewDetailLike(index, this.buildDetail(index));
    }

    public String getGroup() {
        return this.group;
    }

    public A withGroup(String group) {
        this.group = group;
        return (A)((Object)this);
    }

    public boolean hasGroup() {
        return this.group != null;
    }

    public HTTPConfig buildHttpConfig() {
        return this.httpConfig != null ? this.httpConfig.build() : null;
    }

    public A withHttpConfig(HTTPConfig httpConfig) {
        this._visitables.remove((Object)"httpConfig");
        if (httpConfig != null) {
            this.httpConfig = new HTTPConfigBuilder(httpConfig);
            this._visitables.get((Object)"httpConfig").add(this.httpConfig);
        } else {
            this.httpConfig = null;
            this._visitables.get((Object)"httpConfig").remove((Object)this.httpConfig);
        }
        return (A)((Object)this);
    }

    public boolean hasHttpConfig() {
        return this.httpConfig != null;
    }

    public HttpConfigNested<A> withNewHttpConfig() {
        return new HttpConfigNested(null);
    }

    public HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
        return new HttpConfigNested(item);
    }

    public HttpConfigNested<A> editHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(null));
    }

    public HttpConfigNested<A> editOrNewHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(new HTTPConfigBuilder().build()));
    }

    public HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(item));
    }

    public A addToPagerDutyImageConfigs(int index, PagerDutyImageConfig item) {
        if (this.pagerDutyImageConfigs == null) {
            this.pagerDutyImageConfigs = new ArrayList();
        }
        PagerDutyImageConfigBuilder builder = new PagerDutyImageConfigBuilder(item);
        if (index < 0 || index >= this.pagerDutyImageConfigs.size()) {
            this._visitables.get((Object)"pagerDutyImageConfigs").add(builder);
            this.pagerDutyImageConfigs.add(builder);
        } else {
            this._visitables.get((Object)"pagerDutyImageConfigs").add(builder);
            this.pagerDutyImageConfigs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPagerDutyImageConfigs(int index, PagerDutyImageConfig item) {
        if (this.pagerDutyImageConfigs == null) {
            this.pagerDutyImageConfigs = new ArrayList();
        }
        PagerDutyImageConfigBuilder builder = new PagerDutyImageConfigBuilder(item);
        if (index < 0 || index >= this.pagerDutyImageConfigs.size()) {
            this._visitables.get((Object)"pagerDutyImageConfigs").add(builder);
            this.pagerDutyImageConfigs.add(builder);
        } else {
            this._visitables.get((Object)"pagerDutyImageConfigs").add(builder);
            this.pagerDutyImageConfigs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPagerDutyImageConfigs(PagerDutyImageConfig ... items) {
        if (this.pagerDutyImageConfigs == null) {
            this.pagerDutyImageConfigs = new ArrayList();
        }
        for (PagerDutyImageConfig item : items) {
            PagerDutyImageConfigBuilder builder = new PagerDutyImageConfigBuilder(item);
            this._visitables.get((Object)"pagerDutyImageConfigs").add(builder);
            this.pagerDutyImageConfigs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPagerDutyImageConfigs(Collection<PagerDutyImageConfig> items) {
        if (this.pagerDutyImageConfigs == null) {
            this.pagerDutyImageConfigs = new ArrayList();
        }
        for (PagerDutyImageConfig item : items) {
            PagerDutyImageConfigBuilder builder = new PagerDutyImageConfigBuilder(item);
            this._visitables.get((Object)"pagerDutyImageConfigs").add(builder);
            this.pagerDutyImageConfigs.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPagerDutyImageConfigs(PagerDutyImageConfig ... items) {
        if (this.pagerDutyImageConfigs == null) {
            return (A)((Object)this);
        }
        for (PagerDutyImageConfig item : items) {
            PagerDutyImageConfigBuilder builder = new PagerDutyImageConfigBuilder(item);
            this._visitables.get((Object)"pagerDutyImageConfigs").remove((Object)builder);
            this.pagerDutyImageConfigs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPagerDutyImageConfigs(Collection<PagerDutyImageConfig> items) {
        if (this.pagerDutyImageConfigs == null) {
            return (A)((Object)this);
        }
        for (PagerDutyImageConfig item : items) {
            PagerDutyImageConfigBuilder builder = new PagerDutyImageConfigBuilder(item);
            this._visitables.get((Object)"pagerDutyImageConfigs").remove((Object)builder);
            this.pagerDutyImageConfigs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPagerDutyImageConfigs(Predicate<PagerDutyImageConfigBuilder> predicate) {
        if (this.pagerDutyImageConfigs == null) {
            return (A)((Object)this);
        }
        Iterator<PagerDutyImageConfigBuilder> each = this.pagerDutyImageConfigs.iterator();
        List visitables = this._visitables.get((Object)"pagerDutyImageConfigs");
        while (each.hasNext()) {
            PagerDutyImageConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<PagerDutyImageConfig> buildPagerDutyImageConfigs() {
        return this.pagerDutyImageConfigs != null ? PagerDutyConfigFluent.build(this.pagerDutyImageConfigs) : null;
    }

    public PagerDutyImageConfig buildPagerDutyImageConfig(int index) {
        return this.pagerDutyImageConfigs.get(index).build();
    }

    public PagerDutyImageConfig buildFirstPagerDutyImageConfig() {
        return this.pagerDutyImageConfigs.get(0).build();
    }

    public PagerDutyImageConfig buildLastPagerDutyImageConfig() {
        return this.pagerDutyImageConfigs.get(this.pagerDutyImageConfigs.size() - 1).build();
    }

    public PagerDutyImageConfig buildMatchingPagerDutyImageConfig(Predicate<PagerDutyImageConfigBuilder> predicate) {
        for (PagerDutyImageConfigBuilder item : this.pagerDutyImageConfigs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPagerDutyImageConfig(Predicate<PagerDutyImageConfigBuilder> predicate) {
        for (PagerDutyImageConfigBuilder item : this.pagerDutyImageConfigs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPagerDutyImageConfigs(List<PagerDutyImageConfig> pagerDutyImageConfigs) {
        if (this.pagerDutyImageConfigs != null) {
            this._visitables.get((Object)"pagerDutyImageConfigs").clear();
        }
        if (pagerDutyImageConfigs != null) {
            this.pagerDutyImageConfigs = new ArrayList();
            for (PagerDutyImageConfig item : pagerDutyImageConfigs) {
                this.addToPagerDutyImageConfigs(item);
            }
        } else {
            this.pagerDutyImageConfigs = null;
        }
        return (A)((Object)this);
    }

    public A withPagerDutyImageConfigs(PagerDutyImageConfig ... pagerDutyImageConfigs) {
        if (this.pagerDutyImageConfigs != null) {
            this.pagerDutyImageConfigs.clear();
            this._visitables.remove((Object)"pagerDutyImageConfigs");
        }
        if (pagerDutyImageConfigs != null) {
            for (PagerDutyImageConfig item : pagerDutyImageConfigs) {
                this.addToPagerDutyImageConfigs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPagerDutyImageConfigs() {
        return this.pagerDutyImageConfigs != null && !this.pagerDutyImageConfigs.isEmpty();
    }

    public A addNewPagerDutyImageConfig(String alt, String href, String src) {
        return this.addToPagerDutyImageConfigs(new PagerDutyImageConfig(alt, href, src));
    }

    public PagerDutyImageConfigsNested<A> addNewPagerDutyImageConfig() {
        return new PagerDutyImageConfigsNested(-1, null);
    }

    public PagerDutyImageConfigsNested<A> addNewPagerDutyImageConfigLike(PagerDutyImageConfig item) {
        return new PagerDutyImageConfigsNested(-1, item);
    }

    public PagerDutyImageConfigsNested<A> setNewPagerDutyImageConfigLike(int index, PagerDutyImageConfig item) {
        return new PagerDutyImageConfigsNested(index, item);
    }

    public PagerDutyImageConfigsNested<A> editPagerDutyImageConfig(int index) {
        if (this.pagerDutyImageConfigs.size() <= index) {
            throw new RuntimeException("Can't edit pagerDutyImageConfigs. Index exceeds size.");
        }
        return this.setNewPagerDutyImageConfigLike(index, this.buildPagerDutyImageConfig(index));
    }

    public PagerDutyImageConfigsNested<A> editFirstPagerDutyImageConfig() {
        if (this.pagerDutyImageConfigs.size() == 0) {
            throw new RuntimeException("Can't edit first pagerDutyImageConfigs. The list is empty.");
        }
        return this.setNewPagerDutyImageConfigLike(0, this.buildPagerDutyImageConfig(0));
    }

    public PagerDutyImageConfigsNested<A> editLastPagerDutyImageConfig() {
        int index = this.pagerDutyImageConfigs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last pagerDutyImageConfigs. The list is empty.");
        }
        return this.setNewPagerDutyImageConfigLike(index, this.buildPagerDutyImageConfig(index));
    }

    public PagerDutyImageConfigsNested<A> editMatchingPagerDutyImageConfig(Predicate<PagerDutyImageConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.pagerDutyImageConfigs.size(); ++i) {
            if (!predicate.test(this.pagerDutyImageConfigs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching pagerDutyImageConfigs. No match found.");
        }
        return this.setNewPagerDutyImageConfigLike(index, this.buildPagerDutyImageConfig(index));
    }

    public A addToPagerDutyLinkConfigs(int index, PagerDutyLinkConfig item) {
        if (this.pagerDutyLinkConfigs == null) {
            this.pagerDutyLinkConfigs = new ArrayList();
        }
        PagerDutyLinkConfigBuilder builder = new PagerDutyLinkConfigBuilder(item);
        if (index < 0 || index >= this.pagerDutyLinkConfigs.size()) {
            this._visitables.get((Object)"pagerDutyLinkConfigs").add(builder);
            this.pagerDutyLinkConfigs.add(builder);
        } else {
            this._visitables.get((Object)"pagerDutyLinkConfigs").add(builder);
            this.pagerDutyLinkConfigs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPagerDutyLinkConfigs(int index, PagerDutyLinkConfig item) {
        if (this.pagerDutyLinkConfigs == null) {
            this.pagerDutyLinkConfigs = new ArrayList();
        }
        PagerDutyLinkConfigBuilder builder = new PagerDutyLinkConfigBuilder(item);
        if (index < 0 || index >= this.pagerDutyLinkConfigs.size()) {
            this._visitables.get((Object)"pagerDutyLinkConfigs").add(builder);
            this.pagerDutyLinkConfigs.add(builder);
        } else {
            this._visitables.get((Object)"pagerDutyLinkConfigs").add(builder);
            this.pagerDutyLinkConfigs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPagerDutyLinkConfigs(PagerDutyLinkConfig ... items) {
        if (this.pagerDutyLinkConfigs == null) {
            this.pagerDutyLinkConfigs = new ArrayList();
        }
        for (PagerDutyLinkConfig item : items) {
            PagerDutyLinkConfigBuilder builder = new PagerDutyLinkConfigBuilder(item);
            this._visitables.get((Object)"pagerDutyLinkConfigs").add(builder);
            this.pagerDutyLinkConfigs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPagerDutyLinkConfigs(Collection<PagerDutyLinkConfig> items) {
        if (this.pagerDutyLinkConfigs == null) {
            this.pagerDutyLinkConfigs = new ArrayList();
        }
        for (PagerDutyLinkConfig item : items) {
            PagerDutyLinkConfigBuilder builder = new PagerDutyLinkConfigBuilder(item);
            this._visitables.get((Object)"pagerDutyLinkConfigs").add(builder);
            this.pagerDutyLinkConfigs.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPagerDutyLinkConfigs(PagerDutyLinkConfig ... items) {
        if (this.pagerDutyLinkConfigs == null) {
            return (A)((Object)this);
        }
        for (PagerDutyLinkConfig item : items) {
            PagerDutyLinkConfigBuilder builder = new PagerDutyLinkConfigBuilder(item);
            this._visitables.get((Object)"pagerDutyLinkConfigs").remove((Object)builder);
            this.pagerDutyLinkConfigs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPagerDutyLinkConfigs(Collection<PagerDutyLinkConfig> items) {
        if (this.pagerDutyLinkConfigs == null) {
            return (A)((Object)this);
        }
        for (PagerDutyLinkConfig item : items) {
            PagerDutyLinkConfigBuilder builder = new PagerDutyLinkConfigBuilder(item);
            this._visitables.get((Object)"pagerDutyLinkConfigs").remove((Object)builder);
            this.pagerDutyLinkConfigs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPagerDutyLinkConfigs(Predicate<PagerDutyLinkConfigBuilder> predicate) {
        if (this.pagerDutyLinkConfigs == null) {
            return (A)((Object)this);
        }
        Iterator<PagerDutyLinkConfigBuilder> each = this.pagerDutyLinkConfigs.iterator();
        List visitables = this._visitables.get((Object)"pagerDutyLinkConfigs");
        while (each.hasNext()) {
            PagerDutyLinkConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<PagerDutyLinkConfig> buildPagerDutyLinkConfigs() {
        return this.pagerDutyLinkConfigs != null ? PagerDutyConfigFluent.build(this.pagerDutyLinkConfigs) : null;
    }

    public PagerDutyLinkConfig buildPagerDutyLinkConfig(int index) {
        return this.pagerDutyLinkConfigs.get(index).build();
    }

    public PagerDutyLinkConfig buildFirstPagerDutyLinkConfig() {
        return this.pagerDutyLinkConfigs.get(0).build();
    }

    public PagerDutyLinkConfig buildLastPagerDutyLinkConfig() {
        return this.pagerDutyLinkConfigs.get(this.pagerDutyLinkConfigs.size() - 1).build();
    }

    public PagerDutyLinkConfig buildMatchingPagerDutyLinkConfig(Predicate<PagerDutyLinkConfigBuilder> predicate) {
        for (PagerDutyLinkConfigBuilder item : this.pagerDutyLinkConfigs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPagerDutyLinkConfig(Predicate<PagerDutyLinkConfigBuilder> predicate) {
        for (PagerDutyLinkConfigBuilder item : this.pagerDutyLinkConfigs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPagerDutyLinkConfigs(List<PagerDutyLinkConfig> pagerDutyLinkConfigs) {
        if (this.pagerDutyLinkConfigs != null) {
            this._visitables.get((Object)"pagerDutyLinkConfigs").clear();
        }
        if (pagerDutyLinkConfigs != null) {
            this.pagerDutyLinkConfigs = new ArrayList();
            for (PagerDutyLinkConfig item : pagerDutyLinkConfigs) {
                this.addToPagerDutyLinkConfigs(item);
            }
        } else {
            this.pagerDutyLinkConfigs = null;
        }
        return (A)((Object)this);
    }

    public A withPagerDutyLinkConfigs(PagerDutyLinkConfig ... pagerDutyLinkConfigs) {
        if (this.pagerDutyLinkConfigs != null) {
            this.pagerDutyLinkConfigs.clear();
            this._visitables.remove((Object)"pagerDutyLinkConfigs");
        }
        if (pagerDutyLinkConfigs != null) {
            for (PagerDutyLinkConfig item : pagerDutyLinkConfigs) {
                this.addToPagerDutyLinkConfigs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPagerDutyLinkConfigs() {
        return this.pagerDutyLinkConfigs != null && !this.pagerDutyLinkConfigs.isEmpty();
    }

    public A addNewPagerDutyLinkConfig(String alt, String href) {
        return this.addToPagerDutyLinkConfigs(new PagerDutyLinkConfig(alt, href));
    }

    public PagerDutyLinkConfigsNested<A> addNewPagerDutyLinkConfig() {
        return new PagerDutyLinkConfigsNested(-1, null);
    }

    public PagerDutyLinkConfigsNested<A> addNewPagerDutyLinkConfigLike(PagerDutyLinkConfig item) {
        return new PagerDutyLinkConfigsNested(-1, item);
    }

    public PagerDutyLinkConfigsNested<A> setNewPagerDutyLinkConfigLike(int index, PagerDutyLinkConfig item) {
        return new PagerDutyLinkConfigsNested(index, item);
    }

    public PagerDutyLinkConfigsNested<A> editPagerDutyLinkConfig(int index) {
        if (this.pagerDutyLinkConfigs.size() <= index) {
            throw new RuntimeException("Can't edit pagerDutyLinkConfigs. Index exceeds size.");
        }
        return this.setNewPagerDutyLinkConfigLike(index, this.buildPagerDutyLinkConfig(index));
    }

    public PagerDutyLinkConfigsNested<A> editFirstPagerDutyLinkConfig() {
        if (this.pagerDutyLinkConfigs.size() == 0) {
            throw new RuntimeException("Can't edit first pagerDutyLinkConfigs. The list is empty.");
        }
        return this.setNewPagerDutyLinkConfigLike(0, this.buildPagerDutyLinkConfig(0));
    }

    public PagerDutyLinkConfigsNested<A> editLastPagerDutyLinkConfig() {
        int index = this.pagerDutyLinkConfigs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last pagerDutyLinkConfigs. The list is empty.");
        }
        return this.setNewPagerDutyLinkConfigLike(index, this.buildPagerDutyLinkConfig(index));
    }

    public PagerDutyLinkConfigsNested<A> editMatchingPagerDutyLinkConfig(Predicate<PagerDutyLinkConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.pagerDutyLinkConfigs.size(); ++i) {
            if (!predicate.test(this.pagerDutyLinkConfigs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching pagerDutyLinkConfigs. No match found.");
        }
        return this.setNewPagerDutyLinkConfigLike(index, this.buildPagerDutyLinkConfig(index));
    }

    public SecretKeySelector buildRoutingKey() {
        return this.routingKey != null ? this.routingKey.build() : null;
    }

    public A withRoutingKey(SecretKeySelector routingKey) {
        this._visitables.remove((Object)"routingKey");
        if (routingKey != null) {
            this.routingKey = new SecretKeySelectorBuilder(routingKey);
            this._visitables.get((Object)"routingKey").add(this.routingKey);
        } else {
            this.routingKey = null;
            this._visitables.get((Object)"routingKey").remove((Object)this.routingKey);
        }
        return (A)((Object)this);
    }

    public boolean hasRoutingKey() {
        return this.routingKey != null;
    }

    public A withNewRoutingKey(String key, String name) {
        return this.withRoutingKey(new SecretKeySelector(key, name));
    }

    public RoutingKeyNested<A> withNewRoutingKey() {
        return new RoutingKeyNested(null);
    }

    public RoutingKeyNested<A> withNewRoutingKeyLike(SecretKeySelector item) {
        return new RoutingKeyNested(item);
    }

    public RoutingKeyNested<A> editRoutingKey() {
        return this.withNewRoutingKeyLike(Optional.ofNullable(this.buildRoutingKey()).orElse(null));
    }

    public RoutingKeyNested<A> editOrNewRoutingKey() {
        return this.withNewRoutingKeyLike(Optional.ofNullable(this.buildRoutingKey()).orElse(new SecretKeySelectorBuilder().build()));
    }

    public RoutingKeyNested<A> editOrNewRoutingKeyLike(SecretKeySelector item) {
        return this.withNewRoutingKeyLike(Optional.ofNullable(this.buildRoutingKey()).orElse(item));
    }

    public Boolean getSendResolved() {
        return this.sendResolved;
    }

    public A withSendResolved(Boolean sendResolved) {
        this.sendResolved = sendResolved;
        return (A)((Object)this);
    }

    public boolean hasSendResolved() {
        return this.sendResolved != null;
    }

    public SecretKeySelector buildServiceKey() {
        return this.serviceKey != null ? this.serviceKey.build() : null;
    }

    public A withServiceKey(SecretKeySelector serviceKey) {
        this._visitables.remove((Object)"serviceKey");
        if (serviceKey != null) {
            this.serviceKey = new SecretKeySelectorBuilder(serviceKey);
            this._visitables.get((Object)"serviceKey").add(this.serviceKey);
        } else {
            this.serviceKey = null;
            this._visitables.get((Object)"serviceKey").remove((Object)this.serviceKey);
        }
        return (A)((Object)this);
    }

    public boolean hasServiceKey() {
        return this.serviceKey != null;
    }

    public A withNewServiceKey(String key, String name) {
        return this.withServiceKey(new SecretKeySelector(key, name));
    }

    public ServiceKeyNested<A> withNewServiceKey() {
        return new ServiceKeyNested(null);
    }

    public ServiceKeyNested<A> withNewServiceKeyLike(SecretKeySelector item) {
        return new ServiceKeyNested(item);
    }

    public ServiceKeyNested<A> editServiceKey() {
        return this.withNewServiceKeyLike(Optional.ofNullable(this.buildServiceKey()).orElse(null));
    }

    public ServiceKeyNested<A> editOrNewServiceKey() {
        return this.withNewServiceKeyLike(Optional.ofNullable(this.buildServiceKey()).orElse(new SecretKeySelectorBuilder().build()));
    }

    public ServiceKeyNested<A> editOrNewServiceKeyLike(SecretKeySelector item) {
        return this.withNewServiceKeyLike(Optional.ofNullable(this.buildServiceKey()).orElse(item));
    }

    public String getSeverity() {
        return this.severity;
    }

    public A withSeverity(String severity) {
        this.severity = severity;
        return (A)((Object)this);
    }

    public boolean hasSeverity() {
        return this.severity != null;
    }

    public String getSource() {
        return this.source;
    }

    public A withSource(String source) {
        this.source = source;
        return (A)((Object)this);
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public String getUrl() {
        return this.url;
    }

    public A withUrl(String url) {
        this.url = url;
        return (A)((Object)this);
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PagerDutyConfigFluent that = (PagerDutyConfigFluent)((Object)o);
        if (!Objects.equals(this.className, that.className)) {
            return false;
        }
        if (!Objects.equals(this.client, that.client)) {
            return false;
        }
        if (!Objects.equals(this.clientURL, that.clientURL)) {
            return false;
        }
        if (!Objects.equals(this.component, that.component)) {
            return false;
        }
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.details, that.details)) {
            return false;
        }
        if (!Objects.equals(this.group, that.group)) {
            return false;
        }
        if (!Objects.equals((Object)this.httpConfig, (Object)that.httpConfig)) {
            return false;
        }
        if (!Objects.equals(this.pagerDutyImageConfigs, that.pagerDutyImageConfigs)) {
            return false;
        }
        if (!Objects.equals(this.pagerDutyLinkConfigs, that.pagerDutyLinkConfigs)) {
            return false;
        }
        if (!Objects.equals((Object)this.routingKey, (Object)that.routingKey)) {
            return false;
        }
        if (!Objects.equals(this.sendResolved, that.sendResolved)) {
            return false;
        }
        if (!Objects.equals((Object)this.serviceKey, (Object)that.serviceKey)) {
            return false;
        }
        if (!Objects.equals(this.severity, that.severity)) {
            return false;
        }
        if (!Objects.equals(this.source, that.source)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.className, this.client, this.clientURL, this.component, this.description, this.details, this.group, this.httpConfig, this.pagerDutyImageConfigs, this.pagerDutyLinkConfigs, this.routingKey, this.sendResolved, this.serviceKey, this.severity, this.source, this.url, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.className != null) {
            sb.append("className:");
            sb.append(this.className + ",");
        }
        if (this.client != null) {
            sb.append("client:");
            sb.append(this.client + ",");
        }
        if (this.clientURL != null) {
            sb.append("clientURL:");
            sb.append(this.clientURL + ",");
        }
        if (this.component != null) {
            sb.append("component:");
            sb.append(this.component + ",");
        }
        if (this.description != null) {
            sb.append("description:");
            sb.append(this.description + ",");
        }
        if (this.details != null && !this.details.isEmpty()) {
            sb.append("details:");
            sb.append(String.valueOf(this.details) + ",");
        }
        if (this.group != null) {
            sb.append("group:");
            sb.append(this.group + ",");
        }
        if (this.httpConfig != null) {
            sb.append("httpConfig:");
            sb.append(String.valueOf((Object)this.httpConfig) + ",");
        }
        if (this.pagerDutyImageConfigs != null && !this.pagerDutyImageConfigs.isEmpty()) {
            sb.append("pagerDutyImageConfigs:");
            sb.append(String.valueOf(this.pagerDutyImageConfigs) + ",");
        }
        if (this.pagerDutyLinkConfigs != null && !this.pagerDutyLinkConfigs.isEmpty()) {
            sb.append("pagerDutyLinkConfigs:");
            sb.append(String.valueOf(this.pagerDutyLinkConfigs) + ",");
        }
        if (this.routingKey != null) {
            sb.append("routingKey:");
            sb.append(String.valueOf((Object)this.routingKey) + ",");
        }
        if (this.sendResolved != null) {
            sb.append("sendResolved:");
            sb.append(this.sendResolved + ",");
        }
        if (this.serviceKey != null) {
            sb.append("serviceKey:");
            sb.append(String.valueOf((Object)this.serviceKey) + ",");
        }
        if (this.severity != null) {
            sb.append("severity:");
            sb.append(this.severity + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source + ",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withSendResolved() {
        return this.withSendResolved(true);
    }

    public class ServiceKeyNested<N>
    extends SecretKeySelectorFluent<ServiceKeyNested<N>>
    implements Nested<N> {
        SecretKeySelectorBuilder builder;

        ServiceKeyNested(SecretKeySelector item) {
            this.builder = new SecretKeySelectorBuilder(this, item);
        }

        public N and() {
            return (N)PagerDutyConfigFluent.this.withServiceKey(this.builder.build());
        }

        public N endServiceKey() {
            return this.and();
        }
    }

    public class RoutingKeyNested<N>
    extends SecretKeySelectorFluent<RoutingKeyNested<N>>
    implements Nested<N> {
        SecretKeySelectorBuilder builder;

        RoutingKeyNested(SecretKeySelector item) {
            this.builder = new SecretKeySelectorBuilder(this, item);
        }

        public N and() {
            return (N)PagerDutyConfigFluent.this.withRoutingKey(this.builder.build());
        }

        public N endRoutingKey() {
            return this.and();
        }
    }

    public class PagerDutyLinkConfigsNested<N>
    extends PagerDutyLinkConfigFluent<PagerDutyLinkConfigsNested<N>>
    implements Nested<N> {
        PagerDutyLinkConfigBuilder builder;
        int index;

        PagerDutyLinkConfigsNested(int index, PagerDutyLinkConfig item) {
            this.index = index;
            this.builder = new PagerDutyLinkConfigBuilder(this, item);
        }

        public N and() {
            return (N)PagerDutyConfigFluent.this.setToPagerDutyLinkConfigs(this.index, this.builder.build());
        }

        public N endPagerDutyLinkConfig() {
            return this.and();
        }
    }

    public class PagerDutyImageConfigsNested<N>
    extends PagerDutyImageConfigFluent<PagerDutyImageConfigsNested<N>>
    implements Nested<N> {
        PagerDutyImageConfigBuilder builder;
        int index;

        PagerDutyImageConfigsNested(int index, PagerDutyImageConfig item) {
            this.index = index;
            this.builder = new PagerDutyImageConfigBuilder(this, item);
        }

        public N and() {
            return (N)PagerDutyConfigFluent.this.setToPagerDutyImageConfigs(this.index, this.builder.build());
        }

        public N endPagerDutyImageConfig() {
            return this.and();
        }
    }

    public class HttpConfigNested<N>
    extends HTTPConfigFluent<HttpConfigNested<N>>
    implements Nested<N> {
        HTTPConfigBuilder builder;

        HttpConfigNested(HTTPConfig item) {
            this.builder = new HTTPConfigBuilder(this, item);
        }

        public N and() {
            return (N)PagerDutyConfigFluent.this.withHttpConfig(this.builder.build());
        }

        public N endHttpConfig() {
            return this.and();
        }
    }

    public class DetailsNested<N>
    extends KeyValueFluent<DetailsNested<N>>
    implements Nested<N> {
        KeyValueBuilder builder;
        int index;

        DetailsNested(int index, KeyValue item) {
            this.index = index;
            this.builder = new KeyValueBuilder(this, item);
        }

        public N and() {
            return (N)PagerDutyConfigFluent.this.setToDetails(this.index, this.builder.build());
        }

        public N endDetail() {
            return this.and();
        }
    }
}

