/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.ui.LoadMode;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;

public class RichText
extends Div {
    private static final long serialVersionUID = -6926829115110918731L;
    private transient Safelist safelist;
    private String richText;
    private UI ui;
    public static MarkdownStrategy markdownStrategy = new MarkdownItStrategy();

    public RichText() {
        this.setWidth("100%");
    }

    public RichText(String content) {
        this.setWidth("100%");
        this.setRichText(content);
    }

    public RichText withMarkDown(String markdown) {
        markdownStrategy.setMarkdown(markdown, this);
        return this;
    }

    public RichText withMarkDown(InputStream markdown) {
        try {
            String mdString = new String(markdown.readAllBytes(), StandardCharsets.UTF_8);
            markdownStrategy.setMarkdown(mdString, this);
            return this;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public RichText appendMarkDown(String markdownFragment) {
        markdownStrategy.appendMarkdown(markdownFragment, this);
        return this;
    }

    public RichText appendMarkDownAsync(String markdownFragment) {
        assert (this.ui != null);
        this.ui.access((Command & Serializable)() -> markdownStrategy.appendMarkdown(markdownFragment, this));
        return this;
    }

    public RichText withSafeHtml(String html) {
        return this.setRichText(html);
    }

    public RichText withSafeHtml(InputStream markdown) {
        try {
            return this.setRichText(new String(markdown.readAllBytes(), StandardCharsets.UTF_8));
        }
        catch (IOException ex) {
            throw new RuntimeException("Input stream coulnd't be read!", ex);
        }
    }

    public RichText withNewLines(String text) {
        return this.setRichText(text.replaceAll("(\\r|\\n|\\r\\n)+", "<br />"));
    }

    @Deprecated
    public Safelist getWhitelist() {
        return this.getSafelist();
    }

    public Safelist getSafelist() {
        if (this.safelist == null) {
            return Safelist.relaxed();
        }
        return this.safelist;
    }

    @Deprecated
    public RichText setSafelist(Safelist whitelist) {
        this.safelist = whitelist;
        return this;
    }

    @Deprecated
    public String getText() {
        return this.richText;
    }

    public RichText setRichText(String text) {
        this.getElement().executeJs("this.innerHTML = $0", new Object[]{Jsoup.clean((String)text, (Safelist)this.getWhitelist())});
        return this;
    }

    public RichText setRichTextAndSaveReference(String text) {
        this.richText = text;
        this.getElement().setProperty("innerHTML", Jsoup.clean((String)this.richText, (Safelist)this.getWhitelist()));
        return this;
    }

    public RichText withMarkDownResource(String resourceName) {
        return this.withMarkDown(((Object)((Object)this)).getClass().getResourceAsStream(resourceName));
    }

    public RichText withSafeHtmlResource(String resourceName) {
        return this.withSafeHtml(((Object)((Object)this)).getClass().getResourceAsStream(resourceName));
    }

    public RichText withContent(String content) {
        return this.setRichText(content);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.ui = attachEvent.getUI();
    }

    public static interface MarkdownStrategy {
        public void setMarkdown(String var1, RichText var2);

        public void appendMarkdown(String var1, RichText var2);
    }

    public static class MarkdownItStrategy
    implements MarkdownStrategy {
        @Override
        public void setMarkdown(String markdown, RichText component) {
            MarkdownItStrategy.ensureMarkdownIt();
            component.getElement().executeJs("    const md = window.markdownit();\n    const input = $0;\n    this.markdown = input;// save for appending\n    const html = md.render(input);\n    this.innerHTML = html;\n", new Object[]{markdown});
        }

        @Override
        public void appendMarkdown(String markdownFragment, RichText component) {
            MarkdownItStrategy.ensureMarkdownIt();
            component.getElement().executeJs("    const md = window.markdownit();\n    const input = $0;\n    if(this.markdown) {\n        this.markdown = this.markdown + input;\n    } else {\n        this.markdown = input;\n    }\n    const html = md.render(this.markdown);\n    this.innerHTML = html;\n", new Object[]{markdownFragment});
        }

        public static void ensureMarkdownIt() {
            UI ui = UI.getCurrent();
            if (ui == null) {
                throw new IllegalStateException("UI is not available");
            }
            String jsloadedflag = MarkdownItStrategy.class.getName() + "_jsloaded";
            Object flag = ComponentUtil.getData((Component)ui, (String)jsloadedflag);
            if (flag == null) {
                ui.getPage().addJavaScript("https://cdn.jsdelivr.net/npm/markdown-it@14.1.0/dist/markdown-it.min.js", LoadMode.EAGER);
                ComponentUtil.setData((Component)ui, (String)jsloadedflag, (Object)true);
                ui.addDetachListener((ComponentEventListener & Serializable)e -> {
                    ComponentUtil.setData((Component)ui, (String)jsloadedflag, null);
                    e.unregisterListener();
                });
            }
        }
    }
}

