/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.util;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class WindowScroller {
    private final UI ui;
    private List<ScrollListener> scrollListener = new LinkedList<ScrollListener>();
    private List<ScrollListener> scrollToEndListener = new LinkedList<ScrollListener>();

    public WindowScroller(UI ui) {
        this.ui = ui;
    }

    public void setScrollTop(int pixels) {
        this.ui.getElement().executeJs("window.scroll(window.scrollX, $0)", new Object[]{pixels});
    }

    public void setScrollLeft(int pixels) {
        this.ui.getElement().executeJs("window.scroll($0, window.scrollX)", new Object[]{pixels});
    }

    private void sinkScrollEvents() {
        this.ui.getElement().executeJs("var s = this;\nwindow.addEventListener(\"scroll\", function() {\n var atScrollEnd = (window.innerHeight + window.scrollY) >= document.body.scrollHeight;\n const event = new CustomEvent('windowscroll', { detail : atScrollEnd +','+ window.scrollX+','+window.scrollY});\n s.dispatchEvent(event);\n}\n);\n", new Object[0]);
        DomListenerRegistration domlistener = this.ui.getElement().addEventListener("windowscroll", (DomEventListener & Serializable)e -> {
            String[] split = e.getEventData().get("event.detail").asText().split(",");
            boolean isEnd = Boolean.parseBoolean(split[0]);
            int x = Integer.parseInt(split[1]);
            int y = Integer.parseInt(split[2]);
            if (isEnd) {
                this.scrollToEndListener.forEach(l -> l.onScroll(y, x));
            }
            this.scrollListener.forEach(l -> l.onScroll(y, x));
        });
        domlistener.debounce(100);
        domlistener.addEventData("event.detail");
    }

    public void addScrollListener(ScrollListener listener) {
        if (this.scrollListener.isEmpty() && this.scrollToEndListener.isEmpty()) {
            this.sinkScrollEvents();
        }
        this.scrollListener.add(listener);
    }

    public void addScrollToEndListener(ScrollListener listener) {
        if (this.scrollListener == null && this.scrollToEndListener == null) {
            this.sinkScrollEvents();
        }
        this.scrollToEndListener.add(listener);
    }

    public static interface ScrollListener {
        public void onScroll(int var1, int var2);
    }
}

