/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.devicemotion;

public class ScreenOrientationInfo {
    private String type;
    private Integer angle;

    public String getType() {
        return this.type;
    }

    public OrientationType getOrientationType() {
        return OrientationType.fromString(this.type);
    }

    public Integer getAngle() {
        return this.angle;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setAngle(Integer angle) {
        this.angle = angle;
    }

    public String toString() {
        return "ScreenOrientationInfo{type='" + this.type + "', angle=" + this.angle + "}";
    }

    public static enum OrientationType {
        PORTRAIT_PRIMARY("portrait-primary"),
        PORTRAIT_SECONDARY("portrait-secondary"),
        LANDSCAPE_PRIMARY("landscape-primary"),
        LANDSCAPE_SECONDARY("landscape-secondary");

        private final String value;

        private OrientationType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static OrientationType fromString(String value) {
            for (OrientationType type : OrientationType.values()) {
                if (!type.value.equals(value)) continue;
                return type;
            }
            return PORTRAIT_PRIMARY;
        }

        public boolean isPortrait() {
            return this == PORTRAIT_PRIMARY || this == PORTRAIT_SECONDARY;
        }

        public boolean isLandscape() {
            return this == LANDSCAPE_PRIMARY || this == LANDSCAPE_SECONDARY;
        }
    }
}

