package fr.reseaumexico.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Collection;

public abstract class Factor implements Serializable {

    private static final long serialVersionUID = 4122874366238209332L;

    public static final String PROPERTY_ID = "id";

    public static final String PROPERTY_NAME = "name";

    public static final String PROPERTY_UNIT = "unit";

    public static final String PROPERTY_DESCRIPTION = "description";

    public static final String PROPERTY_DOMAIN = "domain";

    public static final String PROPERTY_FEATURE = "feature";

    protected String id;

    protected String name;

    protected String unit;

    protected String description;

    protected Domain domain;

    protected Collection<Feature> feature;

    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        String oldValue = getId();
        this.id = id;
        firePropertyChange(PROPERTY_ID, oldValue, id);
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        String oldValue = getName();
        this.name = name;
        firePropertyChange(PROPERTY_NAME, oldValue, name);
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        String oldValue = getUnit();
        this.unit = unit;
        firePropertyChange(PROPERTY_UNIT, oldValue, unit);
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        String oldValue = getDescription();
        this.description = description;
        firePropertyChange(PROPERTY_DESCRIPTION, oldValue, description);
    }

    public Domain getDomain() {
        return domain;
    }

    public void setDomain(Domain domain) {
        Domain oldValue = getDomain();
        this.domain = domain;
        firePropertyChange(PROPERTY_DOMAIN, oldValue, domain);
    }

    public Feature getFeature(int index) {
        Feature o = getChild(feature, index);
        return o;
    }

    public void addFeature(Feature feature) {
        getFeature().add(feature);
    
        firePropertyChange(PROPERTY_FEATURE, null, feature);
    }

    public void addAllFeature(Collection<Feature> feature) {
        getFeature().addAll(feature);
    
        firePropertyChange(PROPERTY_FEATURE, null, feature);
    }

    public boolean removeFeature(Feature feature) {
        boolean  removed = getFeature().remove(feature);
    
        if (removed) {
            firePropertyChange(PROPERTY_FEATURE, feature, null);
      }
    
        return removed;
    }

    public boolean removeAllFeature(Collection<Feature> feature) {
        boolean  removed = getFeature().removeAll(feature);
    
        if (removed) {
            firePropertyChange(PROPERTY_FEATURE, feature, null);
      }
    
        return removed;
    }

    public boolean containsFeature(Feature feature) {
        boolean contains = getFeature().contains(feature);
    
        return contains;
    }

    public boolean containsAllFeature(Collection<Feature> feature) {
        boolean  contains = getFeature().containsAll(feature);
    
        return contains;
    }

    public Collection<Feature> getFeature() {
        return feature;
    }

    public void setFeature(Collection<Feature> feature) {
        Collection<Feature> oldValue = getFeature();
        this.feature = feature;
        firePropertyChange(PROPERTY_FEATURE, oldValue, feature);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, Object newValue) {
        firePropertyChange(propertyName, null, newValue);
    }

    protected <T> T getChild(Collection<T> childs, int index) {
        if (childs != null) {
            int i = 0;
            for (T o : childs) {
                if (index == i) {
                    return o;
                }
                i++;
            }
        }
        return null;
    }

} //Factor
