package fr.reseaumexico.editor;

/*
 * #%L
 * JMexico :: Swing Editor
 * $Id: AbstractScenarioModel.java 88 2012-10-07 16:24:50Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/jmexico/tags/jmexico-0.9/jmexico-editor/src/main/java/fr/reseaumexico/editor/AbstractScenarioModel.java $
 * %%
 * Copyright (C) 2011 - 2012 Réseau Mexico, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import fr.reseaumexico.model.Scenario;
import org.jdesktop.beans.AbstractSerializableBean;

import java.io.File;
import java.util.Collection;

/**
 * Model toimport a scenarion into a input design.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.7
 */
public class AbstractScenarioModel<M extends AbstractScenarioModel> extends AbstractSerializableBean {

    private static final long serialVersionUID = 1L;

    protected Collection<Scenario> scenarios;

    protected Scenario selectedScenario;

    public Collection<Scenario> getScenarios() {
        return scenarios;
    }

    public Scenario getSelectedScenario() {
        return selectedScenario;
    }

    public void setSelectedScenario(Scenario selectedScenario) {
        Object oldValue = this.selectedScenario;
        this.selectedScenario = selectedScenario;
        firePropertyChange("selectedScenario", oldValue, selectedScenario);
    }


    public void setScenarios(Collection<Scenario> scenarios) {
        this.scenarios = scenarios;
        firePropertyChange("scenarios", null, scenarios);
    }

    public void copyTo(M model) {
        model.setScenarios(getScenarios());
        model.setSelectedScenario(getSelectedScenario());
    }
}