package fr.reseaumexico.editor;

/*
 * #%L
 * JMexico :: Swing Editor
 * %%
 * Copyright (C) 2011 - 2014 Réseau Mexico, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class CloneScenarioPanel extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_SCENARIO_NAME_EDITOR_TEXT = "scenarioNameEditor.text";
    public static final String BINDING_SELECTED_SCENARIO_EDITOR_SELECTED_ITEM = "selectedScenarioEditor.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1Uu24TQRS9NrGDk/CIo1iJCCIQIUgz/gAjCAQsEjmAMEWEG8bewZ5ovDPMzJKNEIhP4BOgp0Gio0IU1BQ0iF9AiIIWcWe960eySexiZM3cc+7rnH3/C3JGw8UdGoZEB77lXUY2b25v32/usJa9zUxLc2Wlht4vk4VsA6a9/r2xsNKoOXg5hpfXZVdJn/lD6EoNpozdE8x0GLMWzo8iWsaU6/3nSqgCnbD2i0pjffvnd/aN9/pdFiBUWF0eW1k+DjXoZKIGWe5ZKGKm57QsqN/GMjT321jvKXe3Lqgx92iXPYNXMFmDvKIaySxcGr/liCPCh8pCTlGfCQurTzXRzDAadFnIW5IwjyOKrAvkqbeYTzWXD1ysUhE6j9iu9MbGbrnYAXbeMIELZV7yXqNNx1V0bYbE7GLXZDO6dIhCH1jaD7wTJUPGESROoClvyXAUPGtikJthn3x2NKg4HJSwl0bYH7HQVjkTXozUcG5kzSggMhDQYMOZBuR0gNcWFhoHNfcQn3pqW9inNkcYvf4rzX3/9PNjNZGYc8t8auiQQ3D1SkvFtOUu9ZmevgLLRXmLqkoDCr2hRvZZSimsHj9jcZhv1sGJg5O71HSQIjf54/OX0pNvJyBbhSkhqVelLn4DCraD0uhI4YXqxlpU0czuSTzPutosTFgcpUXDx9IRbikk2QBpOQkRHxcR4lSWUqbSL61Z+Pp3rv5hLZlMBitdPDR8MJ3cY8hzX3CfRfaLnZVqt2llWODJgYPSPAVpMlOx8i9E58oRk1h8EbmKtJmtD7FcXX0ZBg57JWrN/VuFVK2On+rykUNPfJaWNt29Y2SeSYAblnXxuzvU7D7GQxo+xP5jpM4LuicDbPv0NY9autzkvodmvn4gS8adU8j4HxJqCXiNBgAA";
    private static final Log log = LogFactory.getLog(CloneScenarioPanel.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected CloneScenarioModel model;
    protected CloneScenarioPanel panel = this;
    protected JTextField scenarioNameEditor;
    protected JLabel scenarioNameLabel;
    protected JComboBox selectedScenarioEditor;
    protected JLabel selectedScenarioLabel;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init(CloneScenarioModel model) {
        model.copyTo(this.model);
    
        // init selected scenario
        SwingUtil.fillComboBox(selectedScenarioEditor,
                               model.getScenarios(),
                               model.getSelectedScenario());
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CloneScenarioPanel() {
        $initialize();
    }

    public CloneScenarioPanel(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doItemStateChanged__on__selectedScenarioEditor(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        InputDesignEditorHandler.onSelectedScenarioChanged(model, event);
    }

    public void doKeyReleased__on__scenarioNameEditor(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setScenarioName(((JTextField)event.getSource()).getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public CloneScenarioModel getModel() {
        return model;
    }

    public JTextField getScenarioNameEditor() {
        return scenarioNameEditor;
    }

    public JLabel getScenarioNameLabel() {
        return scenarioNameLabel;
    }

    public JComboBox getSelectedScenarioEditor() {
        return selectedScenarioEditor;
    }

    public JLabel getSelectedScenarioLabel() {
        return selectedScenarioLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(selectedScenarioLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(selectedScenarioEditor, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(scenarioNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(scenarioNameEditor, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createModel() {
        $objectMap.put("model", model = new CloneScenarioModel());
    }

    protected void createScenarioNameEditor() {
        $objectMap.put("scenarioNameEditor", scenarioNameEditor = new JTextField());
        
        scenarioNameEditor.setName("scenarioNameEditor");
        scenarioNameEditor.setColumns(15);
        scenarioNameEditor.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__scenarioNameEditor"));
    }

    protected void createScenarioNameLabel() {
        $objectMap.put("scenarioNameLabel", scenarioNameLabel = new JLabel());
        
        scenarioNameLabel.setName("scenarioNameLabel");
        scenarioNameLabel.setText(_("jmexico.label.scenario.clone.name"));
    }

    protected void createSelectedScenarioEditor() {
        $objectMap.put("selectedScenarioEditor", selectedScenarioEditor = new JComboBox());
        
        selectedScenarioEditor.setName("selectedScenarioEditor");
        selectedScenarioEditor.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__selectedScenarioEditor"));
    }

    protected void createSelectedScenarioLabel() {
        $objectMap.put("selectedScenarioLabel", selectedScenarioLabel = new JLabel());
        
        selectedScenarioLabel.setName("selectedScenarioLabel");
        selectedScenarioLabel.setText(_("jmexico.label.scenario.clone.selected"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToPanel();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("panel", panel);
        createModel();
        createSelectedScenarioLabel();
        createSelectedScenarioEditor();
        createScenarioNameLabel();
        createScenarioNameEditor();
        // inline creation of panel
        setName("panel");
        setLayout(new BorderLayout());
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTED_SCENARIO_EDITOR_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedScenario", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    selectedScenarioEditor.setSelectedItem(model.getSelectedScenario());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedScenario", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SCENARIO_NAME_EDITOR_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("scenarioName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(scenarioNameEditor, model.getScenarioName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("scenarioName", this);
                }
            }
        });
    }

}