package fr.reseaumexico.editor;

/*
 * #%L
 * JMexico :: Swing Editor
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2011 - 2013 Réseau Mexico, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.FileEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class ExportScenarioPanel extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EXPORT_DIRECTORY_EDITOR_SELECTED_FILE = "exportDirectoryEditor.selectedFile";
    public static final String BINDING_EXPORT_FILENAME_EDITOR_TEXT = "exportFilenameEditor.text";
    public static final String BINDING_SELECTED_SCENARIO_EDITOR_SELECTED_ITEM = "selectedScenarioEditor.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJVVz08TQRSeVlpowR/8qhgwQTQIxGy9YxQFGkrqj1gPxMbotDu0Q7Yz4+ysLCEY/wT/BL17MfHmyXjw7MGL8V8wxoNX45vd7pYtu1B72LQz73vf+96+7/XdT5SxJbq0g13XkA5TtE2MzdtbW/frO6Sh1ojdkFQoLpH/SaVRuoaGzfDcVuhyraLhxQ68uMrbgjPCDqGXKyhvqz2L2C1ClEIXo4iGbRer4fWyKxwZZA2Lisv65vev9Gvz1ds0Qq6A6nIgZfYkVFfJQAWlqanQGDC9wEULsyaUISlrQr2n9dmqhW37Hm6T5+glGqygrMASkik0179kL4eHd4VCGYEZsRRa2paGJDbBTpu4tMENYlJAGeuu4FJVG4RhSfkDHSyEB88CuM3N/sF3dXAXPGkTC14pMYP7Cq7rZGNaqGvYu6Db2PQONSIXAgu9wHWPDTJGkNCDOr/D3Sh4gng1rVEJKbjcC/OPRuMme+ICjiuR1+lTddSWqEX8sGiqcT+Vvmbw6pIYJ6JhAWEhIuoRcSGCWGYUez6Gosy2+WEaiaYjtcOQG90h705hqoYy0oFjhaZqR33xEK58R0z1OEIn9G7/Fsa/ffzxoRTYYAi4J2NDD7kYxlNILohUVFOf9T3gKGoV72KxXAMzea/ds/hMTGHVzjUUB3yjGm5ouLGB7RakyAx+//S58OzrKZQuobzFsVnCOr6McqoF09vilumKWyteRSO7Q/A8p2tTaEBB1xWa3+lMt6Xba9id6TP83hvbnea70JqZmNaE9dVzX/6MV9+vBO1JQbkXEsO7Lco8RlnKLMqItyc6KyB2LwwLmzgm71o9zvwofjRFx6Lz3nPpmIZM73v+N5pErUfyLCweuI5GG548/e06Spjw/umuHt9/M7DqMdRR2/dBPRLsGl00zF2v4jBhguT4NdK/5hNmLqguljp2v/6P5rIibfhv7Gqu9mRMEJ2woE+iToeqn+w/XZgLlFPYY4lmm7s2W2bC0f9ztMl8ng3MTItIr+CgAFcRZlPOFhYXDxTKg/HhR7nBGXC2oCtxMpKWah8tzFp4jzug5MwNEys8W6fMhP198whNSj/zkPEfO/8sI/kIAAA=";
    private static final Log log = LogFactory.getLog(ExportScenarioPanel.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected FileEditor exportDirectoryEditor;
    protected JLabel exportDirectoryLabel;
    protected JTextField exportFilenameEditor;
    protected JLabel exportFilenameLabel;
    protected JLabel exportFilenameLabelInfo;
    protected ExportScenarioModel model;
    protected ExportScenarioPanel panel = this;
    protected JComboBox selectedScenarioEditor;
    protected JLabel selectedScenarioLabel;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init(ExportScenarioModel model) {
        model.copyTo(this.model);
    
        // init selected scenario
        SwingUtil.fillComboBox(selectedScenarioEditor,
                               model.getScenarios(),
                               model.getSelectedScenario());
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ExportScenarioPanel() {
        $initialize();
    }

    public ExportScenarioPanel(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__exportDirectoryEditor(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setExportDirectory(((FileEditor) event.getSource()).getSelectedFile());
    }

    public void doItemStateChanged__on__selectedScenarioEditor(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        InputDesignEditorHandler.onSelectedScenarioChanged(model, event);
    }

    public void doKeyReleased__on__exportFilenameEditor(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setExportFilename(((JTextField)event.getSource()).getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public FileEditor getExportDirectoryEditor() {
        return exportDirectoryEditor;
    }

    public JLabel getExportDirectoryLabel() {
        return exportDirectoryLabel;
    }

    public JTextField getExportFilenameEditor() {
        return exportFilenameEditor;
    }

    public JLabel getExportFilenameLabel() {
        return exportFilenameLabel;
    }

    public JLabel getExportFilenameLabelInfo() {
        return exportFilenameLabelInfo;
    }

    public ExportScenarioModel getModel() {
        return model;
    }

    public JComboBox getSelectedScenarioEditor() {
        return selectedScenarioEditor;
    }

    public JLabel getSelectedScenarioLabel() {
        return selectedScenarioLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(selectedScenarioLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(selectedScenarioEditor, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(exportDirectoryLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(exportDirectoryEditor, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(exportFilenameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(exportFilenameEditor, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(exportFilenameLabelInfo, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createExportDirectoryEditor() {
        $objectMap.put("exportDirectoryEditor", exportDirectoryEditor = new FileEditor());
        
        exportDirectoryEditor.setName("exportDirectoryEditor");
        exportDirectoryEditor.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__exportDirectoryEditor"));
    }

    protected void createExportDirectoryLabel() {
        $objectMap.put("exportDirectoryLabel", exportDirectoryLabel = new JLabel());
        
        exportDirectoryLabel.setName("exportDirectoryLabel");
        exportDirectoryLabel.setText(_("jmexico.label.scenario.export.directory"));
    }

    protected void createExportFilenameEditor() {
        $objectMap.put("exportFilenameEditor", exportFilenameEditor = new JTextField());
        
        exportFilenameEditor.setName("exportFilenameEditor");
        exportFilenameEditor.setColumns(15);
        exportFilenameEditor.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__exportFilenameEditor"));
    }

    protected void createExportFilenameLabel() {
        $objectMap.put("exportFilenameLabel", exportFilenameLabel = new JLabel());
        
        exportFilenameLabel.setName("exportFilenameLabel");
        exportFilenameLabel.setText(_("jmexico.label.scenario.export.filename"));
    }

    protected void createExportFilenameLabelInfo() {
        $objectMap.put("exportFilenameLabelInfo", exportFilenameLabelInfo = new JLabel());
        
        exportFilenameLabelInfo.setName("exportFilenameLabelInfo");
    }

    protected void createModel() {
        $objectMap.put("model", model = new ExportScenarioModel());
    }

    protected void createSelectedScenarioEditor() {
        $objectMap.put("selectedScenarioEditor", selectedScenarioEditor = new JComboBox());
        
        selectedScenarioEditor.setName("selectedScenarioEditor");
        selectedScenarioEditor.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__selectedScenarioEditor"));
    }

    protected void createSelectedScenarioLabel() {
        $objectMap.put("selectedScenarioLabel", selectedScenarioLabel = new JLabel());
        
        selectedScenarioLabel.setName("selectedScenarioLabel");
        selectedScenarioLabel.setText(_("jmexico.label.scenario.export.selected"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToPanel();
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        exportFilenameLabelInfo.setText(_("jmexico.info.scenario.export.filename", InputDesignEditorHandler.getScenarioExtension()));
        exportFilenameLabelInfo.setIcon(SwingUtil.createActionIcon("help"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("panel", panel);
        createModel();
        createSelectedScenarioLabel();
        createSelectedScenarioEditor();
        createExportDirectoryLabel();
        createExportDirectoryEditor();
        createExportFilenameLabel();
        createExportFilenameEditor();
        createExportFilenameLabelInfo();
        // inline creation of panel
        setName("panel");
        setLayout(new BorderLayout());
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTED_SCENARIO_EDITOR_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedScenario", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    selectedScenarioEditor.setSelectedItem(model.getSelectedScenario());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedScenario", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EXPORT_DIRECTORY_EDITOR_SELECTED_FILE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("exportDirectory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    exportDirectoryEditor.setSelectedFile(model.getExportDirectory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("exportDirectory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EXPORT_FILENAME_EDITOR_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("exportFilename", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(exportFilenameEditor, model.getExportFilename());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("exportFilename", this);
                }
            }
        });
    }

}