/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.template.formatter;

import fr.opensagres.xdocreport.template.formatter.FieldMetadata;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.formatter.sax.FieldsMetadataContentHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class FieldsMetadataXMLSerializer {
    private static final String LF = System.getProperty("line.separator");
    private static final String TAB = "\t";
    private static final FieldsMetadataXMLSerializer INSTANCE = new FieldsMetadataXMLSerializer();

    public static FieldsMetadataXMLSerializer getInstance() {
        return INSTANCE;
    }

    protected FieldsMetadataXMLSerializer() {
    }

    public FieldsMetadata load(Reader input) throws SAXException, IOException {
        XMLReader saxReader = XMLReaderFactory.createXMLReader();
        FieldsMetadataContentHandler myContentHandler = new FieldsMetadataContentHandler();
        saxReader.setContentHandler(myContentHandler);
        saxReader.parse(new InputSource(input));
        return myContentHandler.getFieldsMetadata();
    }

    public FieldsMetadata load(InputStream inputStream) throws SAXException, IOException {
        XMLReader saxReader = XMLReaderFactory.createXMLReader();
        FieldsMetadataContentHandler myContentHandler = new FieldsMetadataContentHandler();
        saxReader.setContentHandler(myContentHandler);
        saxReader.parse(new InputSource(inputStream));
        return myContentHandler.getFieldsMetadata();
    }

    public void save(FieldsMetadata fieldsMetadata, Writer writer) throws IOException {
        this.save(fieldsMetadata, writer, null, false, false);
    }

    public void save(FieldsMetadata fieldsMetadata, Writer writer, boolean indent) throws IOException {
        this.save(fieldsMetadata, writer, null, indent, false);
    }

    public void save(FieldsMetadata fieldsMetadata, Writer writer, boolean indent, boolean formatAsJavaString) throws IOException {
        this.save(fieldsMetadata, writer, null, indent, formatAsJavaString);
    }

    public void save(FieldsMetadata fieldsMetadata, OutputStream out, boolean indent, boolean formatAsJavaString) throws IOException {
        this.save(fieldsMetadata, null, out, indent, formatAsJavaString);
    }

    private void save(FieldsMetadata fieldsMetadata, Writer writer, OutputStream out, boolean indent, boolean formatAsJavaString) throws IOException {
        List<FieldMetadata> fields = fieldsMetadata.getFields();
        if (formatAsJavaString) {
            this.write("\"", writer, out);
            this.write("<?xml version=\\\"1.0\\\" encoding=\\\"UTF-8\\\" standalone=\\\"yes\\\"?>", writer, out);
        } else {
            this.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>", writer, out);
        }
        if (indent) {
            this.write(LF, writer, out);
        }
        this.write("<fields", writer, out);
        this.writeAttr("templateEngineKind", fieldsMetadata.getTemplateEngineKind(), formatAsJavaString, writer, out);
        this.write(" >", writer, out);
        if (indent) {
            this.write(LF, writer, out);
            this.write(TAB, writer, out);
        }
        this.write("<description>", writer, out);
        this.write("<![CDATA[", writer, out);
        if (fieldsMetadata.getDescription() != null) {
            this.write(fieldsMetadata.getDescription(), writer, out);
        }
        this.write("]]>", writer, out);
        this.write("</description>", writer, out);
        for (FieldMetadata field : fields) {
            this.save(field, writer, out, indent, formatAsJavaString);
        }
        if (indent) {
            this.write(LF, writer, out);
        }
        this.write("</fields>", writer, out);
        if (formatAsJavaString) {
            this.write("\"", writer, out);
        }
    }

    private void save(FieldMetadata field, Writer writer, OutputStream out, boolean indent, boolean formatAsJavaString) throws IOException {
        if (indent) {
            this.write(LF, writer, out);
            this.write(TAB, writer, out);
        }
        this.write("<field", writer, out);
        this.writeAttr("name", field.getFieldName(), formatAsJavaString, writer, out);
        this.writeAttr("list", field.isListType(), formatAsJavaString, writer, out);
        this.writeAttr("imageName", field.getImageName(), formatAsJavaString, writer, out);
        this.writeAttr("syntaxKind", field.getSyntaxKind(), formatAsJavaString, writer, out);
        this.write(">", writer, out);
        if (indent) {
            this.write(LF, writer, out);
            this.write(TAB, writer, out);
            this.write(TAB, writer, out);
        }
        this.write("<description>", writer, out);
        this.write("<![CDATA[", writer, out);
        if (field.getDescription() != null) {
            this.write(field.getDescription(), writer, out);
        }
        this.write("]]>", writer, out);
        this.write("</description>", writer, out);
        if (indent) {
            this.write(LF, writer, out);
            this.write(TAB, writer, out);
        }
        this.write("</field>", writer, out);
    }

    private void write(String s, Writer writer, OutputStream out) throws IOException {
        if (writer == null) {
            out.write(s.getBytes());
        } else {
            writer.write(s);
        }
    }

    private void writeAttr(String attrName, String attrValue, boolean formatAsJavaString, Writer writer, OutputStream out) throws IOException {
        this.write(" ", writer, out);
        this.write(attrName, writer, out);
        if (formatAsJavaString) {
            this.write("=\\\"", writer, out);
        } else {
            this.write("=\"", writer, out);
        }
        this.write(attrValue != null ? attrValue : "", writer, out);
        if (formatAsJavaString) {
            this.write("\\\"", writer, out);
        } else {
            this.write("\"", writer, out);
        }
    }

    private void writeAttr(String attrName, boolean attrValue, boolean formatAsJavaString, Writer writer, OutputStream out) throws IOException {
        this.writeAttr(attrName, attrValue ? "true" : "false", formatAsJavaString, writer, out);
    }
}

