/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions.io.input;

import com.google.common.collect.Sets;
import fr.ird.t3.actions.T3Action;
import fr.ird.t3.actions.T3ActionConfiguration;
import fr.ird.t3.actions.T3ActionContext;
import fr.ird.t3.actions.io.input.ImportInputSourceAction;
import fr.ird.t3.actions.io.input.ImportInputSourceConfiguration;
import fr.ird.t3.actions.io.input.InputSourceConfiguration;
import fr.ird.t3.entities.data.Trip;
import fr.ird.t3.io.input.T3InputProvider;
import fr.ird.t3.web.actions.AbstractRunAction;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.decorator.Decorator;

public class ImportDataAction
extends AbstractRunAction<ImportInputSourceConfiguration, ImportInputSourceAction> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ImportDataAction.class);
    protected boolean replaceTrip;
    protected boolean valid;
    private int nbImportedTrips;
    private int nbDeletedTrips;
    private List<T3InputProvider> inputProviders;

    public ImportDataAction() {
        super(ImportInputSourceAction.class);
    }

    public void prepare() throws Exception {
        super.prepare();
        this.inputProviders = Arrays.asList(this.getIncomingConfiguration().getInputProvider());
    }

    public final List<T3InputProvider> getInputProviders() {
        return this.inputProviders;
    }

    public InputSourceConfiguration getIncomingConfiguration() {
        T3ActionConfiguration configuration = this.getT3ActionContext().getConfiguration();
        return (InputSourceConfiguration)configuration;
    }

    public String prepareImport() throws Exception {
        T3ActionContext actionContext = this.getT3ActionContext();
        Set safeTrips = actionContext.getResultAsSet("safeTrips", Trip.class);
        Map tripToReplace = actionContext.getResultAsMap("tripsToReplace");
        if (log.isInfoEnabled()) {
            log.info((Object)"--> Prepare import");
            log.info((Object)("Input provider   : " + this.getIncomingConfiguration().getInputProvider()));
            log.info((Object)("Input file       : " + this.getIncomingConfiguration().getInputFile()));
            log.info((Object)("Use well         : " + this.getIncomingConfiguration().isUseWells()));
            log.info((Object)("Trips to import  : " + safeTrips.size()));
            log.info((Object)("Trips to replace : " + tripToReplace.size()));
        }
        HashSet toImportTrips = Sets.newHashSet();
        HashSet toDeleteTrips = Sets.newHashSet();
        if (this.isReplaceTrip()) {
            toDeleteTrips.addAll(tripToReplace.keySet());
            toImportTrips.addAll(safeTrips);
        } else {
            toImportTrips.addAll(safeTrips);
            if (MapUtils.isNotEmpty((Map)tripToReplace)) {
                toImportTrips.removeAll(tripToReplace.values());
            }
        }
        ImportInputSourceConfiguration configuration = ImportInputSourceConfiguration.newConfiguration((InputSourceConfiguration)this.getIncomingConfiguration());
        configuration.setTripsToImport((Set)toImportTrips);
        configuration.setTripsToDelete((Set)toDeleteTrips);
        this.t3ActionContext = T3ActionContext.newT3ActionContext((T3ActionConfiguration)configuration, (Locale)this.getLocale());
        if (log.isInfoEnabled()) {
            log.info((Object)("Created action context " + this.t3ActionContext));
        }
        this.getT3Session().setActionContext(this.t3ActionContext);
        return "success";
    }

    public String prepareResult() throws Exception {
        Set importedTrips = ((ImportInputSourceConfiguration)this.getConfiguration()).getTripsToImport();
        this.nbImportedTrips = importedTrips.size();
        Set deletedeTrips = ((ImportInputSourceConfiguration)this.getConfiguration()).getTripsToDelete();
        this.nbDeletedTrips = deletedeTrips.size();
        return "input";
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public int getNbImportedTrips() {
        return this.nbImportedTrips;
    }

    public int getNbDeletedTrips() {
        return this.nbDeletedTrips;
    }

    public boolean isReplaceTrip() {
        return this.replaceTrip;
    }

    public void setReplaceTrip(boolean replaceTrip) {
        this.replaceTrip = replaceTrip;
    }

    protected Map<String, Object> prepareResumeParameters(ImportInputSourceAction action, Exception error, Date startDate, Date endDate) {
        Map map = super.prepareResumeParameters((T3Action)action, error, startDate, endDate);
        Decorator decorator = this.getDecorator(Trip.class, "withId");
        map.put("tripDecorator", decorator);
        return map;
    }
}

