/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions.admin;

import com.google.common.collect.Maps;
import fr.ird.t3.actions.T3ActionConfiguration;
import fr.ird.t3.actions.T3ActionContext;
import fr.ird.t3.actions.admin.DeleteTripConfiguration;
import fr.ird.t3.entities.data.Trip;
import fr.ird.t3.entities.data.TripDAO;
import fr.ird.t3.entities.reference.Country;
import fr.ird.t3.entities.reference.Ocean;
import fr.ird.t3.entities.reference.Vessel;
import fr.ird.t3.services.ioc.InjectDAO;
import fr.ird.t3.services.ioc.InjectFromDAO;
import fr.ird.t3.web.actions.T3BaseTransactionAction;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.decorator.Decorator;

public class TripListAction
extends T3BaseTransactionAction {
    protected static final Log log = LogFactory.getLog(TripListAction.class);
    private static final long serialVersionUID = 1L;
    public static final String DO_DELETE = "doDelete";
    @InjectDAO(entityType=Trip.class)
    protected transient TripDAO tripDAO;
    @InjectFromDAO(entityType=Trip.class, method="findAllYearsUsedInTrip")
    protected List<Integer> allYears;
    @InjectFromDAO(entityType=Ocean.class, method="findAllUsedInActivity")
    protected List<Ocean> allOceans;
    @InjectFromDAO(entityType=Country.class, method="findAllFleetUsedInTrip")
    protected List<Country> allFleets;
    @InjectFromDAO(entityType=Country.class, method="findAllFlagUsedInTrip")
    protected List<Country> allFlags;
    @InjectFromDAO(entityType=Vessel.class, method="findAllUsedInTrip")
    protected List<Vessel> allVessels;
    @InjectFromDAO(entityType=Trip.class, method="count")
    protected long nbTrips;
    protected Map<String, String> years;
    protected Map<String, String> oceans;
    protected Map<String, String> fleets;
    protected Map<String, String> flags;
    protected Map<String, String> vessels;
    protected List<String> tripIds;
    protected Map<String, String> tripsToDelete;

    public Map<String, String> getYears() {
        return this.years;
    }

    public Map<String, String> getOceans() {
        return this.oceans;
    }

    public Map<String, String> getFleets() {
        return this.fleets;
    }

    public Map<String, String> getFlags() {
        return this.flags;
    }

    public Map<String, String> getVessels() {
        return this.vessels;
    }

    public long getNbTrips() {
        return this.nbTrips;
    }

    public Map<String, String> getTripsToDelete() {
        return this.tripsToDelete;
    }

    public void setTripIds(List<String> tripIds) {
        this.tripIds = tripIds;
    }

    public String input() throws Exception {
        this.injectOnly(new Class[]{InjectFromDAO.class});
        this.years = Maps.newLinkedHashMap();
        for (Integer year : this.allYears) {
            this.years.put(year + "", year + "");
        }
        this.oceans = this.sortAndDecorate((Collection)this.allOceans);
        this.fleets = this.sortAndDecorate((Collection)this.allFleets);
        this.flags = this.sortAndDecorate((Collection)this.allFlags);
        this.vessels = this.sortAndDecorate((Collection)this.allVessels);
        return "input";
    }

    public String confirmTripDelete() throws Exception {
        this.injectOnly(new Class[]{InjectDAO.class});
        this.tripsToDelete = Maps.newTreeMap();
        if (CollectionUtils.isNotEmpty((Collection)this.tripIds)) {
            Decorator decorator = this.getDecorator(Trip.class);
            for (String tripId : this.tripIds) {
                Trip aTrip = (Trip)this.tripDAO.findByTopiaId(tripId);
                String s = decorator.toString((Object)aTrip);
                this.tripsToDelete.put(tripId, s);
            }
        }
        return "input";
    }

    public String doDelete() throws Exception {
        return this.startDeleteData(true);
    }

    public String doDeleteComputedData() throws Exception {
        return this.startDeleteData(false);
    }

    protected String startDeleteData(boolean deleteTrips) {
        List ids = this.tripIds;
        DeleteTripConfiguration conf = new DeleteTripConfiguration();
        conf.setTripIds((Collection)ids);
        conf.setDeleteTrip(deleteTrips);
        T3ActionContext context = T3ActionContext.newT3ActionContext((T3ActionConfiguration)conf, (Locale)this.getLocale());
        this.getT3Session().setActionContext(context);
        return DO_DELETE;
    }
}

