/*
 * #%L
 * Refcomp :: entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class UnitDeptLinkAbstract extends BusinessEntityImpl implements UnitDeptLink {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionUnitDeptLink;
    /**
     * getUnit :
     * @return String 
     */

    @Override
    public String getUnit() {
        String value = UnitDeptLinkHelper.getUnit(getWikitty());
        return value;
}

    /**
     * setUnit :
     * @param unit 
     */

    @Override
    public void setUnit(String unit) {
        String oldValue = getUnit();
        UnitDeptLinkHelper.setUnit(getWikitty(), unit);
        getPropertyChangeSupport().firePropertyChange(UnitDeptLink.FIELD_UNITDEPTLINK_UNIT, oldValue, getUnit());
}

    /**
     * getDepartment :
     * @return String 
     */

    @Override
    public String getDepartment() {
        String value = UnitDeptLinkHelper.getDepartment(getWikitty());
        return value;
}

    /**
     * setDepartment :
     * @param department 
     */

    @Override
    public void setDepartment(String department) {
        String oldValue = getDepartment();
        UnitDeptLinkHelper.setDepartment(getWikitty(), department);
        getPropertyChangeSupport().firePropertyChange(UnitDeptLink.FIELD_UNITDEPTLINK_DEPARTMENT, oldValue, getDepartment());
}

    /**
     * UnitDeptLinkAbstract :
     */

    public UnitDeptLinkAbstract() {
        super();
}

    /**
     * UnitDeptLinkAbstract :
     * @param wikitty 
     */

    public UnitDeptLinkAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * UnitDeptLinkAbstract :
     * @param businessEntityImpl 
     */

    public UnitDeptLinkAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionUnitDeptLink =
                new WikittyExtension(EXT_UNITDEPTLINK,
                                     "1.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "Wikitty unit unique=\"true\"", 
                                             "Wikitty department unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionUnitDeptLink);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //UnitDeptLinkAbstract
