/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: PathPanel.java 132 2011-03-09 11:06:05Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.2/refcomp-client/src/main/java/fr/inra/refcomp/client/agent/PathPanel.java $
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.agent;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import org.nuiton.web.gwt.misc.BlindedPopup;

/**
 * User: couteau
 * Date: 22/01/11
 */
public class PathPanel extends Composite {
    @UiTemplate("PathPanel.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, PathPanel> {
    }

    private static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    @UiField
    Label path;

    @UiHandler("cancelButton")
    public void cancel(ClickEvent event) {
        ((BlindedPopup) this.getParent()).hide();
    }

    public PathPanel(String path) {
        initWidget(binder.createAndBindUi(this));

        this.path.setText(path);
    }
}
