/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: ApplicationListener.java 173 2011-05-27 08:32:56Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.0/refcomp-client/src/main/java/fr/inra/refcomp/server/ApplicationListener.java $
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.server;

import fr.inra.refcomp.services.RefcompConfiguration;
import fr.inra.refcomp.services.RefcompSession;
import fr.inra.refcomp.services.ServiceFactory;
import fr.inra.refcomp.services.StorageService;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * User: couteau
 * Date: 01/02/11
 */
public class ApplicationListener implements ServletContextListener {

    protected static final Log log =
            LogFactory.getLog(ApplicationListener.class);

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        if (log.isInfoEnabled()) {
            log.info("Application starting...");
        }

        // initialize configuration
        RefcompConfiguration.getInstance();

        // init database (and create minimal admin user if required)
        initDatabase();
    }

    protected void initDatabase() {
        createAdminUser();
    }

    protected void createAdminUser() {
        StorageService service = ServiceFactory.getService(new RefcompSession());
        service.adminCreationIfDoNotExist();
        service.createPrivateGroupIfDoNotExist();
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        if (log.isInfoEnabled()) {
            log.info("Refcomp is ending...");
        }
        //TODO jcouteau 01/02/2010 close database access here, how to do it in Wikitty ?

        if (log.isInfoEnabled()) {
            log.info("Refcomp ended");
        }
    }
}