/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: AdminDepartments.java 114 2011-02-16 17:17:55Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.0/refcomp-client/src/main/java/fr/inra/refcomp/client/admin/departments/AdminDepartments.java $
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.admin.departments;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import fr.inra.refcomp.client.admin.AdminUtil;
import fr.inra.refcomp.client.constants.Form;
import fr.inra.refcomp.client.constants.RefcompCallBack;
import fr.inra.refcomp.client.services.StorageService;
import fr.inra.refcomp.client.services.StorageServiceAsync;
import fr.inra.refcomp.entities.Department;
import java.util.List;

/**
 * User: couteau
 * Date: 2 déc. 2010
 */
public class AdminDepartments extends Composite {

    private static final StorageServiceAsync service = GWT
            .create(StorageService.class);

    @UiTemplate("AdminDepartments.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, AdminDepartments> {
    }

    private static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    @UiField
    Form form;

    @UiField
    static ListBox departmentList;

    @UiHandler("addButton")
    void doClickAdd(ClickEvent event) {

        service.createDepartment(new RefcompCallBack<Department>() {
            @Override
            public void onSuccess(Department result) {
                form.setContent(result, true);
            }
        });
    }

    public AdminDepartments() {
        initWidget(binder.createAndBindUi(this));

        History.newItem("adminDepartments");

        AdminUtil.checkAdmin();
        refresh();

        //Init the form panel
        DepartmentForm departmentForm = new DepartmentForm();
        form.setContentPanel(departmentForm);

        departmentList.addChangeHandler(new ChangeHandler() {
            @Override
            public void onChange(ChangeEvent event) {

                String beanId = departmentList.getValue(departmentList.getSelectedIndex());

                service.getDepartment(beanId, new RefcompCallBack<Department>() {
                    @Override
                    public void onSuccess(Department result) {
                        form.setContent(result, false);
                    }
                });

            }
        });
    }

    public static void refresh() {
        service.getDepartments(new RefcompCallBack<List<Department>>() {
            @Override
            public void onSuccess(List<Department> result) {
                departmentList.clear();
                for (Department department : result) {
                    String text = department.getName();
                    String fullName = department.getFullName();
                    if (fullName != null && !fullName.isEmpty()) {
                        text += " - " + fullName;
                    }
                    departmentList.addItem(text, department.getWikittyId());
                }
            }
        });
    }
}
