/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: SearchResults.java 79 2011-01-27 17:45:56Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-0.1/refcomp-client/src/main/java/fr/inra/refcomp/client/user/SearchResults.java $
 * %%
 * Copyright (C) 2010 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.user;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RootPanel;
import fr.inra.refcomp.client.agent.SkillsTableScreen;
import fr.inra.refcomp.client.constants.RefcompMessages;
import fr.inra.refcomp.client.table.DefaultTableModel;
import fr.inra.refcomp.client.table.FlexTableWithModel;
import fr.inra.refcomp.entities.Agent;
import fr.inra.refcomp.entities.AgentSkill;
import fr.inra.refcomp.entities.EntitiesList;
import fr.inra.refcomp.entities.Frequency;
import fr.inra.refcomp.entities.Skill;
import java.util.List;
import org.nuiton.wikitty.entities.BusinessEntity;

/**
 * User: couteau
 * Date: 3 nov. 2010
 */
public class SearchResults extends Composite {

    public static final int NAME_COL = 0;
    public static int TECH_SKILL_COL = 1;
    //public static int DOMAIN_SKILL_COL = 2;
    public static int FREQUENCY_COL = 2;
    public static int COMMENT_COL = 3;

    @UiTemplate("SearchResults.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, SearchResults> {
    }

    private static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    private RefcompMessages messages = GWT.create(RefcompMessages.class);

    @UiField
    FlexTableWithModel resultsTable;

    @UiField
    InlineLabel searchField;

    @UiField
    Label noResult;

    protected DefaultTableModel model;

    public SearchResults() {
        initWidget(binder.createAndBindUi(this));

        resultsTable.setModel(model);
    }

    public SearchResults(String searchField, EntitiesList results) {
        initWidget(binder.createAndBindUi(this));

        Object[][] data = new Object[][]{};

        String[] columns = {
                messages.agentName(),
                messages.skill(),
                //messages.linkedSkill(),
                messages.frequency(),
                messages.comment()};

        model = new DefaultTableModel(data, columns);

        resultsTable.setModel(model);


        this.searchField.setText(searchField);

        List<BusinessEntity> skills = results.getEntities();

        if (skills.size() > 0) {
            for (int i = 0; i < columns.length; i++) {
                resultsTable.setText(0, i, columns[i]);
            }

            for (BusinessEntity entity:skills){
                AgentSkill skill = (AgentSkill)entity;
                addRow(skill,results);
            }
        } else {
            resultsTable.setVisible(false);
            noResult.setVisible(true);
        }

    }

    protected void addRow(final AgentSkill skill, EntitiesList dependencies) {
        final int row = model.getRowCount();

        // If the skill returned does not have an agent, it means it is an old
        // damaged data. Do not display it.
        if (skill.getAgent() == null) {
            return;
        }

        //Name
        Agent agent = (Agent) dependencies.getDependency(skill.getAgent());

        if (agent != null) {
            Anchor nameLink = new Anchor(agent.getFirstName() + " " +
                    agent.getLastName());
            nameLink.addClickHandler(new ClickHandler() {
                @Override
                public void onClick(ClickEvent event) {
                    RootPanel content = RootPanel.get("content");
                    content.clear();
                    content.add(new SkillsTableScreen(skill.getWikittyId()));
                }
            });
            model.setValueAt(nameLink, row, NAME_COL);
        }

        //Tech skill
        Skill techSkill = (Skill) dependencies.getDependency(skill.getTechnicalSkill());
        if (techSkill != null) {
            model.setValueAt(techSkill.getName(), row, TECH_SKILL_COL);
        }

        //Domain skill
        /*Skill domainSkill = (Skill) dependencies.getDependency(skill.getDomainSkill());
        if (domainSkill != null) {
            model.setValueAt(domainSkill.getName(), row, DOMAIN_SKILL_COL);
        }*/

        //Frequency
        Frequency frequency = (Frequency) dependencies.getDependency(skill.getFrequency());
        if (frequency != null){
            model.setValueAt(frequency.getName(), row, FREQUENCY_COL);
        }

        //comment
        model.setValueAt(skill.getComment(), row, COMMENT_COL);

    }

}
