/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: FlexTableWithModel.java 79 2011-01-27 17:45:56Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-0.1/refcomp-client/src/main/java/fr/inra/refcomp/client/table/FlexTableWithModel.java $
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.table;

import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Widget;

/**
 * User: couteau
 * Date: 05/01/11
 */
public class FlexTableWithModel extends FlexTable
        implements TableModelListener {

    GWTTableModel model;

    public FlexTableWithModel() {
        super();
    }

    public FlexTableWithModel(GWTTableModel model) {
        super();
        setModel(model);
    }

    public void setModel(GWTTableModel model) {

        removeAllRows();

        if (this.model != null){
            this.model.removeTableModelListener(this);
        }
        this.model = model;
        this.model.addTableModelListener(this);
    }

    public GWTTableModel getModel(){
        return model;
    }

    @Override
    public void tableChanged(TableModelEvent event) {

        int firstColumn = event.getColumn();
        int lastColumn = event.getColumn();

        if (firstColumn == TableModelEvent.ALL_COLUMNS) {
            firstColumn = 0;
            lastColumn = getColumnCount() - 1;
        }

        int firstRow = event.getFirstRow();
        int lastRow = event.getLastRow();

        if (firstColumn == lastColumn) {
            if (firstRow == lastRow) {
                Object value = model.getValueAt(firstColumn, firstRow);
                setValueAt(value, firstRow, firstColumn);
            } else {
                for (int j = firstRow; j <= lastRow; j++) {
                    Object value = model.getValueAt(firstColumn, j);
                    setValueAt(value, j, firstColumn);
                }
            }
        } else {
            for (int i=firstColumn; i<lastColumn; i++) {

                if (firstRow == lastRow) {
                    Object value = model.getValueAt(i, firstRow);
                    setValueAt(value,firstRow,i);
                } else {
                    for (int j=firstRow; j<=lastRow; j++) {
                        Object value = model.getValueAt(i, j);
                        setValueAt(value,j,i);
                    }
                }
            }
        }
    }

    protected void setValueAt(Object value, int row, int col) {
        if (value instanceof Widget) {
            setWidget(row+1, col, (Widget) value);
        } else if (value == null) {
            setText(row+1, col, "");
        } else {
            setText(row+1, col, value.toString());
        }
    }

    protected int getColumnCount() {
        return model.getColumnCount();
    }
}
