/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: FrequenciesForm.java 79 2011-01-27 17:45:56Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-0.1/refcomp-client/src/main/java/fr/inra/refcomp/client/admin/frequencies/FrequenciesForm.java $
 * %%
 * Copyright (C) 2010 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.admin.frequencies;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.TextBox;
import fr.inra.refcomp.client.constants.FormContent;
import fr.inra.refcomp.client.constants.Menu;
import fr.inra.refcomp.client.constants.RefcompCallBack;
import fr.inra.refcomp.client.constants.RefcompMessages;
import fr.inra.refcomp.client.services.StorageService;
import fr.inra.refcomp.client.services.StorageServiceAsync;
import fr.inra.refcomp.entities.Frequency;
import fr.inra.refcomp.services.AlreadyExistingException;
import fr.inra.refcomp.services.InvalidEntityException;
import fr.inra.refcomp.services.UsedException;
import org.nuiton.wikitty.entities.BusinessEntity;

/**
 * User: couteau
 * Date: 27 nov. 2010
 */
public class FrequenciesForm extends Composite implements FormContent {

    private final StorageServiceAsync service = GWT
            .create(StorageService.class);

    @UiTemplate("FrequenciesForm.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, FrequenciesForm> {
    }
    
    private static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    private RefcompMessages messages = GWT.create(RefcompMessages.class);

    @UiField
    TextBox nameBox;

    @UiField
    HTMLPanel errorPanel;

    @UiField
    Label errorLabel;

    Frequency bean;

    public FrequenciesForm() {
        initWidget(binder.createAndBindUi(this));
        nameBox.setEnabled(false);
    }

    @Override
    public void setContent(BusinessEntity bean) {
        if (bean instanceof Frequency) {
            this.bean = (Frequency)bean;
            nameBox.setText(this.bean.getName());
            nameBox.setEnabled(true);
            errorPanel.setVisible(false);
        }
    }

    @Override
    public void clearContent() {
        bean = null;
        nameBox.setText("");
        nameBox.setEnabled(false);
        errorPanel.setVisible(false);
    }

    @Override
    public BusinessEntity getContent() {
        if (bean != null){
            bean.setName(nameBox.getText());
        }
        return bean;
    }

    @Override
    public void saveContent(Boolean creation) {

        Boolean validate = Window.confirm(messages.sure());

        if (validate){

            service.saveFrequency((Frequency)getContent(),
                    new RefcompCallBack<Frequency>() {
                        @Override
                        public void onSuccess(Frequency result) {
                            setContent(result);
                            AdminFrequencies.refresh();
                        }

                        @Override
                        public void onFailure(Throwable caught) {
                            if (caught instanceof AlreadyExistingException) {
                                Window.alert(caught.getMessage());
                            } else if (caught instanceof InvalidEntityException) {
                                errorPanel.setVisible(true);
                                errorLabel.setText(caught.getMessage());
                            } else {
                                Menu.doClickLogout(null);
                            }
                        }
                    });
        }
    }

    @Override
    public void cancelContent(Boolean creation) {

        Boolean validate = Window.confirm(messages.sure());

        if (validate){
            clearContent();
        }

    }

    @Override
    public void deleteContent() {
        Boolean validate = Window.confirm(messages.sure());

        if (validate) {

            //Try deletion without forcing
            // Do not use RefcompCallBack to override the onFailure method
            // Ask to force if frequency still used
            service.deleteFrequency((Frequency) getContent(), false,
                    new AsyncCallback<Void>() {
                        @Override
                        public void onSuccess(Void result) {
                            clearContent();
                            AdminFrequencies.refresh();
                        }

                        @Override
                        public void onFailure(Throwable caught) {
                            if (caught instanceof UsedException){
                                //Frequency used, ask before forcing deletion
                                Boolean forceDeletion = Window.confirm(
                                        caught.getMessage() + "\n"
                                                + messages.sure());
                                if (forceDeletion) {
                                    //Delete frequency using force
                                    service.deleteFrequency((Frequency) getContent(), true,
                                            new RefcompCallBack<Void>() {
                                                @Override
                                                public void onSuccess(Void result) {
                                                    clearContent();
                                                    AdminFrequencies.refresh();
                                                }
                                            });
                                }

                            } else {
                                Window.alert("Server communication error");
                            }
                        }
                    });
        }
    }
}
