/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.bigfin;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.io.Files;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmId;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.Attachments;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequencys;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchs;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.bigfin.BigfinImportContext;
import fr.ifremer.tutti.service.bigfin.BigfinImportResult;
import fr.ifremer.tutti.service.bigfin.csv.BigfinDataRow;
import fr.ifremer.tutti.service.bigfin.csv.BigfinDataRowModel;
import fr.ifremer.tutti.service.bigfin.signs.Sex;
import fr.ifremer.tutti.service.bigfin.signs.Sign;
import fr.ifremer.tutti.service.bigfin.signs.Size;
import fr.ifremer.tutti.service.bigfin.signs.VracHorsVrac;
import fr.ifremer.tutti.util.Weights;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;

public class BigfinImportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(BigfinImportService.class);
    protected PersistenceService persistenceService;
    protected Caracteristic sizeCaracteristic;
    protected Caracteristic sexCaracteristic;
    protected Map<Sign, CaracteristicQualitativeValue> signsToCaracteristicValue;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.signsToCaracteristicValue = new HashMap<Sign, CaracteristicQualitativeValue>();
        this.sexCaracteristic = this.persistenceService.getSexCaracteristic();
        Sex.NONE.registerSign(this.sexCaracteristic, this.signsToCaracteristicValue);
        Sex.UNKNOWN.registerSign(this.sexCaracteristic, this.signsToCaracteristicValue);
        Sex.MALE.registerSign(this.sexCaracteristic, this.signsToCaracteristicValue);
        Sex.FEMALE.registerSign(this.sexCaracteristic, this.signsToCaracteristicValue);
        this.sizeCaracteristic = this.persistenceService.getSizeCategoryCaracteristic();
        Size.NOT_SIZED.registerSign(this.sizeCaracteristic, this.signsToCaracteristicValue);
        Size.SMALL.registerSign(this.sizeCaracteristic, this.signsToCaracteristicValue);
        Size.BIG.registerSign(this.sizeCaracteristic, this.signsToCaracteristicValue);
        Caracteristic vracHorsVracCaracteristic = this.persistenceService.getSortedUnsortedCaracteristic();
        VracHorsVrac.VRAC.registerSign(vracHorsVracCaracteristic, this.signsToCaracteristicValue);
        VracHorsVrac.HORS_VRAC.registerSign(vracHorsVracCaracteristic, this.signsToCaracteristicValue);
    }

    private BigfinImportContext prepareImportContext(File importFile, FishingOperation operation, CatchBatch catchBatch) {
        TuttiProtocol protocol = this.persistenceService.getProtocol();
        if (protocol == null) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.bigfinimport.error.no.protocol", (Object[])new Object[0]));
        }
        List<Species> allReferentSpecies = this.persistenceService.getAllReferentSpecies();
        TreeMap speciesBySurveyCode = Maps.newTreeMap();
        for (Species species : allReferentSpecies) {
            String surveyCode = species.getSurveyCode();
            if (StringUtils.isNotBlank((CharSequence)surveyCode)) {
                speciesBySurveyCode.put(surveyCode, species);
            }
            if (species.getRefTaxCode() == null) continue;
            speciesBySurveyCode.put(species.getRefTaxCode(), species);
        }
        TreeMap speciesProtocolBySurveyCode = Maps.newTreeMap();
        for (SpeciesProtocol speciesProtocol : protocol.getSpecies()) {
            if (StringUtils.isNotBlank((CharSequence)speciesProtocol.getSpeciesSurveyCode())) {
                speciesProtocolBySurveyCode.put(speciesProtocol.getSpeciesSurveyCode(), speciesProtocol);
                continue;
            }
            speciesProtocolBySurveyCode.put(speciesProtocol.getSpeciesReferenceTaxonId().toString(), speciesProtocol);
        }
        BatchContainer<SpeciesBatch> rootSpeciesBatch = this.persistenceService.getRootSpeciesBatch(operation.getId(), false);
        if (!rootSpeciesBatch.isEmptyChildren()) {
            Map speciesByReferenceTaxonId = Speciess.splitReferenceSpeciesByReferenceTaxonId(allReferentSpecies);
            for (SpeciesBatch speciesBatch : rootSpeciesBatch.getChildren()) {
                Species species = speciesBatch.getSpecies();
                Integer referenceTaxonId = species.getReferenceTaxonId();
                Preconditions.checkNotNull((Object)referenceTaxonId, (Object)("Can't have a null referenceTaxonId for species: " + species));
                Species species1 = (Species)speciesByReferenceTaxonId.get(referenceTaxonId.toString());
                this.consolidateSpecies(speciesBatch, species1);
            }
        }
        BigfinImportContext bigfinImportContext = new BigfinImportContext(importFile, operation, catchBatch, this.signsToCaracteristicValue, speciesBySurveyCode, speciesProtocolBySurveyCode, rootSpeciesBatch);
        return bigfinImportContext;
    }

    protected void consolidateSpecies(SpeciesBatch speciesBatch, Species species) {
        speciesBatch.setSpecies(species);
        if (!speciesBatch.isChildBatchsEmpty()) {
            for (SpeciesBatch childBatch : speciesBatch.getChildBatchs()) {
                this.consolidateSpecies(childBatch, species);
            }
        }
    }

    public BigfinImportResult importFile(File importFile, FishingOperation operation, CatchBatch catchBatch) {
        Preconditions.checkNotNull((Object)importFile);
        Preconditions.checkArgument((boolean)importFile.exists(), (Object)("Bigfin file " + importFile + " does not exist."));
        BigfinImportContext importContext = this.prepareImportContext(importFile, operation, catchBatch);
        BigfinDataRowModel importModel = new BigfinDataRowModel(importContext.speciesBySurveyCode, importContext.getSpeciesBatchesById());
        try (BufferedReader reader = Files.newReader((File)importFile, (Charset)Charsets.UTF_8);
             Import importer = Import.newImport((ImportModel)importModel, (Reader)reader);){
            for (BigfinDataRow bigfinDataRow : importer) {
                boolean rowIsSafe;
                if (log.isInfoEnabled()) {
                    log.info((Object)("Check row: " + bigfinDataRow.getRecordId()));
                }
                if (!(rowIsSafe = importContext.checkRow(bigfinDataRow))) continue;
                importContext.addRowToProcess(bigfinDataRow);
            }
        }
        catch (IOException e) {
            throw new ImportRuntimeException("Could not import bigfin data from file " + importFile, (Throwable)e);
        }
        if (importContext.isNoError()) {
            this.processSpeciesBatchRows(importContext);
            this.processSpeciesRows(importContext);
            this.addFileAsAttachment(importFile, importContext.catchBatch);
        }
        BigfinImportResult result = importContext.getResult();
        return result;
    }

    private void processSpeciesBatchRows(BigfinImportContext importContext) {
        BigfinImportResult result = importContext.getResult();
        Multimap<SpeciesBatch, BigfinDataRow> speciesBatchRowsBySpeciesBatch = importContext.getSpeciesBatchRowsBySpeciesBatch();
        for (SpeciesBatch batch : speciesBatchRowsBySpeciesBatch.keySet()) {
            List<SpeciesBatchFrequency> existingSpeciesFrequencies = this.persistenceService.getAllSpeciesBatchFrequency(batch.getId());
            Integer deletedNb = this.persistenceService.countFrequenciesNumber(existingSpeciesFrequencies, false);
            Collection bigfinDataRows = speciesBatchRowsBySpeciesBatch.get((Object)batch);
            Species species = importContext.getSpeciesWithSurveyCode(batch.getSpecies());
            Caracteristic lengthStepPmfm = importContext.getLengthStepPmfm(species, this.persistenceService);
            List<SpeciesBatchFrequency> frequencies = this.createFrequencies(batch, bigfinDataRows, lengthStepPmfm);
            this.persistenceService.saveSpeciesBatchFrequency(batch.getId(), frequencies);
            result.incrementNbFrequenciesDeleted(deletedNb != null ? deletedNb : 0);
            Integer importedNb = this.persistenceService.countFrequenciesNumber(frequencies, false);
            result.incrementNbFrequenciesImported(importedNb != null ? importedNb : 0);
        }
    }

    private void processSpeciesRows(BigfinImportContext importContext) {
        BigfinImportResult result = importContext.getResult();
        SampleCategoryModel sampleCategoryModel = this.context.getSampleCategoryModel();
        List samplingOrder = sampleCategoryModel.getSamplingOrder();
        ArrayList<Integer> pmfmIds = new ArrayList<Integer>();
        pmfmIds.add(PmfmId.SORTED_UNSORTED.getValue());
        ArrayList<Function<BigfinDataRow, Sign>> functions = new ArrayList<Function<BigfinDataRow, Sign>>();
        for (Integer categoryId : samplingOrder) {
            if (PmfmId.SIZE_CATEGORY.getValue().equals(categoryId)) {
                pmfmIds.add(categoryId);
                functions.add(Size.newExtractValueFunction());
                continue;
            }
            if (!PmfmId.SEX.getValue().equals(categoryId)) continue;
            pmfmIds.add(categoryId);
            functions.add(Sex.newExtractValueFunction());
        }
        ArrayList<Category> categories = new ArrayList<Category>();
        for (int i = 0; i < pmfmIds.size(); ++i) {
            Category category = new Category((Integer)pmfmIds.get(i), i < functions.size() ? (Function)functions.get(i) : null);
            categories.add(category);
        }
        Multimap<Species, SpeciesBatch> batchesBySpecies = importContext.getRootSpeciesBatchBySpecies();
        Multimap<Species, BigfinDataRow> rowsBySpecies = importContext.getSpeciesRowsBySpecies();
        for (Species species : rowsBySpecies.keySet()) {
            Caracteristic lengthStepPmfm = importContext.getLengthStepPmfm(species, this.persistenceService);
            Collection speciesRows = rowsBySpecies.get((Object)species);
            ImmutableListMultimap rowsByVracHorsVrac = Multimaps.index((Iterable)speciesRows, VracHorsVrac.newExtractValueFunction());
            Collection speciesBatches = batchesBySpecies.get((Object)species);
            ImmutableMap speciesBatchByVracHorsVrac = Maps.uniqueIndex((Iterable)speciesBatches, (Function)SpeciesBatchs.GET_SAMPLE_CATEGORY_VALUE);
            BrowseBatchesParameter commonParameter = new BrowseBatchesParameter(importContext.operation, species, lengthStepPmfm, categories, result);
            this.browseBatchesToAddFrequencies(commonParameter, null, 0, (Map<Serializable, SpeciesBatch>)speciesBatchByVracHorsVrac, (Multimap<Sign, BigfinDataRow>)rowsByVracHorsVrac);
        }
    }

    protected void browseBatchesToAddFrequencies(BrowseBatchesParameter commonParameter, SpeciesBatch parentBatch, int depth, Map<Serializable, SpeciesBatch> batchesByCaracteristic, Multimap<Sign, BigfinDataRow> rowsByCaracteristic) {
        Category category = commonParameter.getCategories().get(depth++);
        int parentSignChildrenNb = rowsByCaracteristic.keySet().size();
        for (Sign caracteristic : rowsByCaracteristic.keySet()) {
            Collection bigfinDataRows = rowsByCaracteristic.get((Object)caracteristic);
            SpeciesBatch batch = batchesByCaracteristic.get(this.signsToCaracteristicValue.get(caracteristic));
            boolean batchHasFrequencies = false;
            if (batch == null) {
                if (caracteristic.isNullEquivalent(parentSignChildrenNb)) {
                    batch = parentBatch;
                } else {
                    batch = this.createSpeciesBatch(commonParameter.getSpecies(), commonParameter.getOperation(), category.getPmfmId(), caracteristic, parentBatch != null ? parentBatch.getId() : null);
                    batch.setParentBatch(parentBatch);
                }
            } else {
                batch.setFishingOperation(commonParameter.getOperation());
                List<SpeciesBatchFrequency> frequencies = this.persistenceService.getAllSpeciesBatchFrequency(batch.getId());
                batchHasFrequencies = CollectionUtils.isNotEmpty(frequencies);
            }
            if (category.getCategoryValueGetter() == null) {
                if (CollectionUtils.isNotEmpty((Collection)batch.getChildBatchs())) {
                    commonParameter.getResult().addWarning(I18n.t((String)"tutti.service.bigfinImport.warning.species.tooCategorized", (Object[])new Object[]{commonParameter.getSpeciesLabel(), this.sizeCaracteristic.getParameterName(), this.sexCaracteristic.getParameterName()}));
                    continue;
                }
                Integer deletedNb = this.persistenceService.countFrequenciesNumber(this.persistenceService.getAllSpeciesBatchFrequency(batch.getId()), false);
                List<SpeciesBatchFrequency> frequencies = this.createFrequencies(batch, bigfinDataRows, commonParameter.getLengthStepPmfm());
                this.persistenceService.saveSpeciesBatchFrequency(batch.getId(), frequencies);
                commonParameter.getResult().incrementNbFrequenciesDeleted(deletedNb != null ? deletedNb : 0);
                Integer importedNb = this.persistenceService.countFrequenciesNumber(frequencies, false);
                commonParameter.getResult().incrementNbFrequenciesImported(importedNb != null ? importedNb : 0);
                continue;
            }
            if (batchHasFrequencies) {
                CaracteristicQualitativeValue qualitativeValue = this.signsToCaracteristicValue.get(caracteristic);
                commonParameter.getResult().addWarning(I18n.t((String)"tutti.service.bigfinImport.warning.species.batch.frequenciesOnHigherLevel", (Object[])new Object[]{commonParameter.getSpeciesLabel(), qualitativeValue.getName()}));
                continue;
            }
            List batchChildren = batch.getChildBatchs();
            ImmutableListMultimap rowsByNewCaracteristic = Multimaps.index((Iterable)bigfinDataRows, category.getCategoryValueGetter());
            HashMap<Serializable, SpeciesBatch> childrenByCaracteristic = new HashMap<Serializable, SpeciesBatch>();
            if (CollectionUtils.isNotEmpty((Collection)batchChildren)) {
                SpeciesBatch firstBatch = (SpeciesBatch)batchChildren.get(0);
                Integer categoryId = firstBatch.getSampleCategoryId();
                Category nextCategory = commonParameter.getCategories().get(depth);
                if (!nextCategory.getPmfmId().equals(categoryId)) {
                    Set signsSet = rowsByNewCaracteristic.keySet();
                    if (signsSet.size() == 1 && ((Sign)signsSet.iterator().next()).isNullEquivalent(parentSignChildrenNb)) {
                        category = commonParameter.getCategories().get(depth++);
                        rowsByNewCaracteristic = Multimaps.index((Iterable)bigfinDataRows, category.getCategoryValueGetter());
                        nextCategory = commonParameter.getCategories().get(depth);
                        if (!nextCategory.getPmfmId().equals(categoryId)) {
                            commonParameter.getResult().addWarning(I18n.t((String)"tutti.service.bigfinImport.warning.species.categoriesSkipped", (Object[])new Object[]{commonParameter.getSpeciesLabel(), this.sizeCaracteristic.getParameterName(), this.sexCaracteristic.getParameterName()}));
                            continue;
                        }
                    } else {
                        commonParameter.getResult().addWarning(I18n.t((String)"tutti.service.bigfinImport.warning.species.categorySkipped", (Object[])new Object[]{commonParameter.getSpeciesLabel(), this.persistenceService.getCaracteristic(nextCategory.getPmfmId()).getParameterName()}));
                        continue;
                    }
                }
                childrenByCaracteristic.putAll((Map<Serializable, SpeciesBatch>)Maps.uniqueIndex((Iterable)batchChildren, (Function)SpeciesBatchs.GET_SAMPLE_CATEGORY_VALUE));
            }
            this.browseBatchesToAddFrequencies(commonParameter, batch, depth, childrenByCaracteristic, (Multimap<Sign, BigfinDataRow>)rowsByNewCaracteristic);
        }
    }

    protected SpeciesBatch createSpeciesBatch(Species species, FishingOperation operation, Integer categoryId, Sign signs, String parentBatchId) {
        Preconditions.checkArgument((boolean)signs.getCategory().equals(categoryId));
        SpeciesBatch batch = SpeciesBatchs.newSpeciesBatch();
        batch.setSpecies(species);
        batch.setFishingOperation(operation);
        batch.setSampleCategoryId(categoryId);
        batch.setSampleCategoryValue((Serializable)this.signsToCaracteristicValue.get(signs));
        batch = this.persistenceService.createSpeciesBatch(batch, parentBatchId, true);
        return batch;
    }

    protected List<SpeciesBatchFrequency> createFrequencies(SpeciesBatch batch, Collection<BigfinDataRow> rows, Caracteristic lengthStepPmfm) {
        Preconditions.checkNotNull((Object)lengthStepPmfm);
        String unit = lengthStepPmfm.getUnit();
        Float precision = lengthStepPmfm.getPrecision();
        if (precision == null) {
            precision = Float.valueOf(1.0f);
        }
        ArrayListMultimap weightsByLengthStep = ArrayListMultimap.create();
        for (BigfinDataRow row : rows) {
            Float weight = row.getWeight();
            float length = row.getLength();
            if ("cm".equals(unit)) {
                length /= 10.0f;
            }
            int intValue = (int)(length * 10.0f);
            int intStep = (int)(precision.floatValue() * 10.0f);
            int correctIntStep = intValue - intValue % intStep;
            float lengthStep = (float)correctIntStep / 10.0f;
            weightsByLengthStep.put((Object)Float.valueOf(lengthStep), (Object)weight);
        }
        Collection weightValues = weightsByLengthStep.values();
        int weightValuesSize = weightValues.size();
        Collection notNullWeights = Collections2.filter((Collection)weightValues, (Predicate)new Predicate<Float>(){

            public boolean apply(Float input) {
                return input != null;
            }
        });
        int notNullWeightsSize = notNullWeights.size();
        if (notNullWeightsSize == 1) {
            float weight = ((Float)CollectionUtils.get((Iterable)notNullWeights, (int)0)).floatValue();
            batch.setWeight(Float.valueOf(weight));
            this.persistenceService.saveSpeciesBatch(batch);
        }
        boolean importWeights = weightValuesSize == notNullWeightsSize;
        ArrayList<SpeciesBatchFrequency> frequencies = new ArrayList<SpeciesBatchFrequency>();
        for (Float lengthStep : weightsByLengthStep.keySet()) {
            SpeciesBatchFrequency frequency = SpeciesBatchFrequencys.newSpeciesBatchFrequency();
            frequencies.add(frequency);
            frequency.setBatch(batch);
            frequency.setLengthStep(lengthStep);
            frequency.setLengthStepCaracteristic(lengthStepPmfm);
            List weights = weightsByLengthStep.get((Object)lengthStep);
            frequency.setNumber(Integer.valueOf(weights.size()));
            if (!importWeights) continue;
            float totalWeight = 0.0f;
            Iterator i$ = weights.iterator();
            while (i$.hasNext()) {
                float weight = ((Float)i$.next()).floatValue();
                totalWeight += weight;
            }
            if (!(totalWeight > 0.0f)) continue;
            totalWeight = Weights.roundKiloGram((float)(totalWeight / 1000.0f));
            frequency.setWeight(Float.valueOf(totalWeight));
        }
        return frequencies;
    }

    protected void addFileAsAttachment(File f, CatchBatch catchBatch) {
        Attachment attachment = Attachments.newAttachment();
        attachment.setObjectType(ObjectTypeCode.CATCH_BATCH);
        attachment.setObjectId(Integer.valueOf(catchBatch.getId()));
        attachment.setName(f.getName());
        String date = DateFormat.getDateTimeInstance().format(this.context.currentDate());
        String comment = I18n.t((String)"tutti.service.bigfin.import.attachment.comment", (Object[])new Object[]{date});
        attachment.setComment(comment);
        this.persistenceService.createAttachment(attachment, f);
    }

    private class BrowseBatchesParameter {
        private FishingOperation operation;
        private Species species;
        private Caracteristic lengthStepPmfm;
        private List<Category> categories;
        private BigfinImportResult result;
        private String speciesLabel;

        public BrowseBatchesParameter(FishingOperation operation, Species species, Caracteristic lengthStepPmfm, List<Category> categories, BigfinImportResult result) {
            this.operation = operation;
            this.species = species;
            this.lengthStepPmfm = lengthStepPmfm;
            this.categories = categories;
            this.result = result;
            this.speciesLabel = species.getSurveyCode();
            if (StringUtils.isBlank((CharSequence)this.speciesLabel)) {
                this.speciesLabel = species.getRefTaxCode();
            }
        }

        public FishingOperation getOperation() {
            return this.operation;
        }

        public Species getSpecies() {
            return this.species;
        }

        public Caracteristic getLengthStepPmfm() {
            return this.lengthStepPmfm;
        }

        public List<Category> getCategories() {
            return this.categories;
        }

        public BigfinImportResult getResult() {
            return this.result;
        }

        public String getSpeciesLabel() {
            return this.speciesLabel;
        }
    }

    private class Category {
        private Integer pmfmId;
        private Function<BigfinDataRow, Sign> categoryValueGetter;

        public Category(Integer pmfmId, Function<BigfinDataRow, Sign> dataGetter) {
            this.pmfmId = pmfmId;
            this.categoryValueGetter = dataGetter;
        }

        public Integer getPmfmId() {
            return this.pmfmId;
        }

        public Function<BigfinDataRow, Sign> getCategoryValueGetter() {
            return this.categoryValueGetter;
        }
    }
}

