/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.TuttiDataContext;
import fr.ifremer.tutti.service.TuttiValidationDataContextSupport;
import java.util.ArrayList;
import java.util.List;

public class TuttiValidationDataContext
extends TuttiValidationDataContextSupport {
    private final TuttiDataContext dataContext;

    public TuttiValidationDataContext(TuttiDataContext dataContext) {
        this.dataContext = dataContext;
    }

    @Override
    protected List<Program> loadExistingPrograms() {
        this.dataContext.checkOpened();
        ArrayList existingPrograms = Lists.newArrayList(this.dataContext.service.getAllProgram());
        if (this.dataContext.isProgramFilled()) {
            existingPrograms.remove(this.getProgram());
        }
        return existingPrograms;
    }

    @Override
    protected List<TuttiProtocol> loadExistingProtocols() {
        this.dataContext.checkOpened();
        ArrayList existingProtocols = Lists.newArrayList(this.dataContext.service.getAllProtocol());
        if (this.dataContext.isProtocolFilled()) {
            existingProtocols.remove(this.getProtocol());
        }
        return existingProtocols;
    }

    @Override
    protected List<FishingOperation> loadExistingFishingOperations() {
        this.dataContext.checkOpened();
        ArrayList existingFishingOperations = Lists.newArrayList(this.dataContext.service.getAllFishingOperation(this.dataContext.getCruiseId()));
        if (this.dataContext.isFishingOperationFilled()) {
            existingFishingOperations.remove(this.getFishingOperation());
        }
        return existingFishingOperations;
    }

    @Override
    protected Program getProgram() {
        return this.dataContext.getProgram();
    }

    @Override
    protected Cruise getCruise() {
        return this.dataContext.getCruise();
    }

    @Override
    protected TuttiProtocol getProtocol() {
        return this.dataContext.getProtocol();
    }

    @Override
    protected FishingOperation getFishingOperation() {
        return this.dataContext.getFishingOperation();
    }
}

