/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.genericformat.tree;

import fr.ifremer.tutti.ui.swing.content.genericformat.tree.CruiseSelectTreeNode;
import fr.ifremer.tutti.ui.swing.content.genericformat.tree.DataSelectTreeNodeSupport;
import fr.ifremer.tutti.ui.swing.content.genericformat.tree.OperationSelectTreeNode;
import fr.ifremer.tutti.ui.swing.content.genericformat.tree.ProgramSelectTreeNode;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DataSelectTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 1L;

    public static void installDataSelectionHandler(JTree tree) {
        DataSelectTreeNodeListener handler = new DataSelectTreeNodeListener();
        tree.addKeyListener(handler);
        tree.addMouseListener(handler);
    }

    public DataSelectTreeModel() {
        super(null);
    }

    @Override
    public ProgramSelectTreeNode getRoot() {
        return (ProgramSelectTreeNode)super.getRoot();
    }

    public boolean isDataSelected() {
        boolean dataSelected = false;
        if (this.getRoot() != null) {
            for (CruiseSelectTreeNode cruiseNode : this.getRoot()) {
                if (!cruiseNode.isSelected() && !cruiseNode.isPartialSelected()) continue;
                dataSelected = true;
                break;
            }
        }
        return dataSelected;
    }

    public void setSelected(DataSelectTreeNodeSupport node, boolean selected) {
        node.setSelected(selected);
        this.nodeChanged(node);
        if (node instanceof CruiseSelectTreeNode) {
            this.nodeStructureChanged(node);
        } else if (node instanceof OperationSelectTreeNode) {
            this.nodeChanged(node.getParent());
        }
    }

    public void select(DataSelectTreeNodeSupport node) {
        boolean selected = !node.isSelected();
        this.setSelected(node, selected);
    }

    public void selectAll() {
        for (CruiseSelectTreeNode cruiseNode : this.getRoot()) {
            this.setSelected(cruiseNode, true);
        }
    }

    public void unselectAll() {
        for (CruiseSelectTreeNode cruiseNode : this.getRoot()) {
            this.setSelected(cruiseNode, false);
        }
    }

    static class DataSelectTreeNodeListener
    implements KeyListener,
    MouseListener {
        DataSelectTreeNodeListener() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            JTree tree = (JTree)e.getSource();
            if (!tree.isSelectionEmpty()) {
                boolean doEdit;
                boolean bl = doEdit = e.getModifiers() == 0 && (e.getKeyCode() == 10 || e.getKeyCode() == 32);
                if (doEdit) {
                    TreePath selectionPath = tree.getSelectionPath();
                    this.doSelectNode(tree, selectionPath);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JTree tree = (JTree)e.getSource();
            if (!tree.isSelectionEmpty()) {
                boolean doEdit;
                TreePath selectionPath = tree.getSelectionPath();
                Rectangle bounds = tree.getPathBounds(selectionPath);
                int x = e.getX();
                boolean bl = doEdit = bounds != null && x >= bounds.x && x - 12 <= bounds.x;
                if (doEdit) {
                    this.doSelectNode(tree, selectionPath);
                }
            }
        }

        protected void doSelectNode(JTree tree, TreePath selectionPath) {
            DataSelectTreeNodeSupport lastPathComponent = (DataSelectTreeNodeSupport)selectionPath.getLastPathComponent();
            ((DataSelectTreeModel)tree.getModel()).select(lastPathComponent);
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

